/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extract.models;

import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.extract.ExtractResources;
import oracle.dbtools.extract.models.ExtractDataFormat;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.raptor.extract.models.ExtractListModelHelper;
import oracle.dbtools.raptor.format.IResultFormatter;

public class ExtractDataFormatHelper {
    public static DefaultMutableTreeNode getSummaryNode(ExtractListModel extractListModel, ExtractDataFormat extractDataFormat) {
        IResultFormatter iResultFormatter = extractDataFormat.getFormatter();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(ExtractResources.getString((String)"DATA_OPTIONS"));
        if (extractListModel.getGlobalWhere() != "") {
            ExtractListModelHelper extractListModelHelper = new ExtractListModelHelper(extractListModel);
            defaultMutableTreeNode.add(extractListModelHelper.getSummaryGlobalWhere());
        }
        if (iResultFormatter != null) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(ExtractResources.getString((String)"FORMAT") + ": " + iResultFormatter.getType()));
            if (iResultFormatter.isHeaderOptionSupported()) {
                defaultMutableTreeNode.add(ExtractListModelHelper.getSummaryBooleanItem(ExtractResources.getString((String)"HEADER"), extractDataFormat.getHeader()));
            }
            if (iResultFormatter.isDelimiterSupported()) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(ExtractResources.getString((String)"DELIMITER") + ": " + extractDataFormat.getDelimiter()));
            }
            if (iResultFormatter.isEnclosuresSupported()) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(ExtractResources.getString((String)"ENCLOSURE_LEFT") + ": " + extractDataFormat.getEnclosureLeft()));
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(ExtractResources.getString((String)"ENCLOSURE_RIGHT") + ": " + extractDataFormat.getEnclosureRight()));
            }
            if (iResultFormatter.isLineTerminatorSupported()) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(ExtractResources.getString((String)"RECORD_TERMINATOR") + ": " + extractDataFormat.getRecordTerminator()));
            }
            if (iResultFormatter.isSeparateDataFileSupported()) {
                defaultMutableTreeNode.add(ExtractListModelHelper.getSummaryBooleanItem(ExtractResources.getString((String)"SEPARATE_DATA_FILE"), extractDataFormat.isSeparateDataFile()));
            }
            if (iResultFormatter.isDataNameSupported()) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(ExtractResources.getString((String)"WORKSHEET_NAME") + ": " + extractDataFormat.getDataName()));
            }
            if (iResultFormatter.isQuerySupported()) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(ExtractResources.getString((String)"QUERY_NAME") + ": " + extractDataFormat.getQueryName()));
                defaultMutableTreeNode.add(ExtractListModelHelper.getSummaryBooleanItem(ExtractResources.getString((String)"SAVE_QUERY"), extractDataFormat.isQuerySaved()));
            }
        }
        return defaultMutableTreeNode;
    }
}

