/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dbdiff.editor.tree;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.common.ddl.DDLTypes;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.raptor.dbdiff.editor.tree.CheckTreeManager;
import oracle.dbtools.raptor.dbdiff.editor.tree.CheckTreeSelectionModel;
import oracle.dbtools.raptor.dbdiff.models.DbDiffObject;
import oracle.dbtools.raptor.ddl.DDLTypesHelper;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.db.util.IconWithSmallOverlay;
import oracle.javatools.icons.OracleIcons;

public class DbDiffCheckTree {
    private CustomJTree _tree;
    private DefaultTreeModel _model;
    private DefaultMutableTreeNode _root;
    private LinkedList<DbDiffObject> _diffObjects;
    private boolean _isShowEquals;
    private String _connDisplayName;
    CheckTreeManager _checkTreeManager;

    public DbDiffCheckTree(LinkedList<DbDiffObject> linkedList) {
        this._diffObjects = linkedList;
        this._connDisplayName = "";
        if (linkedList != null && linkedList.isEmpty()) {
            return;
        }
        if (this._diffObjects.getFirst() != null) {
            this._connDisplayName = Connections.getDisplayName(Connections.getInstance().getConnectionName(this._diffObjects.getFirst().getExtractObject().getListModel().getSourceConn()));
        }
    }

    public boolean isShowEquals() {
        return this._isShowEquals;
    }

    public CheckTreeManager getCheckTreeManager() {
        return this._checkTreeManager;
    }

    public void isShowEquals(boolean bl) {
        this._isShowEquals = bl;
    }

    public DefaultTreeModel getModel() {
        return this._model;
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this._tree.addTreeSelectionListener(treeSelectionListener);
    }

    public void removeTreeListener(TreeSelectionListener treeSelectionListener) {
        this._tree.removeTreeSelectionListener(treeSelectionListener);
    }

    public DbDiffObject getSelectedDifference() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object object;
        TreePath treePath = this._tree.getSelectionPath();
        if (treePath != null && (object = (defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof DbDiffObject) {
            return (DbDiffObject)object;
        }
        return null;
    }

    public void refreshModel(boolean bl, boolean bl2) {
        this._root.removeAllChildren();
        this.addDiffObjectsToTree(bl, bl2);
        for (int i = 0; i < this._tree.getRowCount(); ++i) {
            this._tree.expandRow(i);
        }
        this.getTree().validate();
    }

    public JTree getTree() {
        if (this._tree != null) {
            return this._tree;
        }
        this._root = new DefaultMutableTreeNode("CONNECTION");
        this._model = new DefaultTreeModel(this._root);
        this._tree = new CustomJTree((TreeModel)this._model);
        this._tree.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        this.addDiffObjectsToTree(false, true);
        this._checkTreeManager = new CheckTreeManager((JTree)this._tree);
        TreePath treePath = new TreePath(this._tree.getModel().getRoot());
        CheckTreeSelectionModel checkTreeSelectionModel = this._checkTreeManager.getSelectionModel();
        checkTreeSelectionModel.addSelectionPaths(new TreePath[]{treePath});
        for (int i = 0; i < this._tree.getRowCount(); ++i) {
            this._tree.expandRow(i);
        }
        return this._tree;
    }

    private void addDiffObjectsToTree(boolean bl, boolean bl2) {
        if (this._diffObjects == null) {
            return;
        }
        String string = "";
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        for (DbDiffObject dbDiffObject : this._diffObjects) {
            if (!dbDiffObject.getObjectType().equals(string)) {
                string = dbDiffObject.getObjectType();
                defaultMutableTreeNode = new DefaultMutableTreeNode(string);
                this._root.add(defaultMutableTreeNode);
            }
            if (bl) {
                if (!bl2 && !dbDiffObject.getExtractObject().isExistsDest()) continue;
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(dbDiffObject));
                continue;
            }
            if (bl2) {
                if (!dbDiffObject.isChanged() && dbDiffObject.getExtractObject().isExistsDest()) continue;
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(dbDiffObject));
                continue;
            }
            if (!dbDiffObject.isChanged()) continue;
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(dbDiffObject));
        }
        this.getModel().nodeStructureChanged(this._root);
    }

    class NodeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        NodeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setOpaque(true);
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            jPanel.add("Center", jLabel);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof String) {
                String string = (String)((DefaultMutableTreeNode)object).getUserObject();
                if (string.equals("CONNECTION")) {
                    jLabel.setText(DbDiffCheckTree.this._connDisplayName);
                    jLabel.setIcon(DDLTypesHelper.getFolderIcon((String)object2));
                } else {
                    jLabel.setText(DDLTypes.getFolderName((String)((String)object2)));
                    jLabel.setIcon(DDLTypesHelper.getFolderIcon((String)object2));
                }
            } else {
                if (object2 instanceof DbDiffObject) {
                    DbDiffObject dbDiffObject = (DbDiffObject)object2;
                    jLabel.setText(dbDiffObject.getObjectName());
                    Icon icon = DBURLFormatHelper.getIcon(dbDiffObject.getDbObject().getURL());
                    ExtractObject extractObject = dbDiffObject.getExtractObject();
                    if (!dbDiffObject.isAvailable()) {
                        jLabel.setIcon((Icon)new IconWithSmallOverlay(icon, OracleIcons.getIcon((String)"exception.png")));
                    } else if (extractObject.isExistsSource() && !extractObject.isExistsDest()) {
                        jLabel.setIcon((Icon)new IconWithSmallOverlay(icon, OracleIcons.getIcon((String)"add.png")));
                    } else if (extractObject.isExistsDest() && !extractObject.isExistsSource()) {
                        jLabel.setIcon((Icon)new IconWithSmallOverlay(icon, OracleIcons.getIcon((String)"delete.png")));
                    } else if (dbDiffObject.isChanged()) {
                        jLabel.setIcon((Icon)new IconWithSmallOverlay(icon, OracleIcons.getIcon((String)"warning.png")));
                    } else {
                        jLabel.setIcon(icon);
                    }
                    return jPanel;
                }
                jLabel.setText(object == null ? "" : object.toString());
                jLabel.setForeground(Color.RED);
                String string = "Internal: Unexpected node type: " + object;
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, string);
            }
            return jPanel;
        }
    }
}

