/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.ui;

import java.awt.Component;
import java.awt.Container;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.ui.cell.BaseCellEditor;
import oracle.dbtools.raptor.datatypes.ui.cell.BaseCellRenderer;
import oracle.dbtools.raptor.datatypes.ui.cell.BooleanCellEditor;
import oracle.dbtools.raptor.datatypes.ui.cell.CompositeTypeCustomCellEditor;
import oracle.dbtools.raptor.datatypes.ui.cell.DateCustomCellEditor;
import oracle.dbtools.raptor.datatypes.ui.cell.INTERVALDSCustomCellEditor;
import oracle.dbtools.raptor.datatypes.ui.cell.INTERVALYMCustomCellEditor;
import oracle.dbtools.raptor.datatypes.ui.cell.LargeBinaryCustomCellEditor;
import oracle.dbtools.raptor.datatypes.ui.cell.LongCharCustomCellEditor;
import oracle.dbtools.raptor.datatypes.ui.cell.TIMESTAMPLTZCustomCellEditor;
import oracle.dbtools.raptor.datatypes.ui.cell.TIMESTAMPTZCustomCellEditor;
import oracle.dbtools.raptor.datatypes.ui.cell.TimestampCustomCellEditor;

public class DataValueUtils {
    private static final Map<String, Class<? extends BaseCellEditor>> _cellEditors = new HashMap<String, Class<? extends BaseCellEditor>>(){
        {
            this.put("BLOB", LargeBinaryCustomCellEditor.class);
            this.put("CHAR", LongCharCustomCellEditor.class);
            this.put("CHAR VARYING", LongCharCustomCellEditor.class);
            this.put("CLOB", LongCharCustomCellEditor.class);
            this.put("DATE", DateCustomCellEditor.class);
            this.put("INTERVAL DAY TO SECOND", INTERVALDSCustomCellEditor.class);
            this.put("INTERVAL YEAR TO MONTH", INTERVALYMCustomCellEditor.class);
            this.put("LONG", LongCharCustomCellEditor.class);
            this.put("LONG RAW", LargeBinaryCustomCellEditor.class);
            this.put("NCHAR", LongCharCustomCellEditor.class);
            this.put("NCHAR VARYING", LongCharCustomCellEditor.class);
            this.put("NCLOB", LongCharCustomCellEditor.class);
            this.put("NVARCHAR", LongCharCustomCellEditor.class);
            this.put("NVARCHAR2", LongCharCustomCellEditor.class);
            this.put("PL/SQL BOOLEAN", BooleanCellEditor.class);
            this.put("PL/SQL RECORD", CompositeTypeCustomCellEditor.class);
            this.put("PL/SQL TABLE", CompositeTypeCustomCellEditor.class);
            this.put("RAW", LargeBinaryCustomCellEditor.class);
            this.put("TABLE", CompositeTypeCustomCellEditor.class);
            this.put("TIMESTAMP", TimestampCustomCellEditor.class);
            this.put("TIMESTAMP WITH LOCAL TIME ZONE", TIMESTAMPLTZCustomCellEditor.class);
            this.put("TIMESTAMP WITH TIME ZONE", TIMESTAMPTZCustomCellEditor.class);
            this.put("VARCHAR", LongCharCustomCellEditor.class);
            this.put("VARCHAR2", LongCharCustomCellEditor.class);
            this.put("VARRAY", CompositeTypeCustomCellEditor.class);
            this.put("STRUCT", CompositeTypeCustomCellEditor.class);
            this.put("OBJECT", CompositeTypeCustomCellEditor.class);
            this.put("REF CURSOR", LongCharCustomCellEditor.class);
        }
    };
    private static final Map<String, Class<? extends BaseCellRenderer>> _cellRenderers = new HashMap<String, Class<? extends BaseCellRenderer>>(){};

    public static TableCellEditor getTableCellEditor(DataValue dataValue) {
        List<DataValue> list = Collections.emptyList();
        return DataValueUtils.getTableCellEditor(dataValue, list);
    }

    public static TableCellEditor getTableCellEditor(DataValue dataValue, List<DataValue> list) {
        return DataValueUtils.getTableCellEditor(dataValue, list, null);
    }

    public static TableCellEditor getTableCellEditor(DataValue dataValue, Properties properties) {
        List<DataValue> list = Collections.emptyList();
        return DataValueUtils.getTableCellEditor(dataValue, list, properties);
    }

    public static TableCellEditor getTableCellEditor(DataValue dataValue, List<DataValue> list, Properties properties) {
        if (null == dataValue) {
            return null;
        }
        BaseCellEditor baseCellEditor = null;
        DataType dataType = dataValue.getDataType();
        String string = dataType.getBaseDataTypeString();
        Class<? extends BaseCellEditor> clazz = _cellEditors.get(string);
        if (clazz == null) {
            clazz = BaseCellEditor.class;
        }
        try {
            baseCellEditor = clazz.newInstance();
        }
        catch (Exception exception) {
            Logger.getLogger(DataValueUtils.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        if (null != baseCellEditor) {
            baseCellEditor.configure(dataType, properties);
        }
        LinkedList<DataValue> linkedList = new LinkedList<DataValue>();
        linkedList.addAll(list);
        DataValue dataValue2 = dataType.getDataValue(null);
        if (dataValue2.isNull() && !linkedList.contains(dataValue2)) {
            linkedList.add(dataValue2);
        }
        if (dataType.isEnumeration()) {
            for (DataValue object2 : dataType.getEnumerationValues()) {
                if (linkedList.contains(object2)) continue;
                linkedList.add(object2);
            }
        }
        if (!linkedList.contains(dataValue)) {
            linkedList.add(0, dataValue);
        }
        Object object = null;
        if (linkedList.size() > 0) {
            object = new JComboBox<Object>(linkedList.toArray());
            ((JComponent)object).setBorder(BorderFactory.createEmptyBorder());
            ((Component)object).setName("CellEditorCombo");
            for (Component component : ((Container)object).getComponents()) {
                if (!(component instanceof JButton)) continue;
                ((JButton)component).setName("CellEditorCombo.SelectButton");
                break;
            }
            ((JComboBox)object).setSelectedIndex(linkedList.indexOf(dataValue));
            ((JComboBox)object).setRenderer(DataValueUtils.getCellRenderer(dataValue));
            if (!dataType.isEnumeration()) {
                Component component = baseCellEditor.getComponent();
                if (component instanceof JComponent) {
                    JComponent jComponent = (JComponent)component;
                    jComponent.setBorder(BorderFactory.createEmptyBorder());
                }
                ((JComboBox)object).setEditor(baseCellEditor);
                ((JComboBox)object).setEditable(true);
            }
            baseCellEditor = new BaseCellEditor((JComboBox)object);
        }
        return baseCellEditor;
    }

    public static TableCellEditor getTableCellEditor(DataType dataType, List<DataValue> list) {
        if (null == dataType) {
            return null;
        }
        BaseCellEditor baseCellEditor = null;
        String string = dataType.getBaseDataTypeString();
        Class<? extends BaseCellEditor> clazz = _cellEditors.get(string);
        if (clazz == null) {
            clazz = BaseCellEditor.class;
        }
        try {
            baseCellEditor = clazz.newInstance();
        }
        catch (Exception exception) {
            Logger.getLogger(DataValueUtils.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        if (null != baseCellEditor) {
            baseCellEditor.configure(dataType);
        }
        LinkedList<DataValue> linkedList = new LinkedList<DataValue>();
        linkedList.addAll(list);
        DataValue dataValue = dataType.getDataValue(null);
        if (dataValue.isNull() && !linkedList.contains(dataValue)) {
            linkedList.add(dataValue);
        }
        if (dataType.isEnumeration()) {
            for (DataValue object2 : dataType.getEnumerationValues()) {
                if (linkedList.contains(object2)) continue;
                linkedList.add(object2);
            }
        }
        Object object = null;
        if (linkedList.size() > 0) {
            object = new JComboBox<Object>(linkedList.toArray());
            ((JComponent)object).setBorder(BorderFactory.createEmptyBorder());
            ((Component)object).setName("CellEditorCombo");
            for (Component component : ((Container)object).getComponents()) {
                if (!(component instanceof JButton)) continue;
                ((JButton)component).setName("CellEditorCombo.SelectButton");
                break;
            }
            ((JComboBox)object).setRenderer(DataValueUtils.getCellRenderer(dataType));
            if (!dataType.isEnumeration()) {
                Component component = baseCellEditor.getComponent();
                if (component instanceof JComponent) {
                    JComponent jComponent = (JComponent)component;
                    jComponent.setBorder(BorderFactory.createEmptyBorder());
                }
                ((JComboBox)object).setEditor(baseCellEditor);
                ((JComboBox)object).setEditable(true);
            }
            baseCellEditor = new BaseCellEditor((JComboBox)object);
        }
        return baseCellEditor;
    }

    public static TableCellRenderer getTableCellRenderer(DataValue dataValue) {
        return DataValueUtils.getCellRenderer(dataValue);
    }

    public static BaseCellRenderer getCellRenderer(DataValue dataValue) {
        if (null == dataValue) {
            return null;
        }
        return DataValueUtils.getCellRenderer(dataValue.getDataType());
    }

    public static BaseCellRenderer getCellRenderer(DataType dataType) {
        if (null == dataType) {
            return null;
        }
        BaseCellRenderer baseCellRenderer = null;
        String string = dataType.getBaseDataTypeString();
        Class<? extends BaseCellRenderer> clazz = _cellRenderers.get(string);
        if (clazz == null) {
            clazz = BaseCellRenderer.class;
        }
        try {
            baseCellRenderer = clazz.newInstance();
        }
        catch (Exception exception) {
            Logger.getLogger(DataValueUtils.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        if (null != baseCellRenderer) {
            baseCellRenderer.configure(dataType);
        }
        return baseCellRenderer;
    }
}

