/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.databasecopy.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.raptor.databasecopy.wizard.CopyDatabaseCommon;
import oracle.dbtools.raptor.databasecopy.wizard.CopyWizArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;

public class CopyWizTableSpacePanel
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private JWrappedLabel m_initialText = new JWrappedLabel();
    private final JCheckBox m_chkbxToSummary = new JCheckBox();
    private JPanel m_tablespacePanel = new JPanel();
    private JComboBox m_sourceTablespace = new JComboBox();
    private JComboBox m_destTablespace = new JComboBox();
    private String m_wizardType;
    private String m_srcConn;
    private String m_destConn;
    private boolean m_getChkbxCopyDDL = false;
    private boolean m_getChkbxCopyData = false;
    private ExtractListModel m_listModel;

    public CopyWizTableSpacePanel() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.m_initialText.setText(StringUtils.stripMnemonic((String)CopyWizArb.getString("TABLESPACE_DESC")));
        this.m_chkbxToSummary.setText(StringUtils.stripMnemonic((String)CopyWizArb.getString("GOTO_SUMMARY")));
        this.m_chkbxToSummary.setEnabled(false);
        JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)CopyWizArb.getString("SOURCE_TABLESPACE_LABEL")));
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)CopyWizArb.getString("SOURCE_TABLESPACE_LABEL")));
        jLabel.setLabelFor(this.m_sourceTablespace);
        JLabel jLabel2 = new JLabel(StringUtils.stripMnemonic((String)CopyWizArb.getString("DESTINATION_TABLESPACE_LABEL")));
        jLabel2.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)CopyWizArb.getString("DESTINATION_TABLESPACE_LABEL")));
        jLabel2.setLabelFor(this.m_destTablespace);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, new Insets(16, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.m_sourceTablespace, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 22, 2, new Insets(16, 8, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 2, new Insets(6, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.m_destTablespace, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 22, 2, new Insets(6, 8, 0, 0), 0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 20, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)this.m_initialText, "North");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0));
        jPanel4.add((Component)this.m_chkbxToSummary, "South");
        this.add(jPanel3, "North");
        this.add(jPanel4, "South");
        this.add(jPanel, "Center");
        this.m_sourceTablespace.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    // empty if block
                }
            }
        });
        this.m_destTablespace.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    // empty if block
                }
            }
        });
    }

    public void onEntry(TraversableContext traversableContext) {
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true));
        this.m_listModel = (ExtractListModel)traversableContext.get("EXTRACT_LIST_MODEL");
        this.m_getChkbxCopyDDL = (Boolean)traversableContext.get("DATABASE_COPY_DDL_ENABLED");
        this.m_getChkbxCopyData = (Boolean)traversableContext.get("DATABASE_COPY_DATA_ENABLED");
        this.m_srcConn = (String)traversableContext.get("DATABASE_COPY_SOURCE_CONNECTION_NAME");
        this.m_destConn = (String)traversableContext.get("DATABASE_COPY_DESTINATION_CONNECTION_NAME");
        this.m_wizardType = (String)traversableContext.get("WIZARD_TYPE");
        this.m_sourceTablespace.setModel(new DefaultComboBoxModel<String>(this.getTableSpaceNames(this.m_srcConn)));
        this.m_destTablespace.setModel(new DefaultComboBoxModel<String>(this.getTableSpaceNames(this.m_destConn)));
        String[] stringArray = (String[])traversableContext.get("SOURCE_TABLESPACES");
        if (stringArray == null || stringArray.length == 0) {
            this.m_sourceTablespace.setSelectedItem(null);
        } else {
            this.m_sourceTablespace.setSelectedItem(((String[])traversableContext.get("SOURCE_TABLESPACES"))[0]);
        }
        this.m_destTablespace.setSelectedItem((String)traversableContext.get("DESTINATION_TABLESPACE"));
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        traversableContext.getWizardCallbacks().wizardSetInitialFocus((Component)((Object)this));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            if (this.getSourceTablespaceName() == null) {
                throw new TraversalException(CopyWizArb.getString("NO_SOURCE_TABLESPACE"));
            }
            if (this.getDestinationTablespaceName() == null) {
                throw new TraversalException(CopyWizArb.getString("NO_DEST_TABLESPACE"));
            }
            traversableContext.put("SOURCE_TABLESPACES", (Object)this.getSourceTablespaceName());
            traversableContext.put("DESTINATION_TABLESPACE", (Object)this.getDestinationTablespaceName());
            traversableContext.put("TABLESPACE_SCHEMAS", (Object)this.getTableSpaceSchemaNames(this.m_srcConn, this.getSourceTablespaceName()[0]));
        }
        if (this.m_listModel.getTablespaces() != null) {
            if (!((Boolean)traversableContext.get("EXTRACT_LIST_UPDATED")).booleanValue() && CopyDatabaseCommon.compareStringList(this.m_listModel.getTablespaces(), this.getSourceTablespaceName())) {
                traversableContext.put("EXTRACT_LIST_UPDATED", (Object)false);
            } else {
                traversableContext.put("EXTRACT_LIST_UPDATED", (Object)true);
            }
        } else {
            this.m_listModel.setTablespaces(this.getSourceTablespaceName());
            traversableContext.put("EXTRACT_LIST_UPDATED", (Object)false);
        }
    }

    public Object getExitTransition() {
        return this.getTransition();
    }

    private Object getTransition() {
        if (this.m_chkbxToSummary.isSelected()) {
            return "Finish";
        }
        if (this.m_getChkbxCopyDDL) {
            return "TransitionSpecifyObjectTypes";
        }
        if (this.m_getChkbxCopyData) {
            return "TransitionData";
        }
        return "Finish";
    }

    private String[] getSourceTablespaceName() {
        try {
            String[] stringArray = new String[]{this.m_sourceTablespace.getSelectedItem().toString()};
            return stringArray;
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            return null;
        }
    }

    private String getDestinationTablespaceName() {
        try {
            return this.m_destTablespace.getSelectedItem().toString();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            return null;
        }
    }

    private String[] getTableSpaceNames(String string) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            stringArray = Connections.getInstance().getConnection(string);
            PreparedStatement preparedStatement = stringArray.prepareStatement("select tablespace_name from dba_tablespaces order by tablespace_name");
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString("tablespace_name");
                if (string2 == null) continue;
                arrayList.add(string2);
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        catch (DBException dBException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private String[] getTableSpaceSchemaNames(String string, String string2) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            stringArray = Connections.getInstance().getConnection(string);
            PreparedStatement preparedStatement = stringArray.prepareStatement("select distinct owner from dba_segments where tablespace_name = '" + string2 + "'");
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string3 = resultSet.getString("owner");
                if (string3 == null) continue;
                arrayList.add(string3);
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        catch (DBException dBException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }
}

