/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.databasecopy.wizard;

import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.raptor.databasecopy.CopyAPI;
import oracle.dbtools.raptor.databasecopy.ObjectsCopy;
import oracle.dbtools.raptor.databasecopy.SchemasCopy;
import oracle.dbtools.raptor.databasecopy.TablespaceCopy;
import oracle.dbtools.raptor.databasecopy.wizard.CopyWizArb;
import oracle.dbtools.raptor.extract.models.ExtractListModelHelper;
import oracle.dbtools.raptor.extract.ui.wizard.ExtractWizSummaryPanel;
import oracle.dbtools.raptor.utils.MnemonicUtil;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.icons.OracleIcons;

public class CopyWizSummaryPage
extends ExtractWizSummaryPanel {
    private CopyAPI copyApi;
    private ExtractListModel m_listModel;
    private TraversableContext m_dataContext;
    private HashMap<String, Boolean> m_selectedOptions = new HashMap();

    @Override
    public void onEntry(TraversableContext traversableContext) {
        this.m_dataContext = traversableContext;
        this.setAllSelectedOptions(traversableContext);
        if (this.m_selectedOptions.get("DATABASE_COPY_OBJECTS_COPY").booleanValue()) {
            this.copyApi = new ObjectsCopy(this.m_selectedOptions);
        } else if (this.m_selectedOptions.get("DATABASE_COPY_SCHEMAS_COPY").booleanValue()) {
            this.copyApi = new SchemasCopy(this.m_selectedOptions);
        } else if (this.m_selectedOptions.get("DATABASE_COPY_TABLESPACE").booleanValue()) {
            this.copyApi = new TablespaceCopy(this.m_selectedOptions);
            this.copyApi.setDestinationTablespace((String)traversableContext.get("DESTINATION_TABLESPACE"));
        }
        this.m_listModel = (ExtractListModel)traversableContext.get("EXTRACT_LIST_MODEL");
        this.copyApi.setExtractListModel(this.m_listModel);
        this.summary.removeAll();
        this.summary.setModel(this.getSummaryTreeModel(CopyWizArb.getString("DATABASECOPY_SUMMARY")));
        super.onEntry(traversableContext);
    }

    @Override
    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            this.copyApi.setDatabaseCopy();
            this.copyApi.startDatabaseCopyWithDialog();
        }
    }

    public void setAllSelectedOptions(TraversableContext traversableContext) {
        this.m_selectedOptions.put("DATABASE_COPY_OBJECTS_COPY", (Boolean)traversableContext.get("DATABASE_COPY_OBJECTS_COPY"));
        this.m_selectedOptions.put("DATABASE_COPY_SCHEMAS_COPY", (Boolean)traversableContext.get("DATABASE_COPY_SCHEMAS_COPY"));
        this.m_selectedOptions.put("DATABASE_COPY_TABLESPACE", (Boolean)traversableContext.get("DATABASE_COPY_TABLESPACE"));
        this.m_selectedOptions.put("MAINTAIN_SCHEMAS", (Boolean)traversableContext.get("MAINTAIN_SCHEMAS"));
        this.m_selectedOptions.put("CONSOLIDATE_SCHEMA", (Boolean)traversableContext.get("CONSOLIDATE_SCHEMA"));
        this.m_selectedOptions.put("DATABASE_COPY_DDL_ENABLED", (Boolean)traversableContext.get("DATABASE_COPY_DDL_ENABLED"));
        this.m_selectedOptions.put("DATABASE_COPY_DDL_DO_NOT_REPLACE", (Boolean)traversableContext.get("DATABASE_COPY_DDL_DO_NOT_REPLACE"));
        this.m_selectedOptions.put("DATABASE_COPY_DDL_DO_REPLACE", (Boolean)traversableContext.get("DATABASE_COPY_DDL_DO_REPLACE"));
        this.m_selectedOptions.put("DATABASE_COPY_DDL_IGNORE_STORAGE", (Boolean)traversableContext.get("DATABASE_COPY_DDL_IGNORE_STORAGE"));
        this.m_selectedOptions.put("DATABASE_COPY_DATA_ENABLED", (Boolean)traversableContext.get("DATABASE_COPY_DATA_ENABLED"));
        this.m_selectedOptions.put("DATABASE_COPY_DATA_TRUNCATE_ENABLED", (Boolean)traversableContext.get("DATABASE_COPY_DATA_TRUNCATE_ENABLED"));
    }

    public DefaultTreeModel getSummaryTreeModel(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        ExtractListModelHelper extractListModelHelper = new ExtractListModelHelper(this.m_listModel);
        defaultMutableTreeNode.add(extractListModelHelper.getConnectionsNode());
        defaultMutableTreeNode.add(this.getOptionsSummaryNode());
        if (Boolean.valueOf(this.m_selectedOptions.get("DATABASE_COPY_TABLESPACE")).booleanValue()) {
            defaultMutableTreeNode.add(this.getTableSpaceNode());
        }
        if (Boolean.valueOf(this.m_selectedOptions.get("DATABASE_COPY_SCHEMAS_COPY")).booleanValue()) {
            defaultMutableTreeNode.add(this.getSchemasNode());
        }
        if (Boolean.valueOf(this.m_selectedOptions.get("DATABASE_COPY_DDL_ENABLED")).booleanValue()) {
            defaultMutableTreeNode.add(this.getDdlSummaryNode());
            defaultMutableTreeNode.add(extractListModelHelper.getMetaNode());
        }
        if (Boolean.valueOf(this.m_selectedOptions.get("DATABASE_COPY_DATA_ENABLED")).booleanValue()) {
            defaultMutableTreeNode.add(this.getDataSummaryNode());
            defaultMutableTreeNode.add(extractListModelHelper.getDataFormatNode());
            defaultMutableTreeNode.add(extractListModelHelper.getDataNode());
        }
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    public DefaultMutableTreeNode getOptionsSummaryNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(CopyWizArb.getString("DATABASECOPY_OPTIONS"));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem("OBJECTS_COPY", this.m_selectedOptions.get("DATABASE_COPY_OBJECTS_COPY"))));
        boolean bl = this.m_selectedOptions.get("DATABASE_COPY_SCHEMAS_COPY");
        if (!bl) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem("SCHEMAS_COPY", bl)));
        } else {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.getSummaryNLSItem("SCHEMAS_COPY", bl));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.getSummaryNLSItem("MAINTAIN_SCHEMAS", this.m_selectedOptions.get("MAINTAIN_SCHEMAS"))));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.getSummaryNLSItem("CONSOLIDATE_SCHEMA", this.m_selectedOptions.get("CONSOLIDATE_SCHEMA"))));
        }
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem("TABLESPACE_COPY", this.m_selectedOptions.get("DATABASE_COPY_TABLESPACE"))));
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getDdlSummaryNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(MnemonicUtil.extractLabelTextWithoutMnemonic(CopyWizArb.getString("COPY_DDL_OPTION")));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem("DO_REPLACE_DEST", this.m_selectedOptions.get("DATABASE_COPY_DDL_DO_REPLACE"))));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem("IGNORE_STORAGE", this.m_selectedOptions.get("DATABASE_COPY_DDL_IGNORE_STORAGE"))));
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getDataSummaryNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(MnemonicUtil.extractLabelTextWithoutMnemonic(CopyWizArb.getString("COPY_DATA_OPTION")));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem("TRUNCATE_DATA_COPY", this.m_selectedOptions.get("DATABASE_COPY_DATA_TRUNCATE_ENABLED"))));
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getTableSpaceNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(CopyWizArb.getString("TABLESPACE_INFO"));
        JLabel jLabel = new JLabel();
        String[] stringArray = this.m_listModel.getTablespaces();
        jLabel.setText(StringUtils.stripMnemonic((String)CopyWizArb.getString("SOURCE_TABLESPACE_LABEL")) + " " + stringArray[0]);
        jLabel.setIcon(OracleIcons.getIcon((String)"tablespace.png"));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(jLabel));
        JLabel jLabel2 = new JLabel();
        String string = (String)this.m_dataContext.get("DESTINATION_TABLESPACE");
        jLabel2.setText(StringUtils.stripMnemonic((String)CopyWizArb.getString("DESTINATION_TABLESPACE_LABEL")) + " " + string);
        jLabel2.setIcon(OracleIcons.getIcon((String)"tablespace.png"));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(jLabel2));
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getSchemasNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(CopyWizArb.getString("SCHAMES_INFO"));
        JLabel jLabel = new JLabel();
        String[] stringArray = this.m_listModel.getSchemas();
        Object object = "";
        for (int i = 0; i < stringArray.length; ++i) {
            object = (String)object + " " + stringArray[i] + ",";
        }
        jLabel.setText(CopyWizArb.getString("SELECTED_SCHEMA_DESC") + ":" + (String)(!((String)object).equals("") ? ((String)object).substring(0, ((String)object).lastIndexOf(",")) : object));
        jLabel.setIcon(OracleIcons.getIcon((String)"schema_folder.png"));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(jLabel));
        return defaultMutableTreeNode;
    }

    public JLabel getSummaryNLSItem(String string, boolean bl) {
        JLabel jLabel = new JLabel();
        jLabel.setText(CopyWizSummaryPage.getDisplayName(string));
        if (bl) {
            jLabel.setIcon(OracleIcons.getIcon((String)"check.png"));
        } else {
            jLabel.setIcon(OracleIcons.getIcon((String)"delete.png"));
        }
        return jLabel;
    }

    public static String getDisplayName(String string) {
        String string2 = MnemonicUtil.extractLabelTextWithoutMnemonic(CopyWizArb.getString(string));
        return string2;
    }
}

