/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.writers;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.datatools.BaseDataFormat;
import oracle.dbtools.importer.core.ImportDataFormat;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.importer.writers.IImportGenerator;
import oracle.dbtools.importer.writers.ImportGenModel;
import oracle.dbtools.raptor.data.Messages;
import oracle.dbtools.raptor.data.writers.ImportGen;
import oracle.dbtools.util.Logger;
import org.stringtemplate.v4.ST;

public class ImportGenXTab
extends ImportGen
implements IImportGenerator {
    public static final String NAME = ImportDataFormat.METHOD_EXTERNAL_TABLE_NAME;
    public static final int TYPE = 2;
    private ImportProperties _iProps;
    private ImportGenModel _iGenModel;
    private boolean _isValid = false;
    private int _loadMethod;
    private LoadFile _loadFile;

    public String getName() {
        return NAME;
    }

    public Integer getType() {
        return 2;
    }

    @Override
    public boolean start(ImportProperties importProperties, ImportGenModel importGenModel) {
        return this.start(importProperties, importGenModel, false);
    }

    @Override
    public boolean start(ImportProperties importProperties, ImportGenModel importGenModel, boolean bl) {
        if (importProperties == null || importGenModel == null) {
            return false;
        }
        this._iProps = importProperties;
        this._iGenModel = importGenModel;
        if (!this._iProps.getValueBoolean(ImportKeys.IS_BATCH).booleanValue()) {
            this._iGenModel.initELogger();
            this._iGenModel.eLogImportMessages();
        }
        super.start(importProperties, importGenModel, bl);
        this._loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        if (!this._iGenModel.isExitCodeSuccess()) {
            return false;
        }
        return this.validate();
    }

    public boolean validate() {
        this._iGenModel.setExitCode(ExitCode.EXIT_SUCCESS);
        this._isValid = true;
        return true;
    }

    @Override
    public boolean process() {
        if (!this._isValid) {
            return false;
        }
        this._iGenModel.setExitCode(ExitCode.EXIT_SUCCESS);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SET DEFINE OFF\n");
        this._loadMethod = this._iProps.getValueInteger(ImportKeys.LOAD_METHOD);
        if (this._loadMethod == 3 && !this._iGenModel.isExistingTable()) {
            stringBuffer.append(this._iGenModel.getCreateTableStatementWithComments() + "\n\n");
        }
        stringBuffer.append(this.getExtCreateTableStatement() + "\n\n");
        if (this._loadMethod == 3) {
            stringBuffer.append(this.getInsertStatementFromStaging() + "\n\n");
        }
        String string = stringBuffer.toString();
        string = string.replaceAll("\\r", "");
        this._iGenModel.streamPrintln(string);
        Logger.info(this.getClass(), (String)Messages.getString("ImportGenerator.68"));
        if (!this._iGenModel.isBatch()) {
            Logger.info(this.getClass(), (String)Messages.getString("ImportGenerator.77"));
            try {
                this._iGenModel.eLogHref((URL)this._iProps.get(ImportKeys.URL_FOR_AUTO_OPEN));
            }
            catch (Exception exception) {
                Logger.warn(this.getClass(), (Throwable)exception);
                this._iGenModel.eLogException((Throwable)exception);
            }
        }
        this._iGenModel.eLogToolEnd();
        return this._iGenModel.isExitCodeSuccess();
    }

    private String getExtCreateTableStatement() {
        String string;
        Object object;
        Object object2;
        Object object32;
        String string2 = this._iGenModel.getGenTable().getTable().getTablename();
        String string3 = (String)this._iProps.get(ImportKeys.STAGING_TABLE_NAME);
        String[] stringArray = this.formatTableColumns(this._loadMethod == 3 && this._iGenModel.isExistingTable());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string4 : stringArray) {
            arrayList.add(string4.replaceAll("NOT NULL", ""));
        }
        ArrayList arrayList2 = new ArrayList();
        for (Object object32 : this._iGenModel.getGenTable().getColumns()) {
            object2 = (String)this._iProps.get(ImportKeys.CHARNUMCHARACTERS);
            object = this._iGenModel.addDoubleQuote(object32.getName()) + " CHAR(4000)";
            if (object2 != null && object2 != "" && ((String)object2).replaceAll("[0-9]*", "").equals("")) {
                object = this._iGenModel.addDoubleQuote(object32.getName()) + " CHAR(" + (String)object2 + ")";
            }
            if (object32.getType().equalsIgnoreCase("DATE")) {
                if (object32.getFormat() == null) {
                    arrayList2.add((String)object + " date_format DATE");
                    continue;
                }
                arrayList2.add((String)object + " date_format DATE mask \"" + object32.getFormat() + "\"");
                continue;
            }
            if (object32.getType().equalsIgnoreCase("TIMESTAMP")) {
                if (object32.getFormat() == null) {
                    arrayList2.add((String)object + " date_format TIMESTAMP");
                    continue;
                }
                arrayList2.add((String)object + " date_format TIMESTAMP mask \"" + object32.getFormat() + "\"");
                continue;
            }
            arrayList2.add(object);
        }
        ST sT = this._iGenModel.getTemplateGroup().getInstanceOf("CreateExtTableStatement");
        sT.add("tableName", (Object)(this._loadMethod == 3 ? this._iGenModel.addUser(string3) : this._iGenModel.addUser(this._iGenModel.addDoubleQuote(string2))));
        sT.add("colList", (Object)arrayList.toArray());
        sT.add("nameList", (Object)arrayList2.toArray());
        String string5 = this._loadFile.getCanonicalName();
        string5 = string5.replaceFirst("^([a-zA-Z]:)([^\\\\])", "$1\\\\$2");
        String string6 = string5.substring(string5.lastIndexOf(File.separator) + 1);
        string5 = string5.substring(string5.lastIndexOf(File.separator) + 1, string5.lastIndexOf(46));
        sT.add("fileName", (Object)string5);
        sT.add("path", this._iProps.get(ImportKeys.DIRPATH));
        sT.add("dirName", (Object)((String)this._iProps.get(ImportKeys.ORADIRNAME)));
        object32 = "NOBADFILE";
        if (this._iProps.getValueBoolean(ImportKeys.USEBADFILE).booleanValue()) {
            object2 = (String)this._iProps.get(ImportKeys.ORABADDIRNAME);
            if (object2 == null || ((String)object2).length() == 0) {
                object2 = (String)this._iProps.get(ImportKeys.ORADIRNAME);
            }
            object32 = "BADFILE " + (String)object2 + ":'" + string5 + ".bad'";
        }
        sT.add("badClause", object32);
        object2 = "NOLOGFILE";
        if (this._iProps.getValueBoolean(ImportKeys.USELOGFILE).booleanValue()) {
            object = (String)this._iProps.get(ImportKeys.ORALOGDIRNAME);
            if (object == null || ((String)object).length() == 0) {
                object = (String)this._iProps.get(ImportKeys.ORADIRNAME);
            }
            object2 = "LOGFILE " + (String)object + ":'" + string5 + ".log'";
        }
        sT.add("logClause", object2);
        object = "NODISCARDFILE";
        if (this._iProps.getValueBoolean(ImportKeys.USEDISCARDFILE).booleanValue()) {
            string = (String)this._iProps.get(ImportKeys.ORADISCARDDIRNAME);
            if (string == null || string.length() == 0) {
                string = (String)this._iProps.get(ImportKeys.ORADIRNAME);
            }
            object = "DISCARDFILE " + string + ":'" + string5 + ".discard'";
        }
        sT.add("discardClause", object);
        string = this._iGenModel.getDataFormat();
        String string7 = BaseDataFormat.singleQuote((String)BaseDataFormat.getDelimiterString((String)string.getDelimiter()));
        if (string7 == null || string7.equals("")) {
            string7 = "','";
        } else if (string7.equals("'WHITESPACE'")) {
            string7 = "WHITESPACE";
        }
        sT.add("fieldDelimiter", (Object)string7);
        Integer n = this._iGenModel.getDataFormat().isHeader() ? string.getSkipRows() + 1 : string.getSkipRows();
        sT.add("toSkip", (Object)n.toString());
        sT.add("allFile", (Object)string6);
        Object object4 = (String)this._iProps.get(ImportKeys.CHARSETVAL);
        if (!((String)object4).equals("")) {
            object4 = "CHARACTERSET " + (String)object4;
        }
        sT.add("charset", object4);
        String string8 = BaseDataFormat.singleQuote((String)BaseDataFormat.getRecordTerminatorString((String)string.getRecordTerminator()));
        sT.add("newline", (Object)string8);
        String string9 = string.getEnclosureLeftValue();
        String string10 = string.getEnclosureRightValue();
        Object object5 = "";
        if (string9.length() != 0) {
            object5 = "OPTIONALLY ENCLOSED BY '" + string9 + "' AND '" + string10 + "'";
        }
        sT.add("enclosures", object5);
        if (this._iProps.get(ImportKeys.PREVIEW_LIMIT) == null) {
            sT.add("limit", (Object)"");
        } else {
            sT.add("limit", (Object)("WHERE ROWNUM <= " + (String)this._iProps.get(ImportKeys.PREVIEW_LIMIT)));
        }
        return sT.render();
    }

    private String getInsertStatementFromStaging() {
        String string = (String)this._iProps.get(ImportKeys.TABLE_NAME);
        String string2 = (String)this._iProps.get(ImportKeys.STAGING_TABLE_NAME);
        ST sT = (ST)this._iProps.get(ImportKeys.SELECTED_COLUMNS);
        String[] stringArray = new String[((Column[])sT).length];
        int n = 0;
        for (Column column : sT) {
            stringArray[n++] = this._iGenModel.addDoubleQuote(column.getName());
        }
        ST sT2 = null;
        sT2 = (Boolean)this._iProps.get(ImportKeys.DROP_STAGING_TABLE) != false ? this._iGenModel.getTemplateGroup().getInstanceOf("InsertStatementFromStagingWithDrop") : this._iGenModel.getTemplateGroup().getInstanceOf("InsertStatementFromStaging");
        sT2.add("tableName", (Object)this._iGenModel.addUser(this._iGenModel.addDoubleQuote(string)));
        sT2.add("stagingTableName", (Object)this._iGenModel.addUser(this._iGenModel.addDoubleQuote(string2)));
        sT2.add("colList", (Object)stringArray);
        int n2 = (Integer)this._iProps.get(ImportKeys.LOAD_LIMIT);
        if (n2 > 0) {
            String string3 = "WHERE ROWNUM <= " + n2;
            sT2.add("loadLimitClause", (Object)string3);
        }
        return sT2.render();
    }
}

