/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.writers;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import oracle.dbtools.data.formattors.ITypeFormattor;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.data.readservice.DataFormatException;
import oracle.dbtools.importer.ImportResources;
import oracle.dbtools.importer.core.ImportDataFormat;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.importer.formattors.DataTypeFormatterRegistry;
import oracle.dbtools.importer.formattors.NumberFormattorImport;
import oracle.dbtools.importer.readers.DataReaderException;
import oracle.dbtools.importer.readers.DataReaderRegistry;
import oracle.dbtools.importer.readers.IDataReadable;
import oracle.dbtools.importer.writers.ImportGenModel;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.writers.ImportGenExec;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdbc.OraclePreparedStatement;

public class ImportGenInsertExec
extends ImportGenExec {
    public static final String NAME = ImportDataFormat.METHOD_INSERT_EXEC_NAME;
    public static final int TYPE = 0;
    private ImportProperties _iProps;
    private ImportGenModel _iGenModel;
    private LoadFile _loadFile;
    private IDataReadable _reader;
    private boolean _isIgnoreAllErrors = false;
    private int _loadRowsLimit;
    private boolean _isLoadLimit;
    private Map<String, ITypeFormattor> _formatters = null;
    private String _insertForErrSql = "";
    private RaptorTask<?> _task;

    public String getName() {
        return NAME;
    }

    public Integer getType() {
        return 0;
    }

    @Override
    public boolean start(ImportProperties importProperties, ImportGenModel importGenModel) {
        return this.start(importProperties, importGenModel, false);
    }

    @Override
    public boolean start(ImportProperties importProperties, ImportGenModel importGenModel, boolean bl) {
        if (importProperties == null || importGenModel == null) {
            return false;
        }
        this._iProps = importProperties;
        this._iGenModel = importGenModel;
        if (!this._iProps.getValueBoolean(ImportKeys.IS_BATCH).booleanValue()) {
            this._iGenModel.initELogger();
            this._iGenModel.eLogImportMessages();
        }
        this._loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        this._loadRowsLimit = this._iProps.getValueInteger(ImportKeys.LOAD_LIMIT);
        this._isLoadLimit = this._loadRowsLimit > 0;
        super.start(importProperties, importGenModel, bl);
        return this._iGenModel.isExitCodeSuccess();
    }

    @Override
    public boolean doImport() {
        this._task = this._iGenModel.getRunMode().getTask();
        if (!this._iGenModel.doCreateTable()) {
            if (this._task != null) {
                this._task.getDescriptor().setMessage(this.getExitCode().getShortMessage() + " " + this.getExitCode().getMessage());
            }
            this._iGenModel.isCancel(true);
        } else {
            try {
                this.doInserts(this._task);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        return this._iGenModel.isCancel();
    }

    public void doInserts() throws ExecutionException {
        this.doInserts(null);
    }

    public void doInserts(RaptorTask<?> raptorTask) throws ExecutionException {
        try {
            Object[] objectArray;
            this._reader = (IDataReadable)this._iProps.get(ImportKeys.DATA_READER);
            if (this._reader == null) {
                this._reader = DataReaderRegistry.getReader((String)this._loadFile.getType());
                this._reader.setDataFormat((ImportDataFormat)this._iProps.get(ImportKeys.IMPORT_DATA_FORMAT));
                objectArray = this._loadFile.getName();
                this._reader.setFileName((String)objectArray);
                if (this._iProps.get(ImportKeys.PAGEID) != null) {
                    this._reader.setPage(((Integer)this._iProps.get(ImportKeys.PAGEID)).intValue());
                }
            }
            int n = DBConfig.getInstance().getInt("IMPORT_INSERT_BATCH_SIZE");
            ArrayList<Object> arrayList = new ArrayList<Object>(n);
            int n2 = 0;
            int n3 = 1;
            int n4 = 0;
            int n5 = 0;
            StringBuffer stringBuffer = null;
            boolean bl = false;
            Column[] columnArray = (Column[])this._iProps.get(ImportKeys.SELECTED_COLUMNS);
            try {
                int[] nArray;
                ImportDataFormat importDataFormat;
                objectArray = new String[]{};
                String string = this.getInsertStatementForPrepare(this._iGenModel.getTableName(), columnArray, objectArray);
                this._insertForErrSql = this.getInsertStatementForError(this._iGenModel.getTableName(), columnArray, objectArray);
                this._iGenModel.checkCanProceed();
                OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)this._iGenModel.getConn().prepareStatement(string);
                this._reader.start();
                if (this._iProps.get(ImportKeys.PAGEID) != null) {
                    this._reader.setPage(((Integer)this._iProps.get(ImportKeys.PAGEID)).intValue());
                }
                if ((importDataFormat = this._iGenModel.getDataFormat()).getSkipRows() != 0) {
                    int n6 = importDataFormat.isHeader() ? importDataFormat.getSkipRows() + 1 : importDataFormat.getSkipRows();
                    for (int i = 0; i < n6 && this._reader.hasMoreRows() && !this._iGenModel.isCancel(); ++i) {
                        try {
                            this._reader.readline();
                            continue;
                        }
                        catch (DataFormatException dataFormatException) {
                            // empty catch block
                        }
                    }
                } else if (importDataFormat.isHeader() && this._reader.hasMoreRows()) {
                    try {
                        this._reader.readline();
                    }
                    catch (DataFormatException dataFormatException) {
                        // empty catch block
                    }
                }
                while (this._reader.hasMoreRows() && (!this._isLoadLimit || n5 < this._loadRowsLimit)) {
                    stringBuffer = new StringBuffer();
                    StringBuffer stringBuffer2 = new StringBuffer();
                    try {
                        if (this._iGenModel.isCancel()) break;
                        try {
                            objectArray = this._reader.readline();
                        }
                        catch (DataFormatException dataFormatException) {
                            stringBuffer.append("--" + dataFormatException.getMessage() + "\n");
                            objectArray = dataFormatException.getColumns();
                        }
                        if (objectArray != null) {
                            this._iGenModel.checkCanProceed();
                            bl = this.getBatchForInsert(this._iGenModel.getTableName(), columnArray, objectArray, stringBuffer2, oraclePreparedStatement, stringBuffer);
                            if (bl) {
                                arrayList.add(stringBuffer2.toString());
                                ++n2;
                                ++n5;
                            }
                        }
                        if (n2 == n || stringBuffer.length() > 0 && n2 > 0) {
                            n4 = n3 + n2 - 1;
                            String string2 = DataImportArb.format("TASK_PROGRESS_INS2", "" + n3, "" + n4);
                            if (n3 == n4) {
                                string2 = DataImportArb.format("TASK_PROGRESS_INS", "" + n3);
                            }
                            this._iGenModel.setMessage(string2);
                            this._iGenModel.checkCanProceed();
                            nArray = oraclePreparedStatement.executeBatch();
                            this.processUpdateCounts(nArray, n2, n3, arrayList);
                            n2 = 0;
                            n4 = n3 = n4 + 1;
                            arrayList.clear();
                        }
                        if (stringBuffer.length() <= 0) continue;
                        arrayList.add(stringBuffer2.toString());
                        n4 = n3;
                        this.handleBatchUpdateException(new BatchUpdateException(stringBuffer.toString(), null), 1, n3, n4, arrayList);
                        arrayList.clear();
                        n4 = ++n3;
                    }
                    catch (BatchUpdateException batchUpdateException) {
                        this.handleBatchUpdateException(batchUpdateException, n2, n3, n4, arrayList);
                        n2 = 0;
                        n3 = n4 + 1;
                        arrayList.clear();
                        if (stringBuffer == null || stringBuffer.length() <= 0) continue;
                        arrayList.add(stringBuffer2.toString());
                        n4 = n3;
                        this.handleBatchUpdateException(new BatchUpdateException(stringBuffer.toString(), null), 1, n3, n4, arrayList);
                        arrayList.clear();
                        n4 = ++n3;
                    }
                }
                if (n2 != 0) {
                    n4 = n3 + n2 - 1;
                    String string3 = DataImportArb.format("TASK_PROGRESS_INS2", "" + n3, "" + n4);
                    if (n2 == 1) {
                        string3 = DataImportArb.format("TASK_PROGRESS_INS", "" + n4);
                    }
                    this._iGenModel.checkCanProceed();
                    this._iGenModel.setMessage(string3);
                    this._iGenModel.checkCanProceed();
                    nArray = oraclePreparedStatement.executeBatch();
                    this.processUpdateCounts(nArray, n2, n3, arrayList);
                }
            }
            catch (BatchUpdateException batchUpdateException) {
                this.handleBatchUpdateException(batchUpdateException, n2, n3, n4, arrayList);
            }
            catch (SQLException sQLException) {
                this.cancelTask();
            }
            this._iGenModel.checkCanProceed();
        }
        catch (DataReaderException dataReaderException) {
            Logger.warn(this.getClass(), (Throwable)dataReaderException);
            this.cancelTask();
        }
    }

    private void handleBatchUpdateException(BatchUpdateException batchUpdateException, int n, int n2, int n3, ArrayList<Object> arrayList) throws ExecutionException {
        StringBuffer stringBuffer = this._iGenModel.getCreateTableSql();
        if (stringBuffer != null && stringBuffer.length() > 0) {
            this.outBad(stringBuffer.toString());
            this._iGenModel.setCreateTableSql(null);
        }
        int[] nArray = batchUpdateException.getUpdateCounts();
        Logger.warn(this.getClass(), (Throwable)batchUpdateException);
        Object object = batchUpdateException.getMessage().startsWith("--") ? batchUpdateException.getMessage() : "--" + batchUpdateException.getMessage();
        Object object2 = DataImportArb.format("TASK_PROGRESS_INS_FAIL2", " " + n2 + " ", " " + n3 + " ") + (String)object;
        if (n == 1) {
            object2 = DataImportArb.format("TASK_PROGRESS_INS_FAIL", " " + n2 + " ") + (String)object;
        }
        object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
        String string = ((String)object2).replace("--", "");
        this.outBad("--" + (String)object2);
        this.processUpdateCounts(nArray, n, n2, arrayList);
        if (!this._iGenModel.isBatch() && !this._isIgnoreAllErrors) {
            try {
                this.askContinueOnError(string + "\n\n" + DataImportArb.getString("TASK_PROGRESS_CONTINUE"));
            }
            catch (Throwable throwable) {
                Logger.warn(this.getClass(), (Throwable)batchUpdateException);
                this.rollbackTask();
                this._iGenModel.requestCancel();
            }
        }
    }

    private void processUpdateCounts(int[] nArray, int n, int n2, ArrayList<Object> arrayList) {
        String string;
        if (nArray == null || nArray.length < 1) {
            int n3 = 0;
            while (n3 < n) {
                String string2 = DataImportArb.format("ROW", n2);
                this.outBad("--" + string2);
                string2 = (String)arrayList.get(n3);
                this.outBad(this._insertForErrSql + string2);
                ++n3;
                ++n2;
            }
            return;
        }
        int n4 = 0;
        while (n4 < nArray.length) {
            if (nArray[n4] < 0 && nArray[n4] != -2 && nArray[n4] == -3) {
                string = DataImportArb.format("ROW", n2);
                this.outBad("--" + string);
                string = (String)arrayList.get(n4);
                this.outBad(this._insertForErrSql + string);
            }
            ++n4;
            ++n2;
        }
        if (nArray.length < n) {
            n4 = nArray.length;
            while (n4 < n) {
                string = DataImportArb.format("ROW", n2);
                this.outBad("--" + string);
                string = (String)arrayList.get(n4);
                this.outBad(this._insertForErrSql + string);
                ++n4;
                ++n2;
            }
            return;
        }
    }

    private void askContinueOnError(String string) throws Throwable {
        final String string2 = string;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    int n = MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)string2, (String)ImportResources.getString((String)"TASK_SHORT_NAME"), null);
                    if (n == -1) {
                        ImportGenInsertExec.this._iGenModel.requestCancel();
                    } else if (n == 1) {
                        ImportGenInsertExec.this._isIgnoreAllErrors = true;
                    }
                }
                catch (Exception exception) {
                    Logger.warn(this.getClass(), (Throwable)exception);
                    ImportGenInsertExec.this._iGenModel.requestCancel();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
        }
    }

    public boolean cancelTask() {
        if (this._iGenModel.getRunMode().getTask() != null) {
            boolean bl = this._iGenModel.getRunMode().getTask().requestCancel();
            return bl;
        }
        return true;
    }

    private void outBad(String string) {
        try {
            this._iGenModel.getStream().printlnBad(string);
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
    }

    private boolean getBatchForInsert(String string, Column[] columnArray, Object[] objectArray, StringBuffer stringBuffer, OraclePreparedStatement oraclePreparedStatement, StringBuffer stringBuffer2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i].getSourceColID() < objectArray.length) {
                arrayList.add(objectArray[columnArray[i].getSourceColID()]);
                continue;
            }
            arrayList.add("");
        }
        Object[] objectArray2 = arrayList.toArray();
        String string2 = "(";
        ITypeFormattor iTypeFormattor = null;
        if (this._formatters == null) {
            this._formatters = new HashMap<String, ITypeFormattor>();
            ITypeFormattor iTypeFormattor2 = DataTypeFormatterRegistry.getInstance().getFormattor("VARCHAR2");
            iTypeFormattor2.setLocale((Locale)this._iProps.get(ImportKeys.LOCALE));
            this._formatters.put("VARCHAR2", iTypeFormattor2);
        }
        for (int i = 0; i < objectArray2.length; ++i) {
            iTypeFormattor = this._formatters.get(columnArray[i].getType());
            if (iTypeFormattor == null) {
                iTypeFormattor = DataTypeFormatterRegistry.getInstance().getFormattor(columnArray[i].getType());
                if (iTypeFormattor == null) {
                    iTypeFormattor = this._formatters.get("VARCHAR2");
                }
                iTypeFormattor.setLocale((Locale)this._iProps.get(ImportKeys.LOCALE));
                if (iTypeFormattor instanceof NumberFormattorImport) {
                    ((NumberFormattorImport)iTypeFormattor).setNlsDecimalSeparator((Character)this._iProps.get(ImportKeys.NLS_DECIMAL_SEPARATOR));
                }
                this._formatters.put(columnArray[i].getType(), iTypeFormattor);
            }
            iTypeFormattor.setConnection(this._iGenModel.getConn());
            try {
                stringBuffer.append(string2);
                stringBuffer.append(iTypeFormattor.formatData(objectArray2[i], columnArray[i]));
                Object object = iTypeFormattor.formatDataForJava(objectArray2[i], columnArray[i]);
                if (object != null && object instanceof String) {
                    String string3 = (String)object;
                    if (string3 == null || string3.length() == 0 || string3.equals("''") || string3.equals("NULL")) {
                        oraclePreparedStatement.setNull(i + 1, iTypeFormattor.getSqlType(columnArray[i].getType()));
                    } else {
                        if (columnArray[i].getType().equals("NCHAR") || columnArray[i].getType().equals("NVARCHAR2")) {
                            oraclePreparedStatement.setFormOfUse(i + 1, (short)2);
                        }
                        oraclePreparedStatement.setString(i + 1, string3);
                    }
                } else {
                    oraclePreparedStatement.setObject(i + 1, object, iTypeFormattor.getSqlType(columnArray[i].getType()));
                }
            }
            catch (Exception exception) {
                stringBuffer2.append(columnArray[i].getName() + " " + exception.getMessage() + " ");
            }
            string2 = ",";
        }
        stringBuffer.append(");");
        if (stringBuffer2.length() == 0) {
            try {
                oraclePreparedStatement.addBatch();
            }
            catch (Exception exception) {
                stringBuffer2.append(exception.getMessage());
            }
        }
        return stringBuffer2.length() == 0;
    }

    public boolean finish() {
        this.closeFiles();
        return true;
    }

    public void closeFiles() {
        if (this._reader != null) {
            this._reader.closeFile();
        }
    }
}

