/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.writers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.format.DelimitedFormatter;
import oracle.dbtools.raptor.format.Messages;

public class DbmsCloudFormatter
extends DelimitedFormatter {
    private static final Logger LOGGER = Logger.getLogger(DbmsCloudFormatter.class.getName());
    public static final String TYPE = "CSV";
    public static final String EXT = "csv";
    public static final String DEFAULT_DELIMITER = ",";
    public static final String KEY_HEADER = "EXPORT_CSV_HEADER";
    public static final String KEY_REC_TERM = "EXPORT_CSV_REC_TERM";
    public static final String KEY_ENCLOSURES = "EXPORT_CSV_ENCLOSURES";
    public static final String KEY_ENCL_LEFT = "EXPORT_CSV_ENCL_LEFT";
    public static final String KEY_ENCL_RIGHT = "EXPORT_CSV_ENCL_RIGHT";
    public static final String KEY_ENCL_RIGHT_DOUBLE = "EXPORT_CSV_ENCL_RIGHT_DOUBLE";
    private static String s_delim = ",";
    private boolean _isData = false;
    private static final String MIME = "text/csv";

    public DbmsCloudFormatter() {
        super(TYPE, Messages.getString((String)"CSVFormatter.0"), EXT);
    }

    public String getMimeType() {
        return MIME;
    }

    public boolean isDelimiterConfigurable() {
        return false;
    }

    public String getDefaultDelimiter() {
        return DEFAULT_DELIMITER;
    }

    public String getHeaderConfigKey() {
        return KEY_HEADER;
    }

    public String getLineTerminatorConfigKey() {
        return KEY_REC_TERM;
    }

    public String getEnclosuresConfigKey() {
        return KEY_ENCLOSURES;
    }

    public String getEnclosureLeftConfigKey() {
        return KEY_ENCL_LEFT;
    }

    public String getEnclosureRightConfigKey() {
        return KEY_ENCL_RIGHT;
    }

    public String getEnclosureRightDoubleConfigKey() {
        return KEY_ENCL_RIGHT_DOUBLE;
    }

    public void endRow() throws IOException {
        this._isData = true;
        super.endRow();
    }

    public void end() throws IOException {
        if (!this._isData) {
            return;
        }
        String string = "dbms_cloud...";
        String string2 = this.getNewFileName(EXT, "");
        if (this._zipper == null) {
            if (!string2.equals("")) {
                Writer writer = this.getNewWriter(string2);
                this.addToControllingFile(string2);
                writer.write(string);
                writer.close();
            }
        } else if (this._zipper != null) {
            this._zipper.closeEntry();
            this._zipper.openEntry(string2);
            this.write(string);
            this._zipper.closeEntry();
        }
    }

    private Writer getNewWriter(String string) {
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            try {
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, this.getEncode());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LOGGER.log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
                outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            }
            bufferedWriter = new BufferedWriter(outputStreamWriter);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
        }
        return bufferedWriter;
    }

    private String getNewFileName(String string, String string2) {
        Object object = this.getFileName();
        if (object == null) {
            return "";
        }
        int n = ((String)object).lastIndexOf(".");
        String string3 = n != -1 ? ((String)object).substring(0, n) : object;
        int n2 = 0;
        object = string3 + string2 + "." + string;
        if (!new File((String)object).exists()) {
            return object;
        }
        while (new File((String)object).exists()) {
            object = string3 + string2 + "_" + ++n2 + "." + string;
        }
        return object;
    }
}

