/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.dbtools.importer.core.ImportDataFormat;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class MaxLengthPanel {
    private JCheckBox maxLengthCheckBox;
    private boolean checkBoxControlled;
    private NumericSpinBox maxLengthSpinBox;
    private ImportDataFormat dataFormat;
    private static final long serialVersionUID = -2739487292165944123L;

    public MaxLengthPanel() {
        this(true);
    }

    public MaxLengthPanel(ImportDataFormat importDataFormat, boolean bl) {
        this(bl);
        this.dataFormat = importDataFormat;
    }

    public MaxLengthPanel(boolean bl) {
        try {
            this.checkBoxControlled = bl;
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void jbInit() throws Exception {
        this.initMaxLength();
    }

    public JCheckBox getMaxLengthCheckBox() {
        return this.maxLengthCheckBox;
    }

    public NumericSpinBox getMaxLengthSpinBox() {
        return this.maxLengthSpinBox;
    }

    void initMaxLength() {
        this.maxLengthCheckBox = new JCheckBox();
        this.maxLengthCheckBox.setSelected(true);
        ResourceUtils.resButton((AbstractButton)this.maxLengthCheckBox, (String)DataImportArb.getString("IMPORT_MAX_LENGTH"));
        if (this.checkBoxControlled) {
            this.maxLengthCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                    MaxLengthPanel.this.maxLengthSpinBox.setEnabled(jCheckBox.isSelected());
                }
            });
        }
        this.maxLengthSpinBox = new NumericSpinBox(0, Integer.MAX_VALUE);
    }

    public void onEntry(TraversableContext traversableContext) {
        if (this.dataFormat != null) {
            this.maxLengthCheckBox.setSelected(this.dataFormat.getUseMaxLength());
            this.maxLengthSpinBox.setIntValue(this.dataFormat.getMaxLength());
        } else {
            DBConfig dBConfig = DBConfig.getInstance(traversableContext);
            this.maxLengthCheckBox.setSelected(dBConfig.getBoolean("IMPORT_USE_MAX_LENGTH"));
            this.maxLengthSpinBox.setIntValue(dBConfig.getInt("IMPORT_MAX_LENGTH"));
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putInt("IMPORT_MAX_LENGTH", this.maxLengthSpinBox.getIntValue());
        dBConfig.putBoolean("IMPORT_USE_MAX_LENGTH", this.maxLengthCheckBox.isSelected());
    }
}

