/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.importer.core.DataType;
import oracle.dbtools.importer.core.ImportDataFormat;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.ColumnChangeEvent;
import oracle.dbtools.raptor.data.core.ColumnChangeListener;
import oracle.dbtools.raptor.data.core.ColumnDefinitionDetective;
import oracle.dbtools.raptor.data.ui.ColumnListPanel;
import oracle.dbtools.raptor.data.ui.ColumnPropertiesPanel;
import oracle.dbtools.raptor.data.ui.ColumnPropertyPanel;
import oracle.dbtools.raptor.data.ui.DataPreviewGizmo;
import oracle.dbtools.raptor.data.ui.DataUIUtils;
import oracle.dbtools.raptor.data.ui.KnownColumnPropertiesPanel;
import oracle.dbtools.raptor.data.validators.LoadFieldValidator;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.InvalidNameException;

public abstract class ColumnPanelAbstract
extends DefaultTraversablePanel
implements ColumnChangeListener {
    private static final long serialVersionUID = 8282169188783793125L;
    private static final Logger LOGGER = Logger.getLogger(ColumnPanelAbstract.class.getName());
    private GenericTable genericTable;
    private JTextPane instructions;
    private JPanel matchPanel;
    private JComboBox matchBy;
    private ActionListener matchByListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnPanelAbstract.this.matchByType = ((JComboBox)actionEvent.getSource()).getSelectedIndex();
            ColumnPanelAbstract.this.refreshColumnData();
        }
    };
    private ColumnListPanel clp;
    protected DataPreviewGizmo gizmo;
    private boolean insertToExistingTable;
    private ColumnPropertyPanel colPropPanel;
    private GridBagConstraints cppConstraints = new GridBagConstraints(1, 2, 1, 1, 0.5, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0);
    private Column _column;
    private TraversableContext m_ctx;
    private Connection _conn;
    private boolean _isDetectedDefault = false;
    private boolean _isDefaultMax = false;
    private boolean _isRounded = true;
    private boolean isHeader;
    private boolean _isDetectiveInit = false;
    private boolean matchByInit = false;
    private int matchByType;
    private static int matchByName = 0;
    private static int matchByPosition = 1;
    protected int _loadMethod;
    protected ImportProperties _iProps;
    private LoadFile _loadFile;
    protected Locale _locale;
    private String[] datatypes;
    private Column[] _selectedColumns;
    boolean _isSelectedChanged = true;
    private String[] _dateMasks;
    private String[] _timestampMasks;
    private String[] _timestamptzMasks;
    private boolean _isFinishEnabled = false;

    protected abstract void updateExpectedTransition();

    protected int getLoadMethod() {
        return this._loadMethod;
    }

    protected void setLoadMethod(int n) {
        this._loadMethod = n;
    }

    protected TraversableContext getContext() {
        return this.m_ctx;
    }

    protected void isDetectedDefault(boolean bl) {
        this._isDetectedDefault = bl;
    }

    protected void setPrecisionProfile(boolean bl, boolean bl2, boolean bl3) {
        this._isDetectedDefault = bl;
        this._isDefaultMax = bl2;
        this._isRounded = bl3;
    }

    protected void detectFormat(Column column) {
        this.gizmo.detectFormat(column);
    }

    protected String[] getDateMasks() {
        return ColumnDefinitionDetective.DATE_MASKS;
    }

    protected String[] getTimestampMasks() {
        return ColumnDefinitionDetective.TIMESTAMP_MASKS;
    }

    protected String[] getTimestamptzMasks() {
        return ColumnDefinitionDetective.TIMESTAMPTZ_MASKS;
    }

    protected void initDetective(DataPreviewGizmo dataPreviewGizmo) {
        dataPreviewGizmo.initDetective(this._locale, ColumnDefinitionDetective.DATE_MASKS, ColumnDefinitionDetective.TIMESTAMP_MASKS, ColumnDefinitionDetective.TIMESTAMPTZ_MASKS);
    }

    public ColumnPanelAbstract() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowHeights = new int[]{7, 7, 7, 7, 0};
        this.setLayout(gridBagLayout);
        this.instructions = new JTextPane();
        this.instructions.setEditable(false);
        this.instructions.setOpaque(false);
        this.instructions.setRequestFocusEnabled(false);
        this.instructions.setFocusable(false);
        this.add(this.instructions, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.matchPanel = new JPanel(new GridBagLayout());
        this.add(this.matchPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.clp = new ColumnListPanel();
        this.clp.getLstColumns().setSelectionModel(new SingleSelectionModel(){

            @Override
            public void updateSingleSelection(int n, int n2) {
                if (n >= 0) {
                    Column column = (Column)ColumnPanelAbstract.this.clp.getLstColumns().getModel().getElementAt(n);
                    if (ColumnPanelAbstract.this.colPropPanel != null && column != null) {
                        column.refreshData(ColumnPanelAbstract.this.colPropPanel.getColumnDetails());
                        Column column2 = (Column)ColumnPanelAbstract.this.clp.getLstColumns().getModel().getElementAt(n2);
                        if (column2 != null) {
                            LoadField loadField = ColumnPanelAbstract.this._loadFile.getFieldByName(column2.getSourceColumnName());
                            loadField.isChecked(true);
                        }
                        if (ColumnPanelAbstract.this.colPropPanel != null) {
                            ColumnPanelAbstract.this._column = column2;
                            ColumnPanelAbstract.this.colPropPanel.setColumn(column2);
                            ColumnPanelAbstract.this.gizmo.refreshOneCol(column2.getSourceColID());
                        }
                        ColumnPanelAbstract.this.clp.setCurrentSelection(n2);
                    }
                } else {
                    Column column = (Column)ColumnPanelAbstract.this.clp.getLstColumns().getModel().getElementAt(n2);
                    if (column != null) {
                        LoadField loadField = ColumnPanelAbstract.this._loadFile.getFieldByName(column.getSourceColumnName());
                        if (loadField != null) {
                            loadField.isChecked(true);
                        }
                        if (ColumnPanelAbstract.this.colPropPanel != null) {
                            ColumnPanelAbstract.this._column = column;
                            ColumnPanelAbstract.this.colPropPanel.setColumn(column);
                            ColumnPanelAbstract.this.gizmo.refreshOneCol(column.getSourceColID());
                        }
                        ColumnPanelAbstract.this.clp.setCurrentSelection(n2);
                    }
                }
            }
        });
        this.add(this.clp, new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        if (traversableContext.getDirection() == 1) {
            Object object;
            String[] stringArray;
            this.m_ctx = traversableContext;
            this._iProps = (ImportProperties)this.m_ctx.get("IMPORT_PROPERTIES");
            try {
                this._conn = Connections.getInstance().getConnection((String)this._iProps.get(ImportKeys.CONNECTION_NAME));
            }
            catch (DBException dBException) {
                LOGGER.log(Level.SEVERE, dBException.getStackTrace()[0].toString(), dBException);
            }
            if (this._dateMasks == null) {
                this._dateMasks = this.getAllDateMasks();
                this._timestampMasks = this.getAllTimestampMasks();
                this._timestamptzMasks = this.getAllTimestamptzMasks();
            }
            this._isFinishEnabled = this._iProps.getValueBoolean(ImportKeys.IS_FINISH_ENABLED);
            this._loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
            this.m_ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(this._isFinishEnabled));
            this._isSelectedChanged = this._iProps.getValueBoolean(ImportKeys.IS_CART) != false ? this.matchByInit && this._iProps.getValueBoolean(ImportKeys.IS_EXISTING_TABLE) != false : this.isSelectedChanged();
            this._selectedColumns = (Column[])this._iProps.get(ImportKeys.SELECTED_COLUMNS);
            this.clp.onEntry(traversableContext);
            this.insertToExistingTable = (Boolean)this._iProps.get(ImportKeys.IS_EXISTING_TABLE);
            this.gizmo = (DataPreviewGizmo)this._iProps.get(ImportKeys.GIZMO);
            this.gizmo.onEntry(traversableContext);
            this._locale = (Locale)this._iProps.get(ImportKeys.LOCALE);
            if (this._isSelectedChanged || !this._isDetectiveInit) {
                this.initDetective(this.gizmo);
                this._isDetectiveInit = true;
            }
            this.populateDBO(traversableContext);
            if (!this.insertToExistingTable && !this._iProps.getValueBoolean(ImportKeys.IS_CONFIGFILE).booleanValue()) {
                this.gizmo.detectColumnDefinitions(this._loadFile);
                for (JLabel jLabel : this._loadFile.getFields()) {
                    if (!jLabel.isLoad() || jLabel.isChecked() || (stringArray = jLabel.getColumn()) == null) continue;
                    int n = jLabel.getDetectedPrecision();
                    String string = stringArray.getType();
                    int n2 = ColumnDefinitionDetective.getRoundedPrecision(n, string);
                    int n3 = ColumnDefinitionDetective.getMaxPrecision(n, string);
                    int n4 = stringArray.getPrecision();
                    if (this._isDefaultMax) {
                        stringArray.setPrecision(n4 != 0 && n4 != n ? n4 : n3);
                        continue;
                    }
                    if (string.equals(DataType.NUMBER.toString())) {
                        stringArray.setPrecision(n4 != n ? n4 : n3);
                        continue;
                    }
                    if (!this._isDetectedDefault) {
                        stringArray.setPrecision(n4 != n ? n4 : n2);
                        continue;
                    }
                    stringArray.setPrecision(n4);
                }
            }
            this.setupColumnDetails(traversableContext);
            this.populateSrcDataColumns(traversableContext);
            if (this.insertToExistingTable) {
                object = (ImportDataFormat)this._iProps.get(ImportKeys.IMPORT_DATA_FORMAT);
                if (!this.matchByInit || this._isSelectedChanged) {
                    JLabel jLabel;
                    jLabel = new JLabel();
                    jLabel.setText(DataImportArb.getString("MATCH_BY_LABEL"));
                    this.matchPanel.add((Component)jLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
                    stringArray = new String[]{DataImportArb.getString("MATCH_BY_NAME"), DataImportArb.getString("MATCH_BY_POSITION"), DataImportArb.getString("MATCH_BY_NONE")};
                    this.matchBy = new JComboBox<String>(stringArray);
                    this.matchBy.addActionListener(this.matchByListener);
                    this.isHeader = object.isHeader();
                    if (!this._iProps.getValueBoolean(ImportKeys.IS_CONFIGFILE).booleanValue()) {
                        if (this.isHeader) {
                            this.matchBy.setSelectedIndex(0);
                        } else {
                            this.matchBy.setSelectedItem(DataImportArb.getString("MATCH_BY_POSITION"));
                        }
                    } else {
                        this.matchBy.setSelectedIndex(this._iProps.getValueInteger(ImportKeys.MATCH_BY_TYPE));
                    }
                    this.matchPanel.add((Component)this.matchBy, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
                } else if (this.isHeader != object.isHeader()) {
                    this.isHeader = object.isHeader();
                    this.matchPanel.setVisible(true);
                }
                this.matchByInit = true;
            } else if (this.matchPanel != null) {
                this.matchPanel.setVisible(false);
            }
            this._column = (Column)this.clp.getLstColumns().getModel().getElementAt(0);
            object = new Column();
            object.refreshData(this._column);
            object.setSourceColID(this._column.getSourceColID());
            object.setSourceColumnName(this._column.getSourceColumnName());
            this.clp.setCurrentSelection(0);
            this.colPropPanel.setColumn((Column)object);
            this.updateExpectedTransition();
        }
    }

    private boolean isSelectedChanged() {
        if (this._selectedColumns == null) {
            return true;
        }
        Column[] columnArray = (Column[])this._iProps.get(ImportKeys.SELECTED_COLUMNS);
        if (this._selectedColumns.length != columnArray.length) {
            return true;
        }
        for (Column column : columnArray) {
            if (this.getFromSelectedColumns(column) != null) continue;
            return true;
        }
        return false;
    }

    private Column getFromSelectedColumns(Column column) {
        for (Column column2 : this._selectedColumns) {
            if (!column2.getSourceColumnName().equals(column.getSourceColumnName())) continue;
            return column2;
        }
        return null;
    }

    private void refreshColumnData() {
        for (int i = 0; i < this.clp.getLstColumns().getModel().getSize(); ++i) {
            Column column = (Column)this.clp.getLstColumns().getModel().getElementAt(i);
            Column column2 = null;
            if (this.matchByType == matchByName) {
                column2 = this.genericTable.getTable().getFirstColumn();
                for (Column column3 : this.genericTable.getTable().getColumns()) {
                    if (column3.getName().equalsIgnoreCase(column.getSourceColumnName().trim())) {
                        column2 = column3;
                        break;
                    }
                    column2 = this.genericTable.getTable().getFirstColumn();
                }
            } else if (this.matchByType == matchByPosition) {
                try {
                    column2 = (Column)this.genericTable.getTable().getColumns().get(i);
                }
                catch (Exception exception) {
                    column2 = this.genericTable.getTable().getFirstColumn();
                }
            } else {
                column2 = this.genericTable.getTable().getFirstColumn();
            }
            if (this.insertToExistingTable && column2 == null) {
                column2 = this.genericTable.getTable().getFirstColumn();
            }
            column.refreshData(column2);
            if (column.getFormat() != null && column2.getFormat() != null && column2.getFormat().length() != 0) continue;
            this.detectFormat(column);
        }
        if (this.colPropPanel != null) {
            Column column = this.clp.getCurrentSelection();
            this.colPropPanel.setColumn(column);
        }
        this.clp.resetValidators();
        this.clp.repaint();
    }

    protected void setupColumnDetails(TraversableContext traversableContext) {
        this.setupColumnDetails(traversableContext, null);
    }

    protected void setupColumnDetails(TraversableContext traversableContext, DataType[] dataTypeArray) {
        ColumnPropertyPanel columnPropertyPanel;
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        this.setLoadMethod(this._iProps.getValueInteger(ImportKeys.LOAD_METHOD));
        this._iProps.put(ImportKeys.DATE_MASKS, (Object)this._dateMasks);
        this._iProps.put(ImportKeys.TIMESTAMP_MASKS, (Object)this._timestampMasks);
        this._iProps.put(ImportKeys.TIMESTAMPTZ_MASKS, (Object)this._timestamptzMasks);
        if (this.colPropPanel != null) {
            this.remove(this.colPropPanel);
        }
        if (this.insertToExistingTable) {
            columnPropertyPanel = new KnownColumnPropertiesPanel(this._iProps);
            ((KnownColumnPropertiesPanel)columnPropertyPanel).setTable(this.genericTable, true);
            this.colPropPanel = columnPropertyPanel;
            this.add(columnPropertyPanel, this.cppConstraints);
            ((KnownColumnPropertiesPanel)columnPropertyPanel).addColumnChangeListener(this);
        } else {
            columnPropertyPanel = new ColumnPropertiesPanel(this._iProps, dataTypeArray);
            ((ColumnPropertiesPanel)columnPropertyPanel).setPrecisionProfile(this._isDetectedDefault, this._isDefaultMax, this._isRounded);
            this.colPropPanel = columnPropertyPanel;
            ((ColumnPropertiesPanel)columnPropertyPanel).setTable(this.genericTable);
            this.add(columnPropertyPanel, this.cppConstraints);
            if (this._loadMethod == 2 || this._loadMethod == 3) {
                ((ColumnPropertiesPanel)columnPropertyPanel).enableComment(false);
            } else {
                ((ColumnPropertiesPanel)columnPropertyPanel).enableComment(true);
            }
            ((ColumnPropertiesPanel)columnPropertyPanel).addColumnChangeListener(this);
        }
        columnPropertyPanel = this.clp.getCurrentSelection();
        if (columnPropertyPanel != null) {
            this.gizmo.refreshOneCol(columnPropertyPanel.getSourceColID());
        } else {
            this.gizmo.refreshOneCol(0);
        }
        this.validate();
    }

    private String[] getAllDateMasks() {
        String string = null;
        if (this._conn != null) {
            try {
                string = ((OracleNLSProvider)NLSProvider.getProvider((Connection)this._conn)).getOraDATEFormat().toPattern();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.addMask(string, this.getDateMasks());
    }

    private String[] getAllTimestampMasks() {
        String string = null;
        if (this._conn != null) {
            try {
                string = ((OracleNLSProvider)NLSProvider.getProvider((Connection)this._conn)).getOraTIMESTAMPFormat().toPattern();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.addMask(string, this.getTimestampMasks());
    }

    private String[] getAllTimestamptzMasks() {
        String string = null;
        if (this._conn != null) {
            try {
                string = ((OracleNLSProvider)NLSProvider.getProvider((Connection)this._conn)).getOraTIMESTAMPTZFormat().toPattern();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.addMask(string, this.getTimestamptzMasks());
    }

    private String[] getTimestampltzMasks() {
        String string = null;
        if (this._conn != null) {
            try {
                string = ((OracleNLSProvider)NLSProvider.getProvider((Connection)this._conn)).getOraTIMESTAMPLTZFormat().toPattern();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.addMask(string, this.getTimestampMasks());
    }

    private String[] addMask(String string, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null) {
            return stringArray;
        }
        arrayList.add(string);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string)) continue;
                return stringArray;
            }
            for (String string2 : stringArray) {
                arrayList.add(string2);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected void setNullVisible(boolean bl) {
        if (this.colPropPanel != null) {
            this.colPropPanel.setNullVisible(bl);
        }
    }

    protected void setDefaultVisible(boolean bl) {
        if (this.colPropPanel != null) {
            this.colPropPanel.setDefaultVisible(bl);
        }
    }

    protected void setCommentVisible(boolean bl) {
        if (this.colPropPanel != null) {
            this.colPropPanel.setCommentVisible(bl);
        }
    }

    protected void setNameEnabled(boolean bl) {
        if (this.colPropPanel != null) {
            this.colPropPanel.setNameEnabled(bl);
        }
    }

    protected void setPrecisionScaleEnabled(boolean bl) {
        if (this.colPropPanel != null) {
            this.colPropPanel.setPrecisionScaleEnabled(bl);
        }
    }

    protected void setPrecisionScaleVisible(boolean bl) {
        if (this.colPropPanel != null) {
            this.colPropPanel.setPrecisionScaleVisible(bl);
        }
    }

    protected void addColumnChangeListener(ColumnChangeListener columnChangeListener) {
        this.colPropPanel.addColumnChangeListener(columnChangeListener);
    }

    private void populateSrcDataColumns(TraversableContext traversableContext) {
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        ((DefaultListModel)this.clp.getLstColumns().getModel()).clear();
        Column[] columnArray = (Column[])this._iProps.get(ImportKeys.SELECTED_COLUMNS);
        for (int i = columnArray.length - 1; i >= 0; --i) {
            this.clp.addColumn(columnArray[i]);
        }
        this.clp.getLstColumns().setSelectedIndex(0);
        Column column = this.clp.getCurrentSelection();
    }

    public Object getExitTransition() {
        int n = (Integer)this._iProps.get(ImportKeys.LOAD_METHOD);
        return n != 2 && n != 3 && n != 4 && n != 5;
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        Object object;
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        if (this.matchBy != null) {
            this._iProps.put(ImportKeys.MATCH_BY_TYPE, (Object)this.matchBy.getSelectedIndex());
        }
        if (traversableContext.getDirection() == 1) {
            object = null;
            String string = null;
            String string2 = null;
            String string3 = null;
            for (LoadFieldValidator loadFieldValidator : (LoadFieldValidator[])this._iProps.get(ImportKeys.VALIDATORS)) {
                Column column;
                LoadField loadField = loadFieldValidator.getLoadField();
                if (loadField.isLoad() && loadFieldValidator.getHighestExitCode() == ExitCode.EXIT_SEVERE) {
                    throw new TraversalException(DataImportArb.getString("COLUMN_ON_EXIT_ERR"));
                }
                if (!this._iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS).booleanValue() || (column = loadField.getColumn()) == null) continue;
                if (column.getType().equals(DataType.DATE.toString())) {
                    if (object == null || object.isEmpty()) {
                        object = column.getFormat();
                        this._iProps.put(ImportKeys.DATE_MASK_DATE, (Object)column.getFormat());
                        continue;
                    }
                    if (column.getFormat() == null || column.getFormat().equals(object)) continue;
                    throw new TraversalException(DataImportArb.getString("COLUMN_ON_EXIT_DATE_FORMAT_ERR"));
                }
                if (column.getType().equals(DataType.TIMESTAMP.toString())) {
                    if (string == null || string.isEmpty()) {
                        string = column.getFormat();
                        this._iProps.put(ImportKeys.DATE_MASK_TIMESTAMP, (Object)column.getFormat());
                        continue;
                    }
                    if (column.getFormat() == null || column.getFormat().equals(string)) continue;
                    throw new TraversalException(DataImportArb.getString("COLUMN_ON_EXIT_TS_FORMAT_ERR"));
                }
                if (column.getType().equals(DataType.TIMESTAMPTZ.toString())) {
                    if (string2 == null || string2.isEmpty()) {
                        string2 = column.getFormat();
                        this._iProps.put(ImportKeys.DATE_MASK_TIMESTAMPTZ, (Object)column.getFormat());
                        continue;
                    }
                    if (column.getFormat() == null || column.getFormat().equals(string2)) continue;
                    throw new TraversalException(DataImportArb.getString("COLUMN_ON_EXIT_TSTZ_FORMAT_ERR"));
                }
                if (!column.getType().equals(DataType.TIMESTAMPLTZ.toString())) continue;
                if (string3 == null || string3.isEmpty()) {
                    string3 = column.getFormat();
                    this._iProps.put(ImportKeys.DATE_MASK_TIMESTAMPLTZ, (Object)column.getFormat());
                    continue;
                }
                if (column.getFormat() == null || column.getFormat().equals(string3)) continue;
                throw new TraversalException(DataImportArb.getString("COLUMN_ON_EXIT_TSLTZ_FORMAT_ERR"));
            }
        }
        object = (Column)this.clp.getLstColumns().getSelectedValue();
        object.refreshData(this.colPropPanel.getColumnDetails());
        this.colPropPanel.setDateMask(object.getFormat());
    }

    private void validateColumnNames(TraversableContext traversableContext) throws TraversalException {
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        Column[] columnArray = this.genericTable.getColumns();
        int n = 0;
        Object object = "";
        String string = " ";
        DBObject dBObject = (DBObject)((Object)this._iProps.get(ImportKeys.DBOBJECT));
        Database database = dBObject.getDatabase();
        if (columnArray != null) {
            n = columnArray.length;
            for (int i = 0; i < n; ++i) {
                String string2 = columnArray[i].getName();
                try {
                    database.validateName("COLUMN", string2);
                    continue;
                }
                catch (InvalidNameException invalidNameException) {
                    object = (String)object + string + string2;
                    if (string.equals(" ")) {
                        this.clp.setCurrentSelection(i);
                    }
                    string = ",";
                }
            }
        }
        if (((String)object).length() != 0) {
            throw new TraversalException(DataImportArb.format("COLUMN_NAMES_INVALID_ERROR", object));
        }
    }

    private void ensureSelectedColumnsHaveMapping(TraversableContext traversableContext) {
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        Column[] columnArray = (Column[])this._iProps.get(ImportKeys.SELECTED_COLUMNS);
        int n = 0;
        if (columnArray != null) {
            n = columnArray.length;
            for (int i = 0; i < n; ++i) {
                if (columnArray[i].getName() != null && columnArray[i].getPrecision() > 0 && columnArray[i].getType() != null) continue;
                this.clp.setCurrentSelection(i);
            }
        }
    }

    private void populateDBO(TraversableContext traversableContext) {
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        GenericTable genericTable = (GenericTable)this._iProps.get(ImportKeys.TABLE);
        if (this._iProps.get(ImportKeys.DBOBJECT) == null) {
            if (genericTable == null) {
                genericTable = new GenericTable();
                genericTable.setTableName((String)this._iProps.get(ImportKeys.TABLE_NAME));
                Column[] columnArray = (Column[])this._iProps.get(ImportKeys.FILE_COLUMNS);
                for (int i = columnArray.length - 1; i >= 0; --i) {
                    columnArray[i].setEditable(true);
                    genericTable.addColumn(columnArray[i]);
                }
            }
        } else if (DataUIUtils.isExisting(this._iProps.get(ImportKeys.DBOBJECT))) {
            this.insertToExistingTable = true;
            DBObject dBObject = (DBObject)((Object)this._iProps.get(ImportKeys.DBOBJECT));
            if (genericTable == null) {
                try {
                    genericTable = new GenericTable(Connections.getInstance().getConnection((String)this._iProps.get(ImportKeys.CONNECTION_NAME)), dBObject.getSchemaName(), dBObject.getObjectName(), true);
                }
                catch (DBException dBException) {
                    LOGGER.log(Level.SEVERE, dBException.getStackTrace()[0].toString(), dBException);
                }
            }
        } else if (genericTable == null) {
            genericTable = new GenericTable();
            genericTable.setTableName((String)this._iProps.get(ImportKeys.TABLE_NAME));
            genericTable = new GenericTable();
            genericTable.setTableName((String)this._iProps.get(ImportKeys.TABLE_NAME));
            Column[] columnArray = (Column[])this._iProps.get(ImportKeys.FILE_COLUMNS);
            for (int i = 0; i < columnArray.length; ++i) {
                columnArray[i].setEditable(true);
                genericTable.addColumn(columnArray[i]);
            }
        }
        this.setTable(genericTable);
        this.setInstruction((DBObject)((Object)this._iProps.get(ImportKeys.DBOBJECT)));
    }

    private void setInstruction(DBObject dBObject) {
        if (DataUIUtils.isExisting(this._iProps.get(ImportKeys.DBOBJECT))) {
            this.instructions.setText(DataImportArb.getString("DATA_MAPPING_EXISTING_INFO"));
            return;
        }
        this.instructions.setText(DataImportArb.getString("DATA_MAPPING_CREATE_INFO"));
    }

    private void setTable(GenericTable genericTable) {
        this.genericTable = genericTable;
    }

    @Override
    public void columnChanged(ColumnChangeEvent columnChangeEvent) {
        Column column = columnChangeEvent.getColumn();
        this._column.refreshData(column);
        boolean bl = true;
        ColumnChangeEvent.Type type = columnChangeEvent.getType();
        switch (type) {
            case MAPPING: {
                this.clp.resetValidators(LoadFieldValidator.Test.MAPPED);
                this.clp.resetCurrentSelectionValidator();
                break;
            }
            case NAME: {
                this.genericTable.getTable().getColumnByIndex(column.getSourceColID()).setName(column.getName());
                this.clp.resetValidators(LoadFieldValidator.Test.COLUMN_NAME);
                bl = false;
                break;
            }
            case DATATYPE: {
                if (this.colPropPanel != null) {
                    this.colPropPanel.setColumn(this._column);
                    if ((this._column.getType().equals(DataType.DATE.toString()) || this._column.getType().equals(DataType.TIMESTAMP.toString()) || this._column.getType().equals(DataType.TIMESTAMPTZ.toString()) || this._column.getType().equals(DataType.TIMESTAMPLTZ.toString())) && (this._column.getFormat() == null || this._column.getFormat().length() == 0)) {
                        this.detectFormat(this._column);
                        if (this._column.getFormat() != null && !this._column.getFormat().isEmpty()) {
                            this.colPropPanel.setDateMask(this._column.getFormat());
                        }
                    }
                }
                this.clp.resetCurrentSelectionValidator(new LoadFieldValidator.Test[]{LoadFieldValidator.Test.HAS_DATATYPE, LoadFieldValidator.Test.HAS_FORMAT, LoadFieldValidator.Test.COMPATIBLE_DATA});
                break;
            }
            case PRECISION: {
                this.clp.resetCurrentSelectionValidator(new LoadFieldValidator.Test[]{LoadFieldValidator.Test.HAS_SIZE, LoadFieldValidator.Test.COMPATIBLE_DATA});
                break;
            }
            case SCALE: {
                this.clp.resetCurrentSelectionValidator(new LoadFieldValidator.Test[]{LoadFieldValidator.Test.HAS_SIZE, LoadFieldValidator.Test.COMPATIBLE_DATA});
                break;
            }
            case FORMAT: {
                this.clp.resetCurrentSelectionValidator(new LoadFieldValidator.Test[]{LoadFieldValidator.Test.HAS_FORMAT, LoadFieldValidator.Test.COMPATIBLE_DATA});
                break;
            }
            case DATA: {
                this.clp.resetCurrentSelectionValidator(LoadFieldValidator.Test.COMPATIBLE_DATA);
                break;
            }
            default: {
                this.clp.resetValidators(LoadFieldValidator.Test.MAPPED);
            }
        }
        if (bl) {
            this.gizmo.refreshOneCol(this._column.getSourceColID());
            this.gizmo.repaint();
        }
        this.clp.repaint();
    }

    private class SingleSelectionModel
    extends DefaultListSelectionModel {
        public SingleSelectionModel() {
            this.setSelectionMode(0);
        }

        @Override
        public void setSelectionInterval(int n, int n2) {
            int n3 = this.getMinSelectionIndex();
            super.setSelectionInterval(n, n2);
            int n4 = this.getMinSelectionIndex();
            if (n3 != n4) {
                this.updateSingleSelection(n3, n4);
            }
        }

        public void updateSingleSelection(int n, int n2) {
        }
    }
}

