/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class BatchSizePanel {
    private JLabel BatchSizeRowsLabel1;
    private NumericSpinBox BatchSizeSpinBox;
    private static final long serialVersionUID = -2739487292165944123L;

    public BatchSizePanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void jbInit() throws Exception {
        this.initBatchSize();
    }

    public JLabel getBatchSizeLabel() {
        return this.BatchSizeRowsLabel1;
    }

    public NumericSpinBox getBatchSizeSpinBox() {
        return this.BatchSizeSpinBox;
    }

    void initBatchSize() {
        this.BatchSizeRowsLabel1 = new JLabel(StringUtils.stripMnemonic((String)Messages.getString("ImportModesPrefs.batchSize")));
        this.BatchSizeRowsLabel1.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("ImportModesPrefs.batchSize")));
        this.BatchSizeSpinBox = new NumericSpinBox(0, Integer.MAX_VALUE);
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        this.BatchSizeSpinBox.setIntValue(dBConfig.getInt("IMPORT_INSERT_BATCH_SIZE"));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putInt("IMPORT_INSERT_BATCH_SIZE", this.BatchSizeSpinBox.getIntValue());
    }
}

