/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.importer;

import java.net.URL;
import javax.swing.SwingUtilities;
import oracle.dbtools.common.config.IEnvironmentConfig;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.importer.writers.IImportGenerator;
import oracle.dbtools.importer.writers.ImportAPI;
import oracle.dbtools.importer.writers.ImportGenModel;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.data.Messages;
import oracle.dbtools.raptor.data.importer.ImportToolRunModeSD;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.IToolRunMode;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.db.model.SqlNode;
import oracle.ide.editor.EditorUtil;
import oracle.ide.log.LogManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.ide.util.IdeUtil;

public class ImportGenLauncherSD {
    protected ImportProperties _iProps;
    private ImportAPI _importAPI;
    private IImportGenerator _service;
    protected ImportGenModel _iGenModel;
    private IToolRunMode _tRunMode;

    public ExitCode start(ImportProperties importProperties) {
        try {
            this._iProps = importProperties;
            this._tRunMode = new ImportToolRunModeSD();
            this._tRunMode.setParms((Object)importProperties);
            this._tRunMode.setLineTerminator(this.getLineTerminator());
            this._tRunMode.isShowELog(this._iProps.getValueBoolean(ImportKeys.IS_CART) == false);
            String string = Ide.getEnvironOptions().getEncoding();
            this._tRunMode.setEncoding(string);
            this._importAPI = new ImportAPI(this._iProps, this._tRunMode);
            this._iGenModel = this._importAPI.getModel();
            this._tRunMode.setRunMode(this._iProps.getValueBoolean(ImportKeys.IS_BATCH) != false ? IToolRunMode.RunMode.NO_GUI : IToolRunMode.RunMode.GUI);
            this._service = this._importAPI.getService();
            ExitCode exitCode = this._importAPI.start();
            return exitCode;
        }
        catch (Exception exception) {
            ExitCode exitCode = ExitCode.EXIT_SEVERE;
            exitCode.setMessage(exitCode.getMessage() + " " + exception.toString());
            return ExitCode.EXIT_SEVERE;
        }
    }

    public ImportGenModel getGenModel() {
        return this._iGenModel;
    }

    public IImportGenerator getService() {
        return this._service;
    }

    public void process() {
        this._importAPI.process();
        RaptorTask raptorTask = this._tRunMode.getTask();
        raptorTask.setCancellable(true);
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new SDTaskListener());
        RaptorTaskManager.getInstance().addTask(raptorTask);
    }

    protected String getLineTerminator() {
        return IEnvironmentConfig.Storage.getInstance().getString("ENV_LINE_TERMINATOR");
    }

    final class SDTaskListener
    extends RaptorTaskAdapter {
        SDTaskListener() {
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            this.finish();
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            this.finish();
        }

        private void finish() {
            URL uRL = (URL)ImportGenLauncherSD.this._iProps.get(ImportKeys.URL_FOR_AUTO_OPEN);
            if (uRL != null) {
                if (!ImportGenLauncherSD.this._iGenModel.isBatch() && uRL.getPath().endsWith(".sql")) {
                    if (ImportGenLauncherSD.this._iProps.getValueBoolean(ImportKeys.SEND_TO_WORKSHEET).booleanValue() || ImportGenLauncherSD.this._iProps.getValueInteger(ImportKeys.LOAD_METHOD) != 0 && ImportGenLauncherSD.this._iGenModel.getStream().isFileUsed()) {
                        Logger.info(((Object)((Object)this)).getClass(), (String)Messages.getString("ImportGenerator.77"));
                        try {
                            this.openSqlNodeForURL((URL)ImportGenLauncherSD.this._iProps.get(ImportKeys.URL_FOR_AUTO_OPEN));
                        }
                        catch (Exception exception) {
                            Logger.warn(((Object)((Object)this)).getClass(), (Throwable)exception);
                        }
                    }
                } else {
                    try {
                        ImportGenLauncherSD.this._iGenModel.getStream().closeLog();
                        this.openTextNodeForURL(uRL);
                    }
                    catch (Exception exception) {
                        Logger.warn(((Object)((Object)this)).getClass(), (Throwable)exception);
                    }
                }
            }
            if (!ImportGenLauncherSD.this._iGenModel.isBatch() && ImportGenLauncherSD.this._iGenModel.getStream().isBadFileUsed()) {
                try {
                    this.openSqlNodeForURL(ImportGenLauncherSD.this._iGenModel.getStream().geturlBad());
                }
                catch (Exception exception) {
                    Logger.warn(((Object)((Object)this)).getClass(), (Throwable)exception);
                }
            }
            ImportGenLauncherSD.this._iGenModel.getStream().finished();
            if (ImportGenLauncherSD.this._iGenModel.isTableCreated()) {
                this.getPostProcessCallback().run();
            }
            if (!ImportGenLauncherSD.this._iGenModel.isExitCodeSuccess()) {
                LogManager.getLogManager().getLogWindow().selectPage(LogManager.getLogManager().getMsgPage());
                LogManager.getLogManager().getLogWindow().activate();
            }
        }

        private void openTextNodeForURL(URL uRL) throws Exception {
            TextNode textNode = null;
            textNode = (TextNode)NodeFactory.findOrCreate(TextNode.class, (URL)uRL);
            final TextNode textNode2 = textNode;
            if (textNode2 != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                EditorUtil.openDefaultEditorInFrame((Node)textNode2);
                            }
                        });
                    }
                });
            }
        }

        private void openSqlNodeForURL(URL uRL) throws Exception {
            SqlNode sqlNode = null;
            sqlNode = (SqlNode)NodeFactory.findOrCreate(SqlNode.class, (URL)uRL);
            final SqlNode sqlNode2 = sqlNode;
            if (sqlNode2 != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                EditorUtil.openDefaultEditorInFrame((Node)sqlNode2);
                            }
                        });
                    }
                });
            }
        }

        protected ObjectActionController.ObjectActionPostProcess getPostProcessCallback() {
            ObjectAction objectAction = (ObjectAction)((Object)ImportGenLauncherSD.this._iProps.get(ImportKeys.OBJECTACTION));
            DBObject dBObject = (DBObject)((Object)ImportGenLauncherSD.this._iProps.get(ImportKeys.DBOBJECT));
            ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback(objectAction, dBObject);
            return objectActionPostProcess;
        }
    }
}

