/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.plsql.TabCol;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.controls.grid.RSTMSql;
import oracle.dbtools.raptor.controls.grid.RSTableMessages;
import oracle.dbtools.raptor.controls.grid.RaptorGridPersistedSettings;
import oracle.dbtools.raptor.controls.grid.ResultSetGridColumn;
import oracle.dbtools.raptor.controls.grid.ResultSetTableModel;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.newscriptrunner.MatchRecognizeUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;
import oracle.javatools.util.ModelUtil;
import oracle.jdbc.OraclePreparedStatement;

public class OracleRSTModel
extends ResultSetTableModel {
    @Override
    protected void init(String string, String string2, List<?> list, Map<String, ?> map) {
        super.init(string, string2, list, map);
    }

    @Override
    public String getModifiedSql() {
        ArrayList<TabCol.Column> arrayList;
        Object object;
        if (this._sql == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(this._rstmsql.getModifiedSql());
        String string = this.getSortString();
        if (this._autoApplyPersistedSort && string == null && this._rs == null) {
            String string2;
            object = RaptorGridPersistedSettings.loadPersistedSettings((String)this.getModelUniqueName());
            arrayList = null;
            if (object != null && (arrayList = object.getSortClauses()) != null && arrayList.size() > 0 && (string2 = (String)arrayList.get(0)) != null && !string2.equals("")) {
                string = string2;
            }
        }
        if (string != null && string.trim().length() > 0) {
            if (this.hasDuplicateColumnNames()) {
                try {
                    if (Connections.getInstance().isOracle(this.getConnectionName())) {
                        object = new TabCol(this.getConnectionName());
                        arrayList = ((TabCol)object).fetchColumns(stringBuilder.toString());
                        stringBuilder = new StringBuilder(((TabCol)object).disambiguate(arrayList));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            stringBuilder.insert(0, "select * from (\n");
            stringBuilder.append("\n ) sub1 order by ");
            stringBuilder.append(string);
        }
        return RSTMSql.sanitizeSql(stringBuilder.toString());
    }

    @Override
    protected PreparedStatement prepareStatement() throws SQLException, DBException {
        String string = this.getModifiedSql();
        OraclePreparedStatement oraclePreparedStatement = null;
        if (ModelUtil.hasLength((String)string) && this.getConnection() != null) {
            MatchRecognizeUtil matchRecognizeUtil = new MatchRecognizeUtil(string);
            if (!matchRecognizeUtil.isAltered()) {
                oraclePreparedStatement = (OraclePreparedStatement)this.getConnection().prepareStatement(string);
                this.setEscapeProcessing((PreparedStatement)oraclePreparedStatement, string);
            } else {
                oraclePreparedStatement = (OraclePreparedStatement)this.getConnection().prepareStatement(matchRecognizeUtil.getOutputText());
                try {
                    oraclePreparedStatement.setEscapeProcessing(true);
                }
                catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
                    // empty catch block
                }
            }
            if (this.getBindList() != null && this.getBindList().size() > 0) {
                DBUtil.bind((PreparedStatement)oraclePreparedStatement, this.getBindList());
            } else if (this.getBindMap() != null && this.getBindMap().size() > 0) {
                DBUtil.bind((String)string, (PreparedStatement)oraclePreparedStatement, this.getBindMap());
            }
        }
        return oraclePreparedStatement;
    }

    private void setEscapeProcessing(PreparedStatement preparedStatement, String string) throws SQLException {
        List list = LexerToken.parse((String)string);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (LexerToken lexerToken : list) {
            if (!bl) {
                if (!"PATTERN".equalsIgnoreCase(lexerToken.content)) continue;
                bl = true;
                continue;
            }
            if (!bl2) {
                if (!"{".equals(lexerToken.content)) continue;
                bl2 = true;
                continue;
            }
            if (bl3 || !"?".equals(lexerToken.content)) continue;
            bl3 = true;
            break;
        }
        if (!bl3) {
            preparedStatement.setEscapeProcessing(false);
        }
    }

    public boolean isColumnSortable(int n) {
        boolean bl = super.isColumnSortable(n);
        if (bl) {
            int n2 = this.getColumnSqlType(n);
            switch (n2) {
                case -13: 
                case -10: 
                case -7: 
                case -4: 
                case -3: 
                case -2: 
                case -1: 
                case 1111: 
                case 2000: 
                case 2002: 
                case 2003: 
                case 2004: 
                case 2005: 
                case 2006: 
                case 2007: 
                case 2008: 
                case 2011: {
                    Connection connection = null;
                    try {
                        connection = this.getConnection();
                    }
                    catch (DBException dBException) {
                        return false;
                    }
                    if (connection == null) {
                        return false;
                    }
                    ConnectionTypeDetails connectionTypeDetails = ConnectionTypeDetails.getTypeDetails(this.getConnectionName(), connection);
                    if (connectionTypeDetails == null) {
                        return false;
                    }
                    return connectionTypeDetails.isColumnTypeSortable(this.getColumnSqlType(n));
                }
            }
        }
        return bl;
    }

    public boolean isSortable() {
        return true;
    }

    @Override
    protected void handleFetchNextSQLException(SQLException sQLException, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws ExecutionException {
        int n;
        if (!(iRaptorTaskProgressUpdater != null && iRaptorTaskProgressUpdater.getDescriptor().isCancelled() || this._rstmsql.getAllFilters().size() <= 0 || (n = sQLException.getErrorCode()) != 918)) {
            Hashtable<String, ResultSetGridColumn> hashtable = new Hashtable<String, ResultSetGridColumn>();
            for (int i = 0; i < this.gridColumns.size(); ++i) {
                ResultSetGridColumn resultSetGridColumn = (ResultSetGridColumn)((Object)this.gridColumns.get(i));
                if (hashtable.containsKey(resultSetGridColumn.getOriginal())) {
                    sQLException = new SQLException(MessageFormat.format(RSTableMessages.getString("OracleRSTModel.1"), resultSetGridColumn.getOriginal()), sQLException.getSQLState(), sQLException.getErrorCode(), sQLException);
                    break;
                }
                hashtable.put(resultSetGridColumn.getOriginal(), resultSetGridColumn);
            }
        }
        super.handleFetchNextSQLException(sQLException, iRaptorTaskProgressUpdater);
    }
}

