/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.html;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayPanel;
import oracle.dbtools.raptor.controls.display.DisplaySimpleChart;
import oracle.dbtools.raptor.controls.display.IErrorHandler;
import oracle.dbtools.raptor.controls.display.html.HtmlGenerationContext;
import oracle.dbtools.raptor.controls.display.html.IHtmlGenerator;
import oracle.dbtools.raptor.controls.display.html.ResourceGenerationContext;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.LocalXMLDataSource;
import oracle.dss.graph.Graph;
import oracle.dss.graph.ImagemapComponent;

public class ChartHtmlGenerator
implements IHtmlGenerator {
    private DisplayModel model;
    private DisplayPanel displayPanel;
    private Graph graph;
    private Writer writer;
    private String chartImageName;
    private String imageMapName;
    private String[] bindColNames;

    @Override
    public void generateStaticResources(ResourceGenerationContext resourceGenerationContext) {
    }

    @Override
    public void generateHtml(HtmlGenerationContext htmlGenerationContext) {
        this.writer = htmlGenerationContext.writer();
        this.model = htmlGenerationContext.model();
        this.model.setConnName(htmlGenerationContext.connectionName());
        this.displayPanel = new DisplayPanel(htmlGenerationContext.model());
        DisplaySimpleChart displaySimpleChart = (DisplaySimpleChart)this.displayPanel.getMainUI();
        displaySimpleChart.disableRefreshInTask();
        displaySimpleChart.setErrorHandler(htmlGenerationContext.errorHandler());
        displaySimpleChart.appendBindMap(htmlGenerationContext.binds());
        displaySimpleChart.refresh(htmlGenerationContext.connection());
        if (!htmlGenerationContext.errorHandler().hasErrors()) {
            this.graph = displaySimpleChart.getGraph();
            this.bindColNames = displaySimpleChart.bindColNames();
            this.chartImageName = "chart." + htmlGenerationContext.id() + ".png";
            this.imageMapName = "chartmap" + htmlGenerationContext.id();
            try {
                this.saveImage(htmlGenerationContext);
                this.displayPanel.close();
                if (htmlGenerationContext.isChildReport()) {
                    this.writer.write("<img src=\"" + htmlGenerationContext.resourcePath(this.chartImageName) + "\"/>\n");
                } else {
                    this.writeImageMap(htmlGenerationContext);
                    this.writer.write("<img src=\"" + htmlGenerationContext.resourcePath(this.chartImageName) + "\" usemap=\"#" + this.imageMapName + "\"/>\n");
                }
            }
            catch (Exception exception) {
                htmlGenerationContext.errorHandler().handleError(IErrorHandler.Category.OTHER, exception);
            }
        }
    }

    private void saveImage(HtmlGenerationContext htmlGenerationContext) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        this.graph.setImageSize(new Dimension(1000, 333));
        this.graph.setScaleFontSizeForGIF(-1);
        this.graph.exportToPNG((OutputStream)bufferedOutputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        htmlGenerationContext.addResource(this.chartImageName, byteArrayInputStream);
    }

    private void writeImageMap(HtmlGenerationContext htmlGenerationContext) throws Exception {
        this.writer.write("<map name=\"" + this.imageMapName + "\">\n");
        Enumeration enumeration = this.graph.getImagemapEnumeration(1);
        int n = 0;
        while (enumeration.hasMoreElements()) {
            ImagemapComponent imagemapComponent = (ImagemapComponent)enumeration.nextElement();
            ComponentHandle componentHandle = imagemapComponent.getComponentHandle();
            if (!(componentHandle instanceof DataComponentHandle)) continue;
            DataComponentHandle dataComponentHandle = (DataComponentHandle)componentHandle;
            int n2 = dataComponentHandle.getColumn();
            int n3 = dataComponentHandle.getRow();
            int n4 = dataComponentHandle.getSeries();
            int n5 = dataComponentHandle.getGroup();
            LocalXMLDataSource localXMLDataSource = (LocalXMLDataSource)this.graph.getDataSource();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(this.bindColNames[0], localXMLDataSource.getSliceLabel(0, n5, "label"));
            hashMap.put(this.bindColNames[1], localXMLDataSource.getSliceLabel(1, n4, "label"));
            hashMap.put(this.bindColNames[2], localXMLDataSource.getValue(n3, n2, "dataValue"));
            htmlGenerationContext.addChildBinding(hashMap);
            Rectangle rectangle = imagemapComponent.getPlacement().getBounds();
            this.writer.write("<area shape=\"RECT\" coords=\"" + rectangle.x + "," + rectangle.y + "," + (rectangle.x + rectangle.width) + "," + (rectangle.y + rectangle.height) + "\" onMouseOver=\"document.body.style.cursor ='pointer'\" onMouseOut=\"document.body.style.cursor ='default'\" onClick=\"onSelectRowIndex(" + n++ + ")\"/>\n");
        }
        this.writer.write("</map>\n");
    }
}

