/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.chart;

import java.util.BitSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.controls.display.DisplayConstants;
import oracle.dbtools.raptor.controls.display.chart.Archiver;
import oracle.dbtools.raptor.controls.display.chart.BooleanArchiver;
import oracle.dbtools.raptor.controls.display.chart.ChartType;
import oracle.dbtools.raptor.controls.display.chart.PropertyDef;
import oracle.dbtools.raptor.controls.display.chart.PropertyGroup;
import oracle.dbtools.raptor.controls.display.chart.PropertyType;
import oracle.dbtools.raptor.controls.display.chart.StyleArchiver;
import oracle.dss.graph.Graph;

class StyleProperties
extends PropertyGroup {
    StyleProperties() {
    }

    @Override
    void register(Map<PropertyType, PropertyDef> map) {
        BitSet bitSet = ChartType.all();
        map.put(PropertyType.STYLE, new PropertyDef<DisplayConstants.CHART_STYLES>(bitSet){
            private StyleArchiver archiver;
            {
                this.archiver = new StyleArchiver();
            }

            @Override
            DisplayConstants.CHART_STYLES getGraphValue(Graph graph) {
                return DisplayConstants.CHART_STYLES.getFromPath(graph.getStylePath());
            }

            @Override
            void setGraphValue(Graph graph, DisplayConstants.CHART_STYLES cHART_STYLES) {
                try {
                    graph.setStylePath(cHART_STYLES.getPath());
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }

            @Override
            Archiver<DisplayConstants.CHART_STYLES> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet2 = ChartType.all();
        bitSet2.andNot(ChartType.stocks());
        map.put(PropertyType.GRADIENT, new PropertyDef<Boolean>(bitSet2){
            private BooleanArchiver archiver;
            {
                this.archiver = new BooleanArchiver();
            }

            @Override
            Boolean getGraphValue(Graph graph) {
                return graph.getSeriesEffect() != 0;
            }

            @Override
            void setGraphValue(Graph graph, Boolean bl) {
                graph.setSeriesEffect(bl != false ? 2 : 0);
            }

            @Override
            Archiver<Boolean> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet3 = ChartType.all();
        bitSet3.andNot(ChartType.stocks());
        bitSet3.andNot(ChartType.radars());
        bitSet3.andNot(ChartType.funnels());
        bitSet3.andNot(ChartType.threeDs());
        map.put(PropertyType.THREED, new PropertyDef<Boolean>(bitSet3){
            private BooleanArchiver archiver;
            {
                this.archiver = new BooleanArchiver();
            }

            @Override
            Boolean getGraphValue(Graph graph) {
                return graph.is3DEffect();
            }

            @Override
            void setGraphValue(Graph graph, Boolean bl) {
                graph.set3DEffect(bl.booleanValue());
            }

            @Override
            Archiver<Boolean> archiver() {
                return this.archiver;
            }
        });
    }
}

