/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.chart;

import java.util.BitSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.controls.display.chart.Archiver;
import oracle.dbtools.raptor.controls.display.chart.ChartPropertyManagerImpl;
import oracle.dbtools.raptor.controls.display.chart.ChartType;
import oracle.dbtools.raptor.controls.display.chart.Property;
import oracle.dbtools.raptor.controls.display.chart.PropertyName;
import oracle.dbtools.raptor.controls.display.chart.PropertyType;
import oracle.dss.graph.Graph;

abstract class PropertyDef<T> {
    private BitSet chartTypeMask;

    PropertyDef(BitSet bitSet) {
        this.chartTypeMask = bitSet;
    }

    boolean isApplicable(ChartType chartType) {
        return this.chartTypeMask.get(chartType.typeNo());
    }

    Property<T> loadProperty(PropertyName propertyName, Map<String, String> map) {
        Property<T> property = null;
        try {
            T t = this.archiver().load(propertyName, map);
            if (t != null) {
                property = new Property<T>(this, t);
            }
        }
        catch (RuntimeException runtimeException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, runtimeException.getStackTrace()[0].toString(), runtimeException);
        }
        return property;
    }

    void saveProperty(PropertyName propertyName, Map<String, String> map, Property<T> property) {
        try {
            this.archiver().save(propertyName, map, property.get());
        }
        catch (RuntimeException runtimeException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, runtimeException.getStackTrace()[0].toString(), runtimeException);
        }
    }

    Property<T> getDefaultProperty(ChartPropertyManagerImpl chartPropertyManagerImpl, Graph graph) {
        Object t = null;
        if (!this.isGroupProperty()) {
            try {
                t = this.getGraphValue(graph);
            }
            catch (RuntimeException runtimeException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, runtimeException.getStackTrace()[0].toString(), runtimeException);
            }
        }
        if (t == null) {
            t = this.archiver().getDefault(chartPropertyManagerImpl);
        }
        return new Property<Object>(this, t);
    }

    void updateGraph(Graph graph, Property<T> property) {
        try {
            this.setGraphValue(graph, property.get());
        }
        catch (RuntimeException runtimeException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, runtimeException.getStackTrace()[0].toString(), runtimeException);
        }
    }

    PropertyType[] dependencies() {
        return new PropertyType[0];
    }

    boolean isGroupProperty() {
        return false;
    }

    PropertyType groupPropertyType() {
        return null;
    }

    abstract T getGraphValue(Graph var1);

    abstract void setGraphValue(Graph var1, T var2);

    abstract Archiver<T> archiver();
}

