/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.chart;

import java.util.Map;
import oracle.dbtools.raptor.controls.display.chart.Archiver;
import oracle.dbtools.raptor.controls.display.chart.ChartPropertyManagerImpl;
import oracle.dbtools.raptor.controls.display.chart.CurrencySymbol;
import oracle.dbtools.raptor.controls.display.chart.EnumArchiver;
import oracle.dbtools.raptor.controls.display.chart.IntegerArchiver;
import oracle.dbtools.raptor.controls.display.chart.NegativeNumberFormat;
import oracle.dbtools.raptor.controls.display.chart.NumberFormats;
import oracle.dbtools.raptor.controls.display.chart.NumberType;
import oracle.dbtools.raptor.controls.display.chart.PropertyName;
import oracle.dbtools.raptor.controls.display.chart.ScaleFactor;
import oracle.dss.dataView.managers.ViewFormat;

class NumberFormatsArchiver
extends Archiver<NumberFormats> {
    private EnumArchiver<NumberType> numberTypeArchiver = new EnumArchiver(NumberType.class, (Enum[])NumberType.values());
    private IntegerArchiver decimalPlacesArchiver = new IntegerArchiver();
    private EnumArchiver<ScaleFactor> scaleFactorArchiver = new EnumArchiver(ScaleFactor.class, (Enum[])ScaleFactor.values());
    private EnumArchiver<NegativeNumberFormat> negativeNumberFormatArchiver = new EnumArchiver(NegativeNumberFormat.class, (Enum[])NegativeNumberFormat.values());
    private EnumArchiver<CurrencySymbol> currencySymbolArchiver = new EnumArchiver(CurrencySymbol.class, (Enum[])CurrencySymbol.values());

    NumberFormatsArchiver() {
    }

    @Override
    NumberFormats load(PropertyName propertyName, Map<String, String> map) {
        NumberType numberType = (NumberType)this.numberTypeArchiver.load(propertyName.add(Members.TYPE), (Map)map);
        Object object = this.decimalPlacesArchiver.load(propertyName.add(Members.DECIMAL_PLACES), (Map)map);
        ScaleFactor scaleFactor = (ScaleFactor)this.scaleFactorArchiver.load(propertyName.add(Members.SCALE_FACTOR), (Map)map);
        NegativeNumberFormat negativeNumberFormat = (NegativeNumberFormat)this.negativeNumberFormatArchiver.load(propertyName.add(Members.NEGATIVE_NUMBER_FORMAT), (Map)map);
        CurrencySymbol currencySymbol = (CurrencySymbol)this.currencySymbolArchiver.load(propertyName.add(Members.CURRENCY_SYMBOL), (Map)map);
        NumberFormats numberFormats = null;
        if (numberType != null || object != null || scaleFactor != null || negativeNumberFormat != null || currencySymbol != null) {
            numberFormats = new NumberFormats(numberType, (Integer)object, scaleFactor, negativeNumberFormat, currencySymbol);
        }
        return numberFormats;
    }

    @Override
    NumberFormats getDefault(ChartPropertyManagerImpl chartPropertyManagerImpl) {
        return new NumberFormats();
    }

    @Override
    void verifyValue(ChartPropertyManagerImpl chartPropertyManagerImpl, NumberFormats numberFormats) {
    }

    @Override
    void save(PropertyName propertyName, Map<String, String> map, NumberFormats numberFormats) {
        this.numberTypeArchiver.save(propertyName.add(Members.TYPE), map, numberFormats.numberType());
        this.decimalPlacesArchiver.save(propertyName.add(Members.DECIMAL_PLACES), map, numberFormats.decimalPlaces());
        this.scaleFactorArchiver.save(propertyName.add(Members.SCALE_FACTOR), map, numberFormats.scaleFactor());
        this.negativeNumberFormatArchiver.save(propertyName.add(Members.NEGATIVE_NUMBER_FORMAT), map, numberFormats.negativeNumberFormat());
        this.currencySymbolArchiver.save(propertyName.add(Members.CURRENCY_SYMBOL), map, numberFormats.currencySymbol());
    }

    void applyValue(NumberFormats numberFormats, ViewFormat viewFormat) {
        viewFormat.setNumberType(numberFormats.numberType().graphConstant());
        viewFormat.setDecimalDigit(numberFormats.decimalPlaces().intValue());
        viewFormat.setScaleFactor(numberFormats.scaleFactor().graphConstant());
        viewFormat.setNegNumFmt(numberFormats.negativeNumberFormat().graphConstant());
        viewFormat.setCurrencySymbol(numberFormats.currencySymbol().symbol());
    }

    NumberFormats retrieveValue(ViewFormat viewFormat) {
        NumberFormats numberFormats = new NumberFormats(NumberType.get(viewFormat.getNumberType()), viewFormat.getDecimalDigit(), ScaleFactor.get(viewFormat.getScaleFactor()), NegativeNumberFormat.get(viewFormat.getNegNumFmt()), CurrencySymbol.get(viewFormat.getCurrencySymbol()));
        return numberFormats;
    }

    @Override
    Class primitiveClass() {
        return NumberFormats.class;
    }

    static enum Members {
        TYPE,
        DECIMAL_PLACES,
        THOUSANDS_SEPARATOR,
        SCALE_FACTOR,
        SHOW_SCALE_ABBREVIATION,
        NEGATIVE_NUMBER_FORMAT,
        CURRENCY_SYMBOL;

    }
}

