/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.chart;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.raptor.controls.display.chart.AbstractActionPanel;
import oracle.dbtools.raptor.controls.display.chart.AbstractLayoutPanel;
import oracle.dbtools.raptor.controls.display.chart.ChartArb;
import oracle.dbtools.raptor.controls.display.chart.ChartFont;

class FontPanel
extends AbstractActionPanel<ChartFont> {
    private JComboBox familyCombo = new JComboBox<String>(this.fontNames());
    private JSpinner sizeSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 500, 1));
    private JCheckBox boldCheck = new JCheckBox(ChartArb.getString("BOLD_LABEL"));
    private JCheckBox italicCheck = new JCheckBox(ChartArb.getString("ITALIC_LABEL"));
    private JCheckBox underlineCheck = new JCheckBox(ChartArb.getString("UNDERLINE_LABEL"));
    private JTextField sampleField;
    private JColorChooser colorChooser = new JColorChooser();

    FontPanel() {
        super(4);
        this.colorChooser.setPreviewPanel(new JPanel());
        this.sampleField = new JTextField(ChartArb.getString("SAMPLE_TEXT"));
        Dimension dimension = this.colorChooser.getPreferredSize();
        this.sampleField.setPreferredSize(dimension);
        this.sampleField.setSize(dimension);
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.setBorder(new TitledBorder(ChartArb.getString("TEXT_STYLE_LABEL")));
        jPanel.add(this.boldCheck);
        jPanel.add(this.italicCheck);
        jPanel.add(this.underlineCheck);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.setBorder(new TitledBorder(ChartArb.getString("COLOR_LABEL")));
        jPanel2.add(this.colorChooser);
        JPanel jPanel3 = new JPanel(new FlowLayout());
        jPanel3.setBorder(new TitledBorder(ChartArb.getString("PREVIEW_LABEL")));
        jPanel3.add(this.sampleField);
        this.familyCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontPanel.this.updateSampleFont();
            }
        });
        this.sizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                FontPanel.this.updateSampleFont();
            }
        });
        this.boldCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontPanel.this.updateSampleFont();
            }
        });
        this.italicCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontPanel.this.updateSampleFont();
            }
        });
        this.underlineCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontPanel.this.updateSampleFont();
            }
        });
        this.colorChooser.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                FontPanel.this.updateSampleFont();
            }
        });
        this.addComponent(new JLabel(ChartArb.getString("FONT_LABEL")), 0, 0, 0, AbstractLayoutPanel.SizeToFit.NEITHER, AbstractLayoutPanel.Align.RIGHT);
        this.addComponent(this.familyCombo, 0, 1, 1, AbstractLayoutPanel.SizeToFit.NEITHER, AbstractLayoutPanel.Align.RIGHT);
        this.addComponent(new JLabel(ChartArb.getString("SIZE_LABEL")), 1, 0, 0, AbstractLayoutPanel.SizeToFit.NEITHER, AbstractLayoutPanel.Align.RIGHT);
        this.addComponent(this.sizeSpinner, 1, 1, 1, AbstractLayoutPanel.SizeToFit.NEITHER, AbstractLayoutPanel.Align.LEFT);
        this.addComponent(jPanel, 2, 0, 3, AbstractLayoutPanel.SizeToFit.NEITHER, AbstractLayoutPanel.Align.LEFT);
        this.addComponent(jPanel2, 3, 0, 3, AbstractLayoutPanel.SizeToFit.NEITHER, AbstractLayoutPanel.Align.RIGHT);
        this.addComponent(jPanel3, 4, 0, 3, AbstractLayoutPanel.SizeToFit.NEITHER, AbstractLayoutPanel.Align.RIGHT);
    }

    @Override
    void setValue(ChartFont chartFont) {
        this.familyCombo.setSelectedItem(chartFont.name());
        this.boldCheck.setSelected(chartFont.bold());
        this.italicCheck.setSelected(chartFont.italic());
        this.underlineCheck.setSelected(chartFont.underline());
        this.sizeSpinner.setValue(chartFont.size());
        this.colorChooser.setColor(chartFont.color());
        this.updateSampleFont();
    }

    @Override
    ChartFont value() {
        return new ChartFont((String)this.familyCombo.getSelectedItem(), (Integer)this.sizeSpinner.getValue(), this.boldCheck.isSelected(), this.italicCheck.isSelected(), this.underlineCheck.isSelected(), this.colorChooser.getColor());
    }

    @Override
    String title() {
        return ChartArb.getString("EDIT_FONT");
    }

    private void updateSampleFont() {
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
        hashMap.put(TextAttribute.FAMILY, this.familyCombo.getSelectedItem());
        hashMap.put(TextAttribute.SIZE, this.sizeSpinner.getValue());
        hashMap.put(TextAttribute.WEIGHT, new Float((this.boldCheck.isSelected() ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR).floatValue()));
        hashMap.put(TextAttribute.POSTURE, new Float((this.italicCheck.isSelected() ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR).floatValue()));
        hashMap.put(TextAttribute.UNDERLINE, new Integer(this.underlineCheck.isSelected() ? TextAttribute.UNDERLINE_ON : -1));
        hashMap.put(TextAttribute.FOREGROUND, this.colorChooser.getColor());
        Font font = new Font(hashMap);
        this.sampleField.setFont(font);
        this.revalidate();
    }

    private String[] fontNames() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return graphicsEnvironment.getAvailableFontFamilyNames();
    }
}

