/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.chart;

import java.awt.Color;
import java.util.Map;
import oracle.dbtools.raptor.controls.display.chart.Archiver;
import oracle.dbtools.raptor.controls.display.chart.BooleanArchiver;
import oracle.dbtools.raptor.controls.display.chart.ChartFont;
import oracle.dbtools.raptor.controls.display.chart.ChartPropertyManagerImpl;
import oracle.dbtools.raptor.controls.display.chart.ColorArchiver;
import oracle.dbtools.raptor.controls.display.chart.IntegerArchiver;
import oracle.dbtools.raptor.controls.display.chart.PropertyName;
import oracle.dbtools.raptor.controls.display.chart.StringArchiver;
import oracle.dss.graph.GraphFont;

class ChartFontArchiver
extends Archiver<ChartFont> {
    private StringArchiver nameArchiver = new StringArchiver();
    private IntegerArchiver sizeArchiver = new IntegerArchiver();
    private BooleanArchiver boldArchiver = new BooleanArchiver();
    private BooleanArchiver italicArchiver = new BooleanArchiver();
    private BooleanArchiver underlineArchiver = new BooleanArchiver();
    private ColorArchiver colorArchiver = new ColorArchiver();

    ChartFontArchiver() {
    }

    @Override
    ChartFont load(PropertyName propertyName, Map<String, String> map) {
        Object object = this.nameArchiver.load(propertyName.add(Members.NAME), (Map)map);
        Object object2 = this.sizeArchiver.load(propertyName.add(Members.SIZE), (Map)map);
        Object object3 = this.boldArchiver.load(propertyName.add(Members.WEIGHT), (Map)map);
        Object object4 = this.italicArchiver.load(propertyName.add(Members.POSTURE), (Map)map);
        Object object5 = this.underlineArchiver.load(propertyName.add(Members.UNDERLINE), (Map)map);
        Object object6 = this.colorArchiver.load(propertyName.add(Members.COLOR), (Map)map);
        ChartFont chartFont = null;
        if (object != null || object2 != null || object3 != null || object4 != null || object5 != null || object6 != null) {
            chartFont = new ChartFont((String)object, (Integer)object2, (Boolean)object3, (Boolean)object4, (Boolean)object5, (Color)object6);
        }
        return chartFont;
    }

    @Override
    ChartFont getDefault(ChartPropertyManagerImpl chartPropertyManagerImpl) {
        return new ChartFont();
    }

    @Override
    void verifyValue(ChartPropertyManagerImpl chartPropertyManagerImpl, ChartFont chartFont) {
    }

    @Override
    void save(PropertyName propertyName, Map<String, String> map, ChartFont chartFont) {
        this.nameArchiver.save(propertyName.add(Members.NAME), map, chartFont.name());
        this.sizeArchiver.save(propertyName.add(Members.SIZE), map, chartFont.size());
        this.boldArchiver.save(propertyName.add(Members.WEIGHT), map, chartFont.bold());
        this.italicArchiver.save(propertyName.add(Members.POSTURE), map, chartFont.italic());
        this.underlineArchiver.save(propertyName.add(Members.UNDERLINE), map, chartFont.underline());
        this.colorArchiver.save(propertyName.add(Members.COLOR), map, chartFont.color());
    }

    void applyValue(ChartFont chartFont, GraphFont graphFont) {
        graphFont.setGraphFontTypeface(chartFont.name());
        graphFont.setGraphFontSize(chartFont.size().intValue());
        graphFont.setGraphFontStyle((chartFont.bold() != false ? 2 : 0) | (chartFont.italic() != false ? 1 : 0) | (chartFont.underline() != false ? 4 : 0));
        graphFont.setGraphFontColor(chartFont.color());
    }

    ChartFont retrieveValue(GraphFont graphFont) {
        ChartFont chartFont = new ChartFont(graphFont.getGraphFontTypeface(), graphFont.getGraphFontSize(), (graphFont.getGraphFontStyle() & 2) != 0, (graphFont.getGraphFontStyle() & 1) != 0, (graphFont.getGraphFontStyle() & 4) != 0, graphFont.getGraphFontColor());
        return chartFont;
    }

    @Override
    Class primitiveClass() {
        return ChartFont.class;
    }

    static enum Members {
        NAME,
        SIZE,
        WEIGHT,
        POSTURE,
        UNDERLINE,
        COLOR;

    }
}

