/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.chart;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.display.DisplayPanel;
import oracle.dbtools.raptor.controls.display.IPanelManagerContext;
import oracle.dbtools.raptor.controls.display.chart.ChartArb;
import oracle.dbtools.raptor.controls.display.chart.ChartPropertyManager;
import oracle.dbtools.raptor.controls.display.chart.GraphPreviewPanel;
import oracle.dbtools.raptor.controls.display.chart.PropertyEditorPanel;
import oracle.dss.graph.Graph;

public class ChartEditorPanel
extends JPanel {
    private Graph graph;
    private GraphPreviewPanel graphPreview;
    private DisplayPanel liveDataPanel;
    private PropertyEditorPanel propertyEditor;
    private JSplitPane splitPane;
    private ChartPropertyManager propertyManager;
    private IPanelManagerContext context;

    public ChartEditorPanel(ChartPropertyManager chartPropertyManager, IPanelManagerContext iPanelManagerContext) {
        super(new GridLayout(1, 1));
        this.propertyManager = chartPropertyManager;
        this.context = iPanelManagerContext;
        this.initUI();
    }

    private void initUI() {
        this.graph = this.propertyManager.createGraph();
        this.propertyManager.bindGraph(this.graph);
        this.graphPreview = new GraphPreviewPanel(this.graph);
        this.propertyEditor = new PropertyEditorPanel(this);
        JScrollPane jScrollPane = new JScrollPane(this.propertyEditor);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        Dimension dimension = new Dimension(50, 50);
        this.graphPreview.setMinimumSize(dimension);
        jScrollPane.setMinimumSize(dimension);
        this.splitPane = new JSplitPane(1, jScrollPane, this.graphPreview);
        this.splitPane.setOneTouchExpandable(true);
        this.add(this.splitPane);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ChartEditorPanel.this.splitPane.setDividerLocation(0.5);
            }
        });
    }

    ChartPropertyManager propertyManager() {
        return this.propertyManager;
    }

    void retrieveAllSQLColumnNames(PropertyChangeListener propertyChangeListener) {
        this.context.retrieveAllSQLColumnNames(propertyChangeListener);
    }

    void enableLiveData(boolean bl) {
        if (bl) {
            RaptorTask<Void> raptorTask = new RaptorTask<Void>(ChartArb.getString("QUERYING_LIVE_DATA"), true, IRaptorTaskRunMode.MODAL){

                protected Void doWork() throws TaskException {
                    if (ChartEditorPanel.this.liveDataPanel == null) {
                        ChartEditorPanel.this.liveDataPanel = ChartEditorPanel.this.context.getLiveDisplayPanel(ChartEditorPanel.this.propertyManager);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (ChartEditorPanel.this.liveDataPanel != null) {
                                ChartEditorPanel.this.splitPane.setRightComponent(ChartEditorPanel.this.liveDataPanel);
                            } else {
                                ChartEditorPanel.this.propertyEditor.clearLiveDataCheck();
                            }
                        }
                    });
                    return null;
                }
            };
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        } else {
            if (this.liveDataPanel != null) {
                this.liveDataPanel.close();
                this.liveDataPanel = null;
            }
            this.splitPane.setRightComponent(this.graphPreview);
        }
    }

    void reloadLiveData() {
        if (this.liveDataPanel != null) {
            RaptorTask<Void> raptorTask = new RaptorTask<Void>(ChartArb.getString("QUERYING_LIVE_DATA"), true, IRaptorTaskRunMode.NO_GUI){

                protected Void doWork() throws TaskException {
                    DisplayPanel displayPanel;
                    if (ChartEditorPanel.this.liveDataPanel != null && (displayPanel = ChartEditorPanel.this.context.getLiveDisplayPanel(ChartEditorPanel.this.propertyManager)) != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ChartEditorPanel.this.liveDataPanel.close();
                                ChartEditorPanel.this.liveDataPanel = displayPanel;
                                ChartEditorPanel.this.splitPane.setRightComponent(ChartEditorPanel.this.liveDataPanel);
                            }
                        });
                    }
                    return null;
                }
            };
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        }
    }

    public List<String> getSubPanels() {
        return this.propertyEditor.getSubPanels();
    }

    public String getSubPanelLabel(String string) {
        return this.propertyEditor.getSubPanelLabel(string);
    }

    public void setSelectedSubPanel(String string) {
        this.propertyEditor.setSelectedSubPanel(string);
    }
}

