/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.Ide;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.checkboxlist.CheckBoxList;
import oracle.ide.controls.checkboxlist.CheckBoxListCellData;
import oracle.ide.controls.checkboxlist.CheckBoxListItemStateListener;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.help.HelpSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.ui.Colors;

public class SelectListPanel
implements CheckBoxListItemStateListener,
ActionListener {
    static final String DEFAULT_HELP_TOPIC = "f1_idedsavefiles_html";
    private boolean m_checkedList;
    private String m_prompt;
    private String m_description;
    private CheckBoxListModel m_listModel;
    private String m_helpID = "f1_idedsavefiles_html";
    private JPanel m_content;
    private JButton m_btnSelectAll;
    private JButton m_btnSelectNone;
    private CheckBoxList m_lstItems;
    private boolean m_isListUpdating;
    public static final int DLG_MAX_WIDTH = 800;
    public static final int DLG_MAX_HEIGHT = 600;
    public static final int DLG_MIN_WIDTH = 400;
    public static final int DLG_MIN_HEIGHT = 300;

    public void setListModel(CheckBoxListModel checkBoxListModel) {
        this.m_listModel = checkBoxListModel;
    }

    public CheckBoxListModel getListModel() {
        return this.m_listModel;
    }

    public void setPrompt(String string) {
        this.m_prompt = string;
    }

    public void setDescription(String string) {
        this.m_description = string;
    }

    public void setCheckedList(boolean bl) {
        this.m_checkedList = bl;
    }

    public void setHelpID(String string) {
        this.m_helpID = string;
    }

    private JPanel getContent() {
        if (this.m_content == null) {
            Object object;
            int n;
            this.m_content = new JPanel(new GridBagLayout());
            this.m_listModel.sort();
            this.m_lstItems = new CheckBoxList(this.m_listModel);
            if (this.m_listModel.getSize() > 0) {
                this.m_lstItems.setSelectedIndex(0);
                this.m_listModel.addCheckBoxStateListener((CheckBoxListItemStateListener)this);
            }
            if (this.m_checkedList) {
                this.m_btnSelectAll = new JButton();
                this.m_btnSelectNone = new JButton();
                ResourceUtils.resButton((AbstractButton)this.m_btnSelectAll, (String)IdeArb.getString((int)212));
                this.m_btnSelectAll.setDefaultCapable(false);
                this.m_btnSelectAll.addActionListener(this);
                this.m_btnSelectAll.setEnabled(false);
                for (n = 0; n < this.m_listModel.getSize(); ++n) {
                    if (this.m_listModel.isElementSelected(n)) continue;
                    this.m_btnSelectAll.setEnabled(true);
                    break;
                }
                ResourceUtils.resButton((AbstractButton)this.m_btnSelectNone, (String)IdeArb.getString((int)214));
                this.m_btnSelectNone.setDefaultCapable(false);
                this.m_btnSelectNone.addActionListener(this);
                this.m_btnSelectNone.setEnabled(this.selectNoneEnabled());
            }
            n = 0;
            LayoutControl.GBC.Inset inset = LayoutControl.GBC.Inset.FIRST_LINE_START_COMP;
            if (ModelUtil.hasLength((String)this.m_description)) {
                object = new JMultiLineLabel(this.m_description);
                object.setForeground(Colors.HINT_TEXT);
                object.setVisible(true);
                this.m_content.add((Component)object, LayoutControl.GBC.gbc(0, n++, 1, 1, inset, LayoutControl.GBC.Fill.XY));
                inset = LayoutControl.GBC.Inset.SECTION_LINE_START_COMP;
            }
            if (ModelUtil.hasLength((String)this.m_prompt)) {
                object = new JLabel();
                ResourceUtils.resLabel((JLabel)object, (Component)this.m_lstItems, (String)this.m_prompt);
                this.m_content.add((Component)object, LayoutControl.GBC.gbc(0, n++, 1, 1, inset));
                inset = LayoutControl.GBC.Inset.LINE_START_COMP;
            }
            object = new JScrollPane((Component)this.m_lstItems);
            this.m_content.add((Component)object, LayoutControl.GBC.gbc(0, n++, 1, 1, inset, LayoutControl.GBC.Fill.XY, LayoutControl.GBC.Spring.XY));
            if (this.m_checkedList) {
                JPanel jPanel = new JPanel(new GridLayout(1, 2, 8, 0));
                jPanel.add(this.m_btnSelectAll);
                jPanel.add(this.m_btnSelectNone);
                this.m_content.add((Component)jPanel, LayoutControl.GBC.gbc(0, n, 1, 1, inset, LayoutControl.GBC.Fill.NONE, LayoutControl.GBC.Spring.NONE, LayoutControl.GBC.Anchor.LINE_END));
            } else {
                this.m_listModel.setCheckBoxVisible(false, true);
            }
        }
        return this.m_content;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.m_isListUpdating = true;
        Object object = actionEvent.getSource();
        if (object == this.m_btnSelectAll) {
            this.m_btnSelectAll.setEnabled(false);
            this.m_btnSelectNone.setEnabled(true);
            this.m_listModel.selectAll();
        } else if (object == this.m_btnSelectNone) {
            this.m_btnSelectNone.setEnabled(false);
            this.m_btnSelectAll.setEnabled(true);
            this.m_listModel.deselectAll();
        }
        this.m_isListUpdating = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean showDialog(Component component, String string) {
        JPanel jPanel = this.getContent();
        if (this.m_helpID != null) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, this.m_helpID);
        }
        JEWTDialog jEWTDialog = SelectListPanel.newDialog(component, string, jPanel, 3);
        jEWTDialog.setDefaultButton(1);
        try {
            boolean bl = jEWTDialog.runDialog();
            return bl;
        }
        finally {
            jEWTDialog.dispose();
        }
    }

    private static JEWTDialog newDialog(Component component, String string, Component component2, int n) {
        JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)(component != null ? component : Ide.getMainWindow()), (String)string, (int)(n | 4));
        jEWTDialog.setMinimumSize(400, 300);
        jEWTDialog.setMaximumInitialSize(800, 600);
        jEWTDialog.setContent(component2);
        jEWTDialog.setResizable(true);
        return jEWTDialog;
    }

    private boolean selectNoneEnabled() {
        CheckBoxListModel checkBoxListModel = (CheckBoxListModel)this.m_lstItems.getModel();
        List list = checkBoxListModel.getSelectionList();
        return list != null && list.size() > 0;
    }

    public void stateChanged(Object object) {
        if (this.m_btnSelectAll == null || this.m_btnSelectNone == null) {
            return;
        }
        if (!this.m_isListUpdating) {
            this.updatedOtherElementsInSameGroup(object, this.m_listModel);
            List list = this.m_listModel.getSelectionList();
            int n = this.m_listModel.getSize();
            int n2 = list != null ? list.size() : 0;
            this.m_btnSelectAll.setEnabled(n2 < n);
            this.m_btnSelectNone.setEnabled(n2 > 0);
        }
    }

    private void updatedOtherElementsInSameGroup(Object object, CheckBoxListModel checkBoxListModel) {
        if (!(object instanceof CheckBoxListCellData)) {
            return;
        }
        int n = checkBoxListModel.getSize();
        CheckBoxListCellData checkBoxListCellData = (CheckBoxListCellData)object;
        Object object2 = checkBoxListCellData.getGroupId();
        if (object2 != null) {
            TriStateBoolean triStateBoolean = checkBoxListCellData.getCheckBoxState();
            for (int i = 0; i < n; ++i) {
                CheckBoxListCellData checkBoxListCellData2 = (CheckBoxListCellData)checkBoxListModel.getElementAt(i);
                if (checkBoxListCellData2 == checkBoxListCellData || !object2.equals(checkBoxListCellData2.getGroupId())) continue;
                checkBoxListCellData2.setCheckBoxStateWithoutFiring(triStateBoolean);
            }
        }
    }
}

