/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections.impexp;

import oracle.dbtools.raptor.connections.impexp.ImpExpEngine;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;

public final class ImpExpController
implements Controller {
    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == ImpExpEngine.IMPORT_CMD_ID) {
            DatabaseConnections databaseConnections = ImpExpController.getStore(context);
            if (databaseConnections != null) {
                ImpExpEngine impExpEngine = ImpExpEngine.createImportEngine(databaseConnections);
                impExpEngine.invoke();
            }
            return true;
        }
        if (n == ImpExpEngine.EXPORT_CMD_ID) {
            DatabaseConnections databaseConnections = ImpExpController.getStore(context);
            if (databaseConnections != null) {
                ImpExpEngine impExpEngine = ImpExpEngine.createExportEngine(databaseConnections);
                impExpEngine.invoke();
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == ImpExpEngine.IMPORT_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        if (n == ImpExpEngine.EXPORT_CMD_ID) {
            boolean bl = false;
            DatabaseConnections databaseConnections = ImpExpController.getStore(context);
            if (databaseConnections != null && databaseConnections.listConnections().size() > 0) {
                bl = true;
            }
            ideAction.setEnabled(bl);
            return true;
        }
        return false;
    }

    private static DatabaseConnections getStore(Context context) {
        DatabaseConnections databaseConnections = null;
        Element[] elementArray = context.getSelection();
        if (elementArray.length == 1) {
            databaseConnections = DatabaseConnectionStores.getInstance().getStore("IdeConnections");
        }
        return databaseConnections;
    }
}

