/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections.impexp;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.dbtools.raptor.connections.impexp.ImpExpEngine;
import oracle.dbtools.raptor.connections.impexp.ImpExpFile;
import oracle.dbtools.raptor.connections.impexp.ImpExpPanel;
import oracle.dbtools.raptor.connections.impexp.ImpExpResources;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

class ExportPasswordPanel
extends ImpExpPanel {
    private JRadioButton m_btnKey;
    private JRadioButton m_btnStrip;
    private JPasswordField m_fldKey;
    private JPasswordField m_fldVerifyKey;

    ExportPasswordPanel() {
    }

    @Override
    protected JPanel createContentPanel() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        JMultiLineLabel jMultiLineLabel = new JMultiLineLabel();
        jMultiLineLabel.setText(ImpExpResources.getString("BOILERPLATE_PASSWORDS_EXPORT"));
        jPanel.add((Component)jMultiLineLabel, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, LayoutControl.GBC.Fill.XY));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.m_btnKey = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.m_btnKey, (String)ImpExpResources.getString("OPTION_ENCRYPT_PASSWORDS"));
        this.m_btnKey.setSelected(true);
        buttonGroup.add(this.m_btnKey);
        jPanel.add((Component)this.m_btnKey, LayoutControl.GBC.gbc(0, 1, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        JPanel jPanel2 = LayoutControl.GBC.createPanel();
        this.m_fldKey = new JPasswordField();
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_fldKey, (String)ImpExpResources.getString("LABEL_KEY"));
        jPanel2.add((Component)jLabel, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        jPanel2.add((Component)this.m_fldKey, LayoutControl.GBC.gbc(1, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        this.m_fldVerifyKey = new JPasswordField();
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_fldVerifyKey, (String)ImpExpResources.getString("LABEL_VERIFY_KEY"));
        jPanel2.add((Component)jLabel, LayoutControl.GBC.gbc(0, 1, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel2.add((Component)this.m_fldVerifyKey, LayoutControl.GBC.gbc(1, 1, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        jPanel.add((Component)LayoutControl.GBC.createSubPanel(jPanel2), LayoutControl.GBC.gbc(0, 2, 1, 1, LayoutControl.GBC.Inset.NONE, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        this.m_btnStrip = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.m_btnStrip, (String)ImpExpResources.getString("OPTION_STRIP_PASSWORDS"));
        buttonGroup.add(this.m_btnStrip);
        jPanel.add((Component)this.m_btnStrip, LayoutControl.GBC.gbc(0, 3, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        return jPanel;
    }

    @Override
    public String getHelpID() {
        return "f1_idedexportcxn_html";
    }

    @Override
    protected void init(final TraversableContext traversableContext) {
        ImpExpFile impExpFile;
        ImpExpEngine.PasswordMode passwordMode;
        PasswordListener passwordListener = (PasswordListener)traversableContext.get("ImportExport.PASSWORD_LISTENER");
        if (passwordListener == null) {
            passwordListener = new PasswordListener(){

                @Override
                public TraversableContext getTraversableContext() {
                    return traversableContext;
                }
            };
            traversableContext.put("ImportExport.PASSWORD_LISTENER", (Object)passwordListener);
        }
        if ((passwordMode = (impExpFile = (ImpExpFile)traversableContext.get("ImportExport.DESTINATION")).getMode()) == ImpExpEngine.PasswordMode.KEY) {
            this.m_btnKey.setSelected(true);
            String string = impExpFile.getKey();
            if (string != null) {
                this.m_fldKey.setText(string);
                this.m_fldVerifyKey.setText(string);
            }
        } else {
            this.m_btnStrip.setSelected(true);
        }
        this.m_btnKey.addItemListener(passwordListener);
        this.m_fldKey.getDocument().addDocumentListener(passwordListener);
        this.updateButtonStates(traversableContext);
    }

    @Override
    protected void commit(TraversableContext traversableContext) throws TraversalException {
        PasswordListener passwordListener = (PasswordListener)traversableContext.get("ImportExport.PASSWORD_LISTENER");
        if (passwordListener != null) {
            this.m_btnKey.removeItemListener(passwordListener);
            this.m_fldKey.getDocument().removeDocumentListener(passwordListener);
        }
        ImpExpFile impExpFile = (ImpExpFile)traversableContext.get("ImportExport.DESTINATION");
        if (this.m_btnStrip.isSelected()) {
            impExpFile.setMode(ImpExpEngine.PasswordMode.STRIP);
        } else {
            char[] cArray = this.m_fldKey.getPassword();
            char[] cArray2 = this.m_fldVerifyKey.getPassword();
            if (cArray.length == 0) {
                throw new TraversalException(ImpExpResources.getString("ERROR_MISSING_KEY"), ImpExpResources.getString("TITLE_INVALID_KEY"));
            }
            if (!Arrays.equals(cArray, cArray2)) {
                throw new TraversalException(ImpExpResources.getString("ERROR_KEYS_DONT_MATCH"), ImpExpResources.getString("TITLE_INVALID_KEY"));
            }
            impExpFile.setMode(ImpExpEngine.PasswordMode.KEY);
            impExpFile.setKey(new String(cArray));
        }
        traversableContext.put("ImportExport.DESTINATION", (Object)impExpFile);
    }

    @Override
    protected Boolean getBackButtonState(TraversableContext traversableContext) {
        return null;
    }

    @Override
    protected Boolean getNextButtonState(TraversableContext traversableContext) {
        if (this.m_btnKey.isSelected()) {
            char[] cArray = this.m_fldKey.getPassword();
            return cArray != null && cArray.length > 0;
        }
        return Boolean.TRUE;
    }

    @Override
    protected Boolean getFinishButtonState(TraversableContext traversableContext) {
        return this.getNextButtonState(traversableContext);
    }

    private abstract class PasswordListener
    implements ItemListener,
    DocumentListener {
        private PasswordListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (ExportPasswordPanel.this.m_btnKey.isSelected()) {
                ExportPasswordPanel.this.m_fldKey.setEnabled(true);
                ExportPasswordPanel.this.m_fldVerifyKey.setEnabled(true);
            } else {
                ExportPasswordPanel.this.m_fldKey.setEnabled(false);
                ExportPasswordPanel.this.m_fldVerifyKey.setEnabled(false);
            }
            ExportPasswordPanel.this.updateButtonStates(this.getTraversableContext());
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            ExportPasswordPanel.this.updateButtonStates(this.getTraversableContext());
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            ExportPasswordPanel.this.updateButtonStates(this.getTraversableContext());
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            ExportPasswordPanel.this.updateButtonStates(this.getTraversableContext());
        }

        public abstract TraversableContext getTraversableContext();
    }
}

