/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.ide.extension.ElementName;
import javax.ide.util.MetaClass;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.connections.AdvancedPanel;
import oracle.dbtools.raptor.connections.BasicPanel;
import oracle.dbtools.raptor.connections.BequeathConnectionPanel;
import oracle.dbtools.raptor.connections.LDAPConnectionPanel;
import oracle.dbtools.raptor.connections.OracleConnectionProcessor;
import oracle.dbtools.raptor.connections.OracleConnectionTypePanel;
import oracle.dbtools.raptor.connections.TNSPanel;
import oracle.dbtools.util.Logger;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.javatools.data.HashStructure;

public final class OracleConnectionType
implements Comparable<OracleConnectionType> {
    private static final String NS = "http://xmlns.oracle.com/sqldeveloper/sqldev-connections";
    private static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/sqldeveloper/sqldev-connections", "sqldev-connections-hook");
    private static final String TYPE_ELEMENT = "oracleConnectionType";
    private static final String NAME_ATTRIBUTE = "type";
    private static final String LABEL_ATTRIBUTE = "label";
    private static final String PANEL_ATTRIBUTE = "panelClass";
    private static final String PROCESSOR_ATTRIBUTE = "processorClass";
    private static final String WEIGHT_ATTRIBUTE = "weight";
    private static Map<String, OracleConnectionType> sTypes = new LinkedHashMap<String, OracleConnectionType>();
    private static Listener listener;
    private static Object TYPE_LOCK;
    public static final OracleConnectionType BASIC;
    public static final OracleConnectionType TNS;
    public static final OracleConnectionType LDAP;
    public static final OracleConnectionType ADVANCED;
    public static final OracleConnectionType BEQUEATH;
    private final String mName;
    private final String mLabel;
    private final MetaClass<? extends OracleConnectionTypePanel> clsPanel;
    private final MetaClass<? extends OracleConnectionProcessor> clsProcessor;
    private final double mWeight;

    public static Builder builder(String string) {
        return new Builder(string);
    }

    private static void attachListener() {
        HashStructureHook hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(ELEMENT_NAME);
        if (hashStructureHook != null) {
            listener = new Listener();
            hashStructureHook.addHashStructureHookListener((HashStructureHookListener)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerType(OracleConnectionType oracleConnectionType) {
        Object object = TYPE_LOCK;
        synchronized (object) {
            if (sTypes.containsKey(oracleConnectionType.mName)) {
                throw new IllegalStateException("OracleConnectionType already exists: " + oracleConnectionType.mName);
            }
            sTypes.put(oracleConnectionType.mName, oracleConnectionType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OracleConnectionType lookup(String string) {
        OracleConnectionType oracleConnectionType = null;
        Object object = TYPE_LOCK;
        synchronized (object) {
            oracleConnectionType = sTypes.get(string);
        }
        return oracleConnectionType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<OracleConnectionType> types() {
        TreeSet<OracleConnectionType> treeSet = new TreeSet<OracleConnectionType>();
        Object object = TYPE_LOCK;
        synchronized (object) {
            treeSet.addAll(sTypes.values());
        }
        return treeSet;
    }

    public static OracleConnectionType findType(String string) {
        OracleConnectionType oracleConnectionType = OracleConnectionType.lookup(string);
        if (oracleConnectionType == null) {
            throw new IllegalArgumentException("Unknown type: " + string);
        }
        return oracleConnectionType;
    }

    public static Collection<OracleConnectionTypePanel> getConnectionPanels() {
        if (listener == null) {
            OracleConnectionType.attachListener();
        }
        ArrayList<OracleConnectionTypePanel> arrayList = new ArrayList<OracleConnectionTypePanel>();
        Set<OracleConnectionType> set = OracleConnectionType.types();
        for (OracleConnectionType oracleConnectionType : set) {
            OracleConnectionTypePanel oracleConnectionTypePanel = oracleConnectionType.getPanel();
            if (oracleConnectionTypePanel == null) continue;
            arrayList.add(oracleConnectionTypePanel);
        }
        return arrayList;
    }

    public static OracleConnectionProcessor getConnectionProcessor(String string) {
        OracleConnectionProcessor oracleConnectionProcessor;
        if (listener == null) {
            OracleConnectionType.attachListener();
        }
        OracleConnectionProcessor oracleConnectionProcessor2 = OracleConnectionProcessor.NULL_PROCESSOR;
        OracleConnectionType oracleConnectionType = OracleConnectionType.lookup(string);
        if (oracleConnectionType != null && (oracleConnectionProcessor = oracleConnectionType.getProcessor()) != null) {
            oracleConnectionProcessor2 = oracleConnectionProcessor;
        }
        return oracleConnectionProcessor2;
    }

    public static Collection<OracleConnectionProcessor> getConnectionProcessors() {
        if (listener == null) {
            OracleConnectionType.attachListener();
        }
        ArrayList<OracleConnectionProcessor> arrayList = new ArrayList<OracleConnectionProcessor>();
        for (OracleConnectionType oracleConnectionType : OracleConnectionType.types()) {
            OracleConnectionProcessor oracleConnectionProcessor = oracleConnectionType.getProcessor();
            if (oracleConnectionProcessor == null) continue;
            arrayList.add(oracleConnectionProcessor);
        }
        return arrayList;
    }

    private OracleConnectionType(String string, String string2, double d, MetaClass<? extends OracleConnectionTypePanel> metaClass, MetaClass<? extends OracleConnectionProcessor> metaClass2) {
        this.mName = string;
        this.mLabel = string2 != null ? string2 : string;
        this.clsPanel = metaClass;
        this.clsProcessor = metaClass2;
        this.mWeight = d;
    }

    public String name() {
        return this.mName;
    }

    public String toString() {
        return this.mLabel;
    }

    public OracleConnectionTypePanel getPanel() {
        OracleConnectionTypePanel oracleConnectionTypePanel = null;
        if (this.clsPanel != null) {
            try {
                oracleConnectionTypePanel = (OracleConnectionTypePanel)this.clsPanel.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
        }
        return oracleConnectionTypePanel;
    }

    public OracleConnectionProcessor getProcessor() {
        OracleConnectionProcessor oracleConnectionProcessor = null;
        if (this.clsProcessor != null) {
            try {
                oracleConnectionProcessor = (OracleConnectionProcessor)this.clsProcessor.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
        }
        return oracleConnectionProcessor;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.mName == null ? 0 : this.mName.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        OracleConnectionType oracleConnectionType = (OracleConnectionType)object;
        return !(this.mName == null ? oracleConnectionType.mName != null : !this.mName.equals(oracleConnectionType.mName));
    }

    @Override
    public int compareTo(OracleConnectionType oracleConnectionType) {
        return this.mWeight == oracleConnectionType.mWeight ? this.mName.compareTo(oracleConnectionType.mName) : (this.mWeight < oracleConnectionType.mWeight ? -1 : 1);
    }

    static {
        TYPE_LOCK = new Object();
        BASIC = OracleConnectionType.builder("BASIC").label(Messages.getString("OracleConnectionType.0")).panelClass((MetaClass<? extends OracleConnectionTypePanel>)MetaClass.newMetaClass(BasicPanel.class)).weight(1.0).build();
        TNS = OracleConnectionType.builder("TNS").label("TNS").panelClass((MetaClass<? extends OracleConnectionTypePanel>)MetaClass.newMetaClass(TNSPanel.class)).build();
        LDAP = OracleConnectionType.builder("LDAP").label("LDAP").panelClass((MetaClass<? extends OracleConnectionTypePanel>)MetaClass.newMetaClass(LDAPConnectionPanel.class)).build();
        ADVANCED = OracleConnectionType.builder("ADVANCED").label(Messages.getString("OracleConnectionType.3")).panelClass((MetaClass<? extends OracleConnectionTypePanel>)MetaClass.newMetaClass(AdvancedPanel.class)).build();
        BEQUEATH = OracleConnectionType.builder("BEQUEATH").label(Messages.getString("OracleConnectionType.4")).panelClass((MetaClass<? extends OracleConnectionTypePanel>)MetaClass.newMetaClass(BequeathConnectionPanel.class)).build();
    }

    public static final class Builder {
        private String name;
        private String label;
        private MetaClass<? extends OracleConnectionTypePanel> clsPanel;
        private MetaClass<? extends OracleConnectionProcessor> clsProcessor;
        private double weight = 10.0;

        private Builder(String string) {
            this.name = string;
        }

        public Builder label(String string) {
            this.label = string;
            return this;
        }

        public Builder panelClass(MetaClass<? extends OracleConnectionTypePanel> metaClass) {
            this.clsPanel = metaClass;
            return this;
        }

        public Builder processorClass(MetaClass<? extends OracleConnectionProcessor> metaClass) {
            this.clsProcessor = metaClass;
            return this;
        }

        public Builder weight(double d) {
            this.weight = d;
            return this;
        }

        public OracleConnectionType build() {
            OracleConnectionType oracleConnectionType = new OracleConnectionType(this.name, this.label, this.weight, this.clsPanel, this.clsProcessor);
            OracleConnectionType.registerType(oracleConnectionType);
            return oracleConnectionType;
        }
    }

    private static final class Listener
    implements HashStructureHookListener {
        private Listener() {
        }

        public void elementVisited(HashStructureHookEvent hashStructureHookEvent) {
            this.processDescriptors(hashStructureHookEvent.getNewElementHashStructure());
        }

        public void listenerAttached(HashStructureHookEvent hashStructureHookEvent) {
            this.processDescriptors(hashStructureHookEvent.getCombinedHashStructure());
        }

        private void processDescriptors(HashStructure hashStructure) {
            List list = hashStructure.getAsList(OracleConnectionType.TYPE_ELEMENT);
            if (list != null) {
                for (HashStructure hashStructure2 : list) {
                    MetaClass metaClass;
                    LazyClassAdapter lazyClassAdapter;
                    MetaClass metaClass2;
                    String string = hashStructure2.getString(OracleConnectionType.NAME_ATTRIBUTE);
                    if (string == null) continue;
                    Builder builder = OracleConnectionType.builder(string);
                    String string2 = hashStructure2.getString(OracleConnectionType.LABEL_ATTRIBUTE);
                    if (string2 != null) {
                        builder.label(string2);
                    }
                    if ((metaClass2 = (lazyClassAdapter = LazyClassAdapter.getInstance((HashStructure)hashStructure2)).getMetaClass(OracleConnectionType.PANEL_ATTRIBUTE)) != null) {
                        builder.panelClass((MetaClass<? extends OracleConnectionTypePanel>)metaClass2);
                    }
                    if ((metaClass = lazyClassAdapter.getMetaClass(OracleConnectionType.PROCESSOR_ATTRIBUTE)) != null) {
                        builder.processorClass((MetaClass<? extends OracleConnectionProcessor>)metaClass);
                    }
                    try {
                        double d = hashStructure2.getDouble(OracleConnectionType.WEIGHT_ATTRIBUTE);
                        if (d > 0.0) {
                            builder.weight(d);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        Logger.severe(OracleConnectionType.class, (Throwable)numberFormatException);
                    }
                    builder.build();
                }
            }
        }
    }
}

