/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections;

import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.dbtools.raptor.utils.TNSHelper;

public abstract class OracleConnectionProcessor {
    private static final Pattern SERVICE_FORMAT = Pattern.compile("/*([^:]+):([^:]+)/([^:]+)");
    private static final Pattern SID_FORMAT = Pattern.compile("([^:]+):([^:]+):([^:]+)");
    static final OracleConnectionProcessor NULL_PROCESSOR = new OracleConnectionProcessor(){
        private Properties nullProps = new Properties();

        @Override
        public Properties finalizeProperties(Properties properties) {
            return this.nullProps;
        }
    };

    public abstract Properties finalizeProperties(Properties var1);

    public Properties preprocessProperties(Properties properties) {
        String string;
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        String string2 = properties.getProperty("customUrl");
        if (ModelUtil.hasLength((String)string2)) {
            if (!string2.startsWith("jdbc")) {
                string = this.resolveTNSEntry(string2, properties2);
                if (string != null) {
                    String string3 = string.getJDBCUrl();
                    Connections.safePropertySetter(properties2, "customUrl", this.adjustDescriptor(string3, properties));
                    Connections.safePropertySetter(properties2, "hostname", string.getHostname());
                    Connections.safePropertySetter(properties2, "port", string.getPortno());
                    Connections.safePropertySetter(properties2, "sid", string.getSid());
                    Connections.safePropertySetter(properties2, "serviceName", string.getServicename());
                }
            } else {
                int n;
                string = properties2.getProperty("hostname");
                String string4 = properties2.getProperty("sid");
                String string5 = properties2.getProperty("serviceName");
                if ((!ModelUtil.hasLength((String)string) || !ModelUtil.hasLength((String)string4) && !ModelUtil.hasLength((String)string5)) && string2.startsWith("jdbc:oracle:") && (n = string2.indexOf("@")) != -1) {
                    String string6 = string2.substring(n + 1);
                    Matcher matcher = SERVICE_FORMAT.matcher(string6);
                    if (matcher.matches()) {
                        Connections.safePropertySetter(properties2, "hostname", matcher.group(1));
                        Connections.safePropertySetter(properties2, "port", matcher.group(2));
                        Connections.safePropertySetter(properties2, "serviceName", matcher.group(3));
                    } else {
                        matcher = SID_FORMAT.matcher(string6);
                        if (matcher.matches()) {
                            Connections.safePropertySetter(properties2, "hostname", matcher.group(1));
                            Connections.safePropertySetter(properties2, "port", matcher.group(2));
                            Connections.safePropertySetter(properties2, "sid", matcher.group(3));
                        }
                    }
                }
            }
        }
        if ((string = properties2.getProperty("driver")) == null) {
            Connections.safePropertySetter(properties2, "driver", "oracle.jdbc.OracleDriver");
        }
        return properties2;
    }

    protected String adjustDescriptor(String string, Properties properties) {
        return string;
    }

    public boolean shouldEncrypt(String string) {
        return false;
    }

    protected TCPTNSEntry resolveTNSEntry(String string, Properties properties) {
        return TNSHelper.getEntry((String)string);
    }

    public void validateProperties(Properties properties) throws SQLException {
    }
}

