/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.TabbedPaneUI;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.connections.DefaultAuthenticationPanel;
import oracle.dbtools.raptor.connections.ProxyConnectionPanel;
import oracle.dbtools.raptor.controls.NonNullableComboBoxModel;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.controls.tabbedpane.CustomTabbedPaneUI;
import oracle.ide.util.ResourceUtils;

class OracleAuthenticationPanel
extends DefaultAuthenticationPanel {
    private static final String[] ROLES = new String[]{ConnectionDialogArb.getString("CONNECTION_DIALOG_DETAILS_ROLE_DEFAULT"), "SYSDBA", "SYSOPER", "SYSBACKUP", "SYSDG", "SYSKM", "SYSASM"};
    private JComboBox<AuthType> cmbAuth = new JComboBox(new NonNullableComboBoxModel((Object[])AuthType.values()));
    private JComboBox<String> cmbRole = new JComboBox(new NonNullableComboBoxModel((Object[])ROLES));
    private ProxyConnectionPanel pnlProxy = ProxyConnectionPanel.createProxyPanel();

    OracleAuthenticationPanel() {
    }

    @Override
    public void clear() {
        super.clear();
        this.cmbAuth.setSelectedItem((Object)AuthType.DEFAULT);
        this.pnlProxy.clear();
    }

    @Override
    public void setConnectionDetails(Properties properties) {
        super.setConnectionDetails(properties);
        AuthType authType = AuthType.DEFAULT;
        boolean bl = Boolean.parseBoolean(properties.getProperty("OS_AUTHENTICATION"));
        if (bl) {
            authType = AuthType.OS;
        } else {
            boolean bl2 = Boolean.parseBoolean(properties.getProperty("KERBEROS_AUTHENTICATION"));
            if (bl2) {
                authType = AuthType.KERBEROS;
            }
        }
        this.cmbAuth.setSelectedItem((Object)authType);
        String string = properties.getProperty("role");
        if (!ModelUtil.hasLength((String)string)) {
            this.cmbRole.setSelectedIndex(0);
        } else {
            this.cmbRole.setSelectedItem(string);
        }
        this.pnlProxy.setConnectionDetails(properties);
    }

    @Override
    public Properties getConnectionDetails() {
        Properties properties = super.getConnectionDetails();
        AuthType authType = (AuthType)((Object)this.cmbAuth.getSelectedItem());
        if (authType == AuthType.DEFAULT) {
            properties.setProperty("NoPasswordConnection", "TRUE");
        } else {
            properties.setProperty("NoPasswordConnection", "FALSE");
        }
        properties.setProperty("OS_AUTHENTICATION", Boolean.toString(authType == AuthType.OS));
        properties.setProperty("KERBEROS_AUTHENTICATION", Boolean.toString(authType == AuthType.KERBEROS));
        String string = (String)this.cmbRole.getSelectedItem();
        properties.setProperty("role", string.equals(ROLES[0]) ? "" : string);
        properties.putAll((Map<?, ?>)this.pnlProxy.getConnectionDetails());
        return properties;
    }

    @Override
    public void initializeToDefaults() {
        super.initializeToDefaults();
        this.cmbAuth.setSelectedItem((Object)AuthType.DEFAULT);
        this.cmbRole.setSelectedIndex(0);
        this.pnlProxy.initializeToDefaults();
    }

    @Override
    public String getUsername() {
        return super.getUsername();
    }

    @Override
    public String getPassword() {
        return super.getPassword();
    }

    @Override
    protected JComponent createUI() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setUI((TabbedPaneUI)new CustomTabbedPaneUI());
        JPanel jPanel = LayoutControl.GBC.createPanel();
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, this.cmbAuth, (String)ConnectionDialogArb.getString("AUTHENTICATION_TYPE"));
        this.cmbAuth.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                this.enableCredentials(itemEvent.getItem() != AuthType.OS);
            }
        });
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        jPanel.add(this.cmbAuth, LayoutControl.GBC.gbc(1, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP));
        jPanel.add(Box.createGlue(), LayoutControl.GBC.gbc(4, 0, 1, 1, LayoutControl.GBC.Inset.NONE, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        JComponent jComponent = super.createUI();
        GridBagConstraints gridBagConstraints = ((GridBagLayout)jComponent.getLayout()).getConstraints(this.tfdUser);
        int n = gridBagConstraints.gridx + 1;
        int n2 = gridBagConstraints.gridy;
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, this.cmbRole, (String)ConnectionDialogArb.getString("CONNECTION_DIALOG_DETAILS_ROLE"));
        jComponent.add((Component)jLabel, LayoutControl.GBC.gbc(n++, n2, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2CONTROL_COMP));
        jComponent.add(this.cmbRole, LayoutControl.GBC.gbc(n, n2, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.NONE));
        jPanel.add((Component)jComponent, LayoutControl.GBC.gbc(0, 1, 5, 1, LayoutControl.GBC.Inset.LINE_START_COMP, LayoutControl.GBC.Fill.XY, LayoutControl.GBC.Spring.X));
        this.cmbAuth.setSelectedItem((Object)AuthType.DEFAULT);
        jTabbedPane.addTab(ConnectionDialogArb.getString("TAB_AUTHENTICATION"), LayoutControl.GBC.createTabPanel(jPanel));
        jTabbedPane.addTab(ConnectionDialogArb.getString("PROXY_TAB_NAME"), LayoutControl.GBC.createTabPanel(this.pnlProxy.getUI()));
        return jTabbedPane;
    }

    private void enableCredentials(boolean bl) {
        this.tfdUser.setEnabled(bl);
        this.tfdPassword.setEnabled(bl);
        this.chkSavePassword.setEnabled(bl);
    }

    private static enum AuthType {
        DEFAULT(ConnectionDialogArb.getString("AUTHENTICATION_TYPE_DEFAULT")),
        OS(ConnectionDialogArb.getString("AUTHENTICATION_TYPE_OS")),
        KERBEROS(ConnectionDialogArb.getString("AUTHENTICATION_TYUPE_KERBEROS"));

        private final String label;

        private AuthType(String string2) {
            this.label = string2;
        }

        public String toString() {
            return this.label;
        }
    }
}

