/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config.homesupport;

import java.net.URL;
import oracle.dbtools.raptor.startup.OracleHomeType;
import oracle.dbtools.raptor.utils.RaptorHashStructureAdapter;
import oracle.ide.config.Preferences;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.PlatformUtils;

public class OracleHomeSettings
extends RaptorHashStructureAdapter {
    private static final String DATA_KEY = "OracleHomeSettings";
    private static final String ROOT_KEY = "HomeRoot";
    private static final String USE_CLIENT_KEY = "UseClient";
    private static final String HOME_KEY = "OracleClient";
    private static final String HOME_LOC_KEY = "HomeLocation";
    private static final String HOME_TYPE_KEY = "HomeType";

    public static OracleHomeSettings getInstance(PropertyStorage propertyStorage) {
        return new OracleHomeSettings(OracleHomeSettings.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
    }

    public static OracleHomeSettings createSettings(TraversableContext traversableContext) {
        return OracleHomeSettings.getInstance(traversableContext.getPropertyStorage());
    }

    public static OracleHomeSettings getInstance() {
        return OracleHomeSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    private OracleHomeSettings(HashStructure hashStructure) {
        super(hashStructure);
    }

    protected String getRootKey() {
        return ROOT_KEY;
    }

    public boolean isUseOracleClient() {
        HashStructure hashStructure = this.getRootHash();
        return hashStructure.getBoolean(USE_CLIENT_KEY);
    }

    public void setUseOracleClient(boolean bl) {
        HashStructure hashStructure = this.getRootHash();
        hashStructure.putBoolean(USE_CLIENT_KEY, bl);
    }

    public OracleHome getHome() {
        HashStructure hashStructure = this.getRootHash();
        return this.createHome(hashStructure.getOrCreateHashStructure(HOME_KEY));
    }

    public void setHome(OracleHome oracleHome) {
        HashStructure hashStructure = this.getRootHash();
        if (oracleHome == null) {
            hashStructure.remove(HOME_KEY);
        } else {
            HashStructure hashStructure2 = HashStructure.newInstance();
            hashStructure2.putURL(HOME_LOC_KEY, oracleHome.getLocation());
            hashStructure2.putString(HOME_TYPE_KEY, oracleHome.getType().name());
            hashStructure.putHashStructure(HOME_KEY, hashStructure2);
        }
    }

    private OracleHome createHome(HashStructure hashStructure) {
        OracleHomeType oracleHomeType;
        OracleHome oracleHome = null;
        URL uRL = hashStructure.getURL(HOME_LOC_KEY);
        if (uRL != null && (oracleHomeType = OracleHomeType.valueOf((String)hashStructure.getString(HOME_TYPE_KEY))) != null) {
            oracleHome = new OracleHome(uRL, oracleHomeType);
        }
        return oracleHome;
    }

    public static final class OracleHome {
        private OracleHomeType m_type;
        private URL m_location;

        public OracleHome(URL uRL, OracleHomeType oracleHomeType) {
            this.m_location = uRL;
            this.m_type = oracleHomeType;
        }

        public OracleHomeType getType() {
            return this.m_type;
        }

        public URL getLocation() {
            return this.m_location;
        }

        public void setType(OracleHomeType oracleHomeType) {
            this.m_type = oracleHomeType;
        }

        public void setLocation(URL uRL) {
            this.m_location = uRL;
        }

        public URL getBinDirectory() {
            if (this.m_type == null || this.m_location == null) {
                return null;
            }
            if (this.m_type == OracleHomeType.INSTANT_CLIENT) {
                return this.m_location;
            }
            return URLFactory.newDirURL((URL)this.m_location, (String)(PlatformUtils.isWindows() ? "bin" : "lib"));
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.m_type != null ? this.m_type.toString() : null);
            stringBuilder.append(": ");
            stringBuilder.append(this.m_location != null ? URLFileSystem.toDisplayString((URL)this.m_location) : null);
            return stringBuilder.toString();
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof OracleHome) {
                OracleHome oracleHome = (OracleHome)object;
                return this.m_type == oracleHome.m_type && ModelUtil.areEqual((Object)this.m_location, (Object)((OracleHome)object).m_location);
            }
            return false;
        }
    }
}

