/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.FileField;

public final class SQLPlusFileChooser
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private JLabel lblSqlPlusPath = new JLabel();
    private JTextField tfSqlPlusPath = new FileField();
    private JButton btnBrowse = new JButton();
    private GridBagLayout layMain = new GridBagLayout();

    public SQLPlusFileChooser() {
        try {
            this.jbInit();
            this.setHelpID("f1_defaultsqlplusdir_html");
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        Object object = dBConfig.getString("DEFAULTPATH");
        String string = dBConfig.getString("SQL_PATH_OVERRIDE");
        if (string != null && !string.equals("")) {
            object = object == null || ((String)object).equals("") ? string : (String)object + File.pathSeparator + string;
        }
        this.tfSqlPlusPath.setText((String)object);
    }

    public void onExit(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putString("DEFAULTPATH", this.tfSqlPlusPath.getText());
        dBConfig.putString("SQL_PATH_OVERRIDE", "");
    }

    public JTextField getPathField() {
        return this.tfSqlPlusPath;
    }

    private void jbInit() throws Exception {
        String string = PreferencesArb.getString("SQLPLUS_HINT_TEXT");
        this.setToolTipText(string);
        this.tfSqlPlusPath.setToolTipText(string);
        this.lblSqlPlusPath.setToolTipText(string);
        string = PreferencesArb.getString("SQLPLUS_EXECUTABLE");
        ResourceUtils.resLabel((JLabel)this.lblSqlPlusPath, (Component)this.tfSqlPlusPath, (String)string);
        string = StringUtils.stripMnemonic((String)PreferencesArb.getString("SQLPLUS_BROWSE_TEXT"));
        ResourceUtils.resButton((AbstractButton)this.btnBrowse, (String)string);
        this.btnBrowse.setMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("SQLPLUS_BROWSE_TEXT")));
        this.btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SQLPlusFileChooser.this.btnBrowse_actionPerformed(actionEvent);
            }
        });
        this.setLayout(this.layMain);
        this.add(this.btnBrowse, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.add(this.tfSqlPlusPath, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.add(this.lblSqlPlusPath, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    void btnBrowse_actionPerformed(ActionEvent actionEvent) {
        File file;
        File file2 = DBConfig.getInstance().getString("DEFAULTPATH") == null ? new File(Ide.getTrueUserHomeDirectory()) : new File(DBConfig.getInstance().getString("DEFAULTPATH"));
        URLFileChooser uRLFileChooser = new URLFileChooser(file2);
        uRLFileChooser.setSelectionScope(1);
        int n = uRLFileChooser.showOpenDialog((Component)((Object)this), Messages.getString("SQLPlusFileChooser.1"));
        if (n == 0 && (file = uRLFileChooser.getSelectedFile()) != null) {
            this.tfSqlPlusPath.setText(file.toString());
        }
    }
}

