/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.DataEditorOptionPanel;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class ObjectViewerInfo
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox autoPin = new JCheckBox();
    private JCheckBox m_singleClick = new JCheckBox();
    private DataEditorOptionPanel dataEditorOptionPanel = new DataEditorOptionPanel();

    public ObjectViewerInfo() {
        this.setHelpID("f1_objectviewerinfo_html");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        this.autoPin.setSelected(dBConfig.getBoolean("AUTOPIN"));
        this.dataEditorOptionPanel.setFromPreferences(dBConfig);
        this.m_singleClick.setSelected(dBConfig.getBoolean("OPEN_ON_SINGLE_CLICK"));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putBoolean("AUTOPIN", this.autoPin.isSelected());
        dBConfig.putBoolean("OPEN_ON_SINGLE_CLICK", this.m_singleClick.isSelected());
        this.dataEditorOptionPanel.savePreferences(dBConfig);
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.autoPin, (String)PreferencesArb.getString("AUTO_PIN"));
        ResourceUtils.resButton((AbstractButton)this.m_singleClick, (String)PreferencesArb.getString("SINGLE_CLICK_TREE"));
        this.add(this.autoPin, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 0, 0), 0, 0));
        this.add(this.m_singleClick, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 0, 0), 0, 0));
        this.add(this.dataEditorOptionPanel, new GridBagConstraints(0, 10, 2, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 0), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, 11, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }
}

