/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.dbtools.raptor.config.NavigationFilterTree;
import oracle.dbtools.raptor.config.NavigationFilterTreeRefresher;
import oracle.dbtools.raptor.config.NavigatorFilterConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.navigator.db.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.db.model.ObjectCategory;
import oracle.dbtools.raptor.navigator.db.model.ObjectType;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionType;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorHook;
import oracle.dbtools.raptor.navigator.db.xml.QueryFactory;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.ui.checktree.TriStateNode;

public class NavigatorFilterPanel
extends DefaultTraversablePanel {
    private static final Border focusBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, UIManager.getColor("Tree.selectionBorderColor"));
    private static final Border normalBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    boolean featureEnabled = false;
    private static final long serialVersionUID = 1L;
    private final String FOLDER_ROOT = "FOLDER_ROOT";
    JTabbedPane tabbedPane = null;
    private List<String> usedConnections = null;
    private NavigationFilterTree oracleTree = null;
    private DefaultTreeModel oracleTreeModel = null;
    private NavigationFilterTree timesTenTree = null;
    private DefaultTreeModel timesTenTreeModel = null;
    private String featureEnableCheckboxLabel = PreferencesArb.getString("NAVIGATOR_FILTER_FEATURE_CHOICE");
    private NavigationFilterTreeRefresher refresher = null;

    public NavigatorFilterPanel() {
        this.retriveConnectionTypes();
        this.printUsedConnections();
        this.setRefresher(new NavigationFilterTreeRefresher());
        this.init();
    }

    private void retriveConnectionTypes() {
        Iterator<ConnectionType> iterator = NavigatorHook.getHookInstance("sqldev.nav").getConnectionTypes();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            ConnectionType connectionType = iterator.next();
            String string = connectionType.getImpl().getConnectionPanelLabel();
            if (string == null || string.trim().length() <= 0) continue;
            String string2 = string.toUpperCase();
            if (string2.equals("ORACLE")) {
                arrayList.add("ORACLE");
            }
            if (!string2.equals("TIMESTEN")) continue;
            arrayList.add("TIMESTEN");
        }
        this.setUsedConnections(arrayList);
    }

    private void setUsedConnections(List<String> list) {
        this.usedConnections = list;
    }

    private List<String> getUsedConnections() {
        return this.usedConnections;
    }

    private void printUsedConnections() {
        List<String> list = this.getUsedConnections();
        for (int i = 0; i < list.size(); ++i) {
        }
    }

    private List<CategoryLabel> getOracleFolders() {
        QueryFactory queryFactory = QueryFactory.getFactory("sqldev.nav", "Oracle");
        List<CategoryLabel> list = this.findFolders(queryFactory);
        return list;
    }

    private List<CategoryLabel> getTimesTenFolders() {
        QueryFactory queryFactory = QueryFactory.getFactory("sqldev.nav", "TimesTen");
        List<CategoryLabel> list = this.findFolders(queryFactory);
        return list;
    }

    public void onEntry(TraversableContext traversableContext) {
        NavigatorFilterConfig navigatorFilterConfig = NavigatorFilterConfig.getInstance(traversableContext);
        this.featureEnabled = navigatorFilterConfig.isFeatureEnabled();
        this.updateModel(navigatorFilterConfig.getAllOracleElements(), this.oracleTreeModel);
        this.oracleTree.updateUI();
        this.updateModel(navigatorFilterConfig.getAllTimesTenElements(), this.timesTenTreeModel);
        this.timesTenTree.updateUI();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (this.oracleTree.getCellEditor() != null) {
            this.oracleTree.getCellEditor().stopCellEditing();
        }
        if (this.timesTenTree.getCellEditor() != null) {
            this.timesTenTree.getCellEditor().stopCellEditing();
        }
        NavigatorFilterConfig navigatorFilterConfig = NavigatorFilterConfig.getInstance(traversableContext);
        navigatorFilterConfig.setFeatureEnabled(this.featureEnabled);
        navigatorFilterConfig.putAllOracleElements(this.modelToMap(this.oracleTreeModel));
        navigatorFilterConfig.putAllTimesTenElements(this.modelToMap(this.timesTenTreeModel));
    }

    public void init() {
        this.setHelpID("f1_idedidesetNavigationFilter_html");
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        jLabel.setText(PreferencesArb.getString("NAVIGATION_FILTER_DES"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        this.add(jPanel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.tabbedPane = new JTabbedPane();
        this.add(this.tabbedPane, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        String[] stringArray = new String[]{PreferencesArb.getString("NAVIGATOR_FILTER_TAB_LABEL_ORACLE"), PreferencesArb.getString("NAVIGATOR_FILTER_TAB_LABEL_TIMESTEN")};
        this.tabbedPane.add(stringArray[0], this.createOracleDbTypePanel());
        this.tabbedPane.add(stringArray[1], this.createTimesTenDbTypePanel());
        this.setInitialFeatureSettings();
        JCheckBox jCheckBox = new JCheckBox(this.featureEnableCheckboxLabel);
        this.add(jCheckBox, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 25, 0, new Insets(10, 5, 0, 0), 0, 0));
        jCheckBox.setSelected(this.featureEnabled);
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NavigatorFilterConfig navigatorFilterConfig = NavigatorFilterConfig.getInstance();
                NavigatorFilterPanel.this.featureEnabled = ((JCheckBox)actionEvent.getSource()).isSelected();
                NavigatorFilterPanel.this.enableNavigationFilterPanels(NavigatorFilterPanel.this.featureEnabled);
            }
        });
    }

    private void setInitialFeatureSettings() {
        NavigatorFilterConfig navigatorFilterConfig = NavigatorFilterConfig.getInstance();
        this.featureEnabled = navigatorFilterConfig.isFeatureEnabled();
        this.enableNavigationFilterPanels(this.featureEnabled);
    }

    protected void enableNavigationFilterPanels(boolean bl) {
        int n = this.tabbedPane.getComponentCount();
        for (int i = 0; i < n; ++i) {
            String string = this.tabbedPane.getTitleAt(i);
            if (string.equals(PreferencesArb.getString("NAVIGATOR_FILTER_TAB_LABEL_ORACLE"))) {
                this.oracleTree.setEnabled(bl);
            } else if (string.equals(PreferencesArb.getString("NAVIGATOR_FILTER_TAB_LABEL_TIMESTEN"))) {
                this.timesTenTree.setEnabled(bl);
            }
            this.tabbedPane.setEnabledAt(i, bl);
        }
        this.tabbedPane.setEnabled(bl);
    }

    private JPanel createOracleDbTypePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        this.oracleTree = new NavigationFilterTree();
        Map<CategoryLabel, Object> map = this.createTreeMap2(this.getOracleFolders());
        this.oracleTreeModel = this.mapToModel2(map);
        this.oracleTree.setModel(this.oracleTreeModel);
        jScrollPane.setViewportView(this.oracleTree);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JPanel createTimesTenDbTypePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        this.timesTenTree = new NavigationFilterTree();
        Map<CategoryLabel, Object> map = this.createTreeMap2(this.getTimesTenFolders());
        this.timesTenTreeModel = this.mapToModel2(map);
        this.timesTenTree.setModel(this.timesTenTreeModel);
        jScrollPane.setViewportView(this.timesTenTree);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private TypeNode createTypeNode(CategoryLabel categoryLabel, Object object) {
        TypeNode typeNode = new TypeNode(categoryLabel);
        if (object instanceof Boolean) {
            if (!((Boolean)object).booleanValue()) {
                typeNode.setNodeState(TriStateNode.NodeState.NO);
            } else {
                typeNode.setNodeState(TriStateNode.NodeState.YES);
            }
        } else if (object instanceof Map) {
            typeNode.setNodeState(TriStateNode.NodeState.YES);
            for (Map.Entry entry : ((Map)object).entrySet()) {
                TypeNode typeNode2 = this.createTypeNode((CategoryLabel)entry.getKey(), entry.getValue());
                typeNode.add((MutableTreeNode)((Object)typeNode2));
            }
        }
        return typeNode;
    }

    private DefaultTreeModel mapToModel2(Map<CategoryLabel, Object> map) {
        TriStateNode triStateNode = new TriStateNode((Object)PreferencesArb.getString("NAVIGATION_FOLDERS_NAME"));
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel((TreeNode)triStateNode);
        triStateNode.setNodeState(TriStateNode.NodeState.YES);
        if (map != null) {
            for (Map.Entry<CategoryLabel, Object> entry : map.entrySet()) {
                CategoryLabel categoryLabel = entry.getKey();
                Object object = entry.getValue();
                TypeNode typeNode = this.createTypeNode(categoryLabel, object);
                triStateNode.add((MutableTreeNode)((Object)typeNode));
            }
        }
        return defaultTreeModel;
    }

    private void updateModel(Map<String, Object> map, DefaultTreeModel defaultTreeModel) {
        TriStateNode triStateNode = (TriStateNode)defaultTreeModel.getRoot();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string = entry.getKey();
            Object object = entry.getValue();
            this.findAndUpdate(string, object, defaultTreeModel, triStateNode);
        }
    }

    private void findAndUpdate(String string, Object object, DefaultTreeModel defaultTreeModel, TriStateNode triStateNode) {
        int n = defaultTreeModel.getChildCount(triStateNode);
        for (int i = 0; i < n; ++i) {
            TypeNode typeNode = (TypeNode)((Object)defaultTreeModel.getChild(triStateNode, i));
            if (!string.equals(typeNode.getType())) continue;
            if (object instanceof Boolean) {
                if (((Boolean)object).booleanValue()) {
                    typeNode.setNodeState(TriStateNode.NodeState.YES);
                } else {
                    typeNode.setNodeState(TriStateNode.NodeState.NO);
                }
                defaultTreeModel.reload((TreeNode)((Object)typeNode));
                break;
            }
            if (!(object instanceof Map)) break;
            Map map = (Map)object;
            for (Map.Entry entry : map.entrySet()) {
                String string2 = (String)entry.getKey();
                Object v = entry.getValue();
                this.findAndUpdate(string2, v, defaultTreeModel, typeNode);
            }
            break;
        }
    }

    private Map<String, Object> modelToMap(DefaultTreeModel defaultTreeModel) {
        if (defaultTreeModel == null) {
            return null;
        }
        TriStateNode triStateNode = (TriStateNode)defaultTreeModel.getRoot();
        return this.modelToMap(defaultTreeModel, triStateNode);
    }

    private Map<String, Object> modelToMap(DefaultTreeModel defaultTreeModel, TriStateNode triStateNode) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        int n = defaultTreeModel.getChildCount(triStateNode);
        for (int i = 0; i < n; ++i) {
            Object object;
            TypeNode typeNode = (TypeNode)((Object)defaultTreeModel.getChild(triStateNode, i));
            String string = typeNode.getType();
            if (defaultTreeModel.isLeaf((Object)typeNode)) {
                object = typeNode.getNodeState();
                if (object == TriStateNode.NodeState.YES) {
                    treeMap.put(string, Boolean.TRUE);
                    continue;
                }
                treeMap.put(string, Boolean.FALSE);
                continue;
            }
            object = this.modelToMap(defaultTreeModel, typeNode);
            if (object.isEmpty()) continue;
            treeMap.put(string, object);
        }
        return treeMap;
    }

    public Object[][] convertDataIntoArray(Map<String, Boolean> map) {
        Object[][] objectArray = new Object[map.size()][2];
        int n = 0;
        for (String string : map.keySet()) {
            objectArray[n][0] = string;
            objectArray[n][1] = map.get(string);
            ++n;
        }
        return objectArray;
    }

    private TreeMap<String, Boolean> createTreeMap(Object[][] objectArray) {
        TreeMap<String, Boolean> treeMap = new TreeMap<String, Boolean>();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                String string = (String)objectArray[i][0];
                Boolean bl = (Boolean)objectArray[i][1];
                if (string == null || bl == null) continue;
                treeMap.put(string, bl);
            }
        }
        return treeMap;
    }

    private Map<CategoryLabel, Object> createTreeMap2(List<CategoryLabel> list) {
        Map<String, Map<CategoryLabel, Object>> map = this.findUniqueParents(list);
        if (list != null) {
            for (CategoryLabel categoryLabel : list) {
                String string;
                Map<CategoryLabel, Object> map2;
                String string2 = categoryLabel.getType();
                if (string2 == null || (map2 = map.get(string = categoryLabel.getParent())) == null) continue;
                Map<CategoryLabel, Object> map3 = map.get(string2);
                if (map3 != null) {
                    map2.put(categoryLabel, map3);
                    continue;
                }
                map2.put(categoryLabel, Boolean.TRUE);
            }
        }
        return map.get("FOLDER_ROOT");
    }

    private Map<String, Map<CategoryLabel, Object>> findUniqueParents(List<CategoryLabel> list) {
        HashMap<String, Map<CategoryLabel, Object>> hashMap = new HashMap<String, Map<CategoryLabel, Object>>();
        for (CategoryLabel categoryLabel : list) {
            String string = categoryLabel.getParent();
            if (string == null) continue;
            hashMap.put(string, new TreeMap());
        }
        return hashMap;
    }

    List<CategoryLabel> findCategories(QueryFactory queryFactory, ObjectCategory[] objectCategoryArray, String string) {
        ArrayList<CategoryLabel> arrayList = new ArrayList<CategoryLabel>();
        if (objectCategoryArray != null) {
            for (ObjectCategory objectCategory : objectCategoryArray) {
                if (objectCategory == null) continue;
                String string2 = objectCategory.getType();
                String string3 = objectCategory.getLabel();
                arrayList.add(new CategoryLabel(string, string2, string3));
                arrayList.addAll(this.findCategories(queryFactory, queryFactory.listCategories(string2), string2));
                arrayList.addAll(this.findObjectTypes(queryFactory, queryFactory.listTypes(string2), string2));
            }
        }
        return arrayList;
    }

    List<CategoryLabel> findObjectTypes(QueryFactory queryFactory, ObjectType[] objectTypeArray, String string) {
        ArrayList<CategoryLabel> arrayList = new ArrayList<CategoryLabel>();
        if (objectTypeArray != null) {
            for (ObjectType objectType : objectTypeArray) {
                DatabaseFolder[] databaseFolderArray;
                if (objectType == null || (databaseFolderArray = objectType.getFolders()) == null || databaseFolderArray.length <= 0) continue;
                String string2 = objectType.getType();
                String string3 = databaseFolderArray[0].getLabel();
                arrayList.add(new CategoryLabel(string, string2, string3));
            }
        }
        return arrayList;
    }

    private List<CategoryLabel> findFolders(QueryFactory queryFactory) {
        ArrayList<CategoryLabel> arrayList = new ArrayList<CategoryLabel>();
        ObjectCategory[] objectCategoryArray = queryFactory.listCategories(null);
        arrayList.addAll(this.findCategories(queryFactory, objectCategoryArray, "FOLDER_ROOT"));
        ObjectType[] objectTypeArray = queryFactory.listTypes(null);
        arrayList.addAll(this.findObjectTypes(queryFactory, objectTypeArray, "FOLDER_ROOT"));
        return arrayList;
    }

    private void printTreeMap(TreeMap<String, Object> treeMap, String string) {
        if (treeMap != null) {
            for (String string2 : treeMap.keySet()) {
                Object object = treeMap.get(string2);
                if (object == null) continue;
                if (object instanceof Boolean) {
                    System.out.println("---- ----[" + string2 + "," + object + "]");
                }
                if (!(object instanceof TreeMap)) continue;
                this.printTreeMap((TreeMap)object, string2);
            }
        }
    }

    public void updateOraclePreferences(NavigatorFilterConfig navigatorFilterConfig) {
        navigatorFilterConfig.putAllOracleElements(this.modelToMap(this.oracleTreeModel));
    }

    public void updateTimesTenPreferences(NavigatorFilterConfig navigatorFilterConfig) {
        navigatorFilterConfig.putAllTimesTenElements(this.modelToMap(this.timesTenTreeModel));
    }

    public void setRefresher(NavigationFilterTreeRefresher navigationFilterTreeRefresher) {
        this.refresher = navigationFilterTreeRefresher;
    }

    public NavigationFilterTreeRefresher getNavigationFilterTreeRefresher() {
        return this.refresher;
    }

    private static class TypeNode
    extends TriStateNode {
        TypeNode(CategoryLabel categoryLabel) {
            super((Object)categoryLabel);
        }

        public String getLabel() {
            return ((CategoryLabel)this.getUserObject()).getLabel();
        }

        public void setUserObject(Object object) {
            if (!(object instanceof CategoryLabel)) {
                throw new IllegalArgumentException();
            }
            super.setUserObject(object);
        }

        String getType() {
            return ((CategoryLabel)this.getUserObject()).getType();
        }
    }

    private static class CategoryLabel
    implements Comparable<CategoryLabel> {
        final String mType;
        final String mLabel;
        final String mParent;
        final String mInternal;

        CategoryLabel(String string, String string2, String string3) {
            this.mParent = string;
            this.mType = string2;
            this.mLabel = string3;
            this.mInternal = "Parent = " + this.mParent + " type = " + this.mType + ", label=" + this.mLabel;
        }

        public String getType() {
            return this.mType;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String getParent() {
            return this.mParent;
        }

        public String toString() {
            return this.mInternal;
        }

        @Override
        public int compareTo(CategoryLabel categoryLabel) {
            int n = this.mLabel.compareTo(categoryLabel.mLabel);
            if (n == 0 && (n = this.mType.compareTo(categoryLabel.mParent)) == 0) {
                n = this.mParent.compareTo(categoryLabel.mParent);
            }
            return n;
        }

        public int hashCode() {
            return this.mInternal.hashCode();
        }

        public boolean equals(Object object) {
            return this == object || object instanceof CategoryLabel && this.mInternal.equals(((CategoryLabel)object).mInternal);
        }
    }
}

