/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import oracle.dbtools.raptor.navigator.db.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.db.model.ObjectCategory;
import oracle.dbtools.raptor.navigator.db.model.ObjectType;
import oracle.dbtools.raptor.navigator.db.xml.QueryFactory;
import oracle.ide.config.Preferences;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

public class NavigatorFilterConfig
extends HashStructureAdapter
implements Copyable {
    public static final String NAVIGATIONFILTER = "NAVIGATIONFILTER";
    public static final String ENABLE_FEATURE = "ENABLE_FEATURE";
    public static final String ORACLE = "ORACLE";
    public static final String MYSQL = "MYSQL";
    public static final String DB2 = "DB2";
    public static final String ACCESS = "ACCESS";
    public static final String SQLSERVER = "SQLSERVER";
    public static final String SYBASE = "SYBASE";
    public static final String TIMESTEN = "TIMESTEN";
    public static final String TERADATA = "TERADATA";
    public static final String POSTGRESQL = "POSTGRESQL";
    private static final String VERSION_KEY = "NavigatorFilter.Version";
    static final int API_VERSION = 2;
    private static final Logger LOGGER = Logger.getLogger(NavigatorFilterConfig.class.getName());
    private HashStructure hs = HashStructure.newInstance();

    private NavigatorFilterConfig(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static NavigatorFilterConfig getInstance(PropertyStorage propertyStorage) {
        return new NavigatorFilterConfig(NavigatorFilterConfig.findOrCreate((PropertyStorage)propertyStorage, (String)NAVIGATIONFILTER));
    }

    public static NavigatorFilterConfig getInstance(TraversableContext traversableContext) {
        return NavigatorFilterConfig.getInstance(traversableContext.getPropertyStorage());
    }

    public static synchronized NavigatorFilterConfig getInstance() {
        Preferences preferences = Preferences.getPreferences();
        NavigatorFilterConfig navigatorFilterConfig = NavigatorFilterConfig.getInstance((PropertyStorage)preferences);
        return navigatorFilterConfig;
    }

    public NavigatorFilterConfig() {
        super(HashStructure.newInstance());
    }

    public void setFeatureEnabled(boolean bl) {
        this.storeAllElements(null, ENABLE_FEATURE, bl);
    }

    public void putAllOracleElements(Map<String, Object> map) {
        this.storeAllElements(map, ORACLE, true);
    }

    public void putAllTimesTenElements(Map<String, Object> map) {
        this.storeAllElements(map, TIMESTEN, true);
    }

    private HashStructure mapToHashStructure(Map<String, Object> map) {
        HashStructure hashStructure = HashStructure.newInstance();
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String string = entry.getKey();
                Object object = entry.getValue();
                if (object instanceof Boolean) {
                    boolean bl = (Boolean)object;
                    hashStructure.putBoolean(string, bl);
                    continue;
                }
                if (!(object instanceof Map)) continue;
                HashStructure hashStructure2 = this.mapToHashStructure((Map)object);
                hashStructure.putHashStructure(string, hashStructure2);
            }
        }
        return hashStructure;
    }

    private void storeAllElements(Map<String, Object> map, String string, boolean bl) {
        HashStructure hashStructure;
        if (string.equals(ENABLE_FEATURE)) {
            this.hs.putBoolean(ENABLE_FEATURE, bl);
        }
        if (string.equals(ORACLE)) {
            hashStructure = this.mapToHashStructure(map);
            this.hs.putHashStructure(ORACLE, hashStructure);
        }
        if (string.equals(MYSQL)) {
            hashStructure = this.mapToHashStructure(map);
            this.hs.putHashStructure(MYSQL, hashStructure);
        }
        if (string.equals(DB2)) {
            hashStructure = this.mapToHashStructure(map);
            this.hs.putHashStructure(DB2, hashStructure);
        }
        if (string.equals(SYBASE)) {
            hashStructure = this.mapToHashStructure(map);
            this.hs.putHashStructure(SYBASE, hashStructure);
        }
        if (string.equals(TERADATA)) {
            hashStructure = this.mapToHashStructure(map);
            this.hs.putHashStructure(TERADATA, hashStructure);
        }
        if (string.equals(TIMESTEN)) {
            hashStructure = this.mapToHashStructure(map);
            this.hs.putHashStructure(TIMESTEN, hashStructure);
        }
        if (string.equals(SQLSERVER)) {
            hashStructure = this.mapToHashStructure(map);
            this.hs.putHashStructure(SQLSERVER, hashStructure);
        }
        if (string.equals(POSTGRESQL)) {
            hashStructure = this.mapToHashStructure(map);
            this.hs.putHashStructure(POSTGRESQL, hashStructure);
        }
        if (string.equals(ACCESS)) {
            hashStructure = this.mapToHashStructure(map);
            this.hs.putHashStructure(POSTGRESQL, hashStructure);
        }
        this._hash.putHashStructure(NAVIGATIONFILTER, this.hs);
    }

    public Map<String, Object> getAllOracleElements() {
        Map<String, Object> map = this.getAllElements(ORACLE);
        return map;
    }

    public Map<String, Object> getAllMySQLElements() {
        Map<String, Object> map = this.getAllElements(MYSQL);
        return map;
    }

    public Map<String, Object> getAllDB2Elements() {
        Map<String, Object> map = this.getAllElements(DB2);
        return map;
    }

    public Map<String, Object> getAllSybaseElements() {
        Map<String, Object> map = this.getAllElements(SYBASE);
        return map;
    }

    public Map<String, Object> getAllTeradataElements() {
        Map<String, Object> map = this.getAllElements(TERADATA);
        return map;
    }

    public Map<String, Object> getAllTimesTenElements() {
        Map<String, Object> map = this.getAllElements(TIMESTEN);
        return map;
    }

    public Map<String, Object> getAllSQLServerElements() {
        Map<String, Object> map = this.getAllElements(SQLSERVER);
        return map;
    }

    public Map<String, Object> getAllPostGreSQLElements() {
        Map<String, Object> map = this.getAllElements(POSTGRESQL);
        return map;
    }

    public Map<String, Object> getAllAccessElements() {
        Map<String, Object> map = this.getAllElements(ACCESS);
        return map;
    }

    public boolean isFeatureEnabled() {
        HashStructure hashStructure;
        boolean bl = false;
        Object object = this._hash.getObject(NAVIGATIONFILTER);
        if (object != null && object instanceof HashStructure && (hashStructure = (HashStructure)object) != null) {
            bl = hashStructure.getBoolean(ENABLE_FEATURE);
        }
        return bl;
    }

    private Map<String, Object> getAllElements(String string) {
        HashStructure hashStructure;
        Object object = this._hash.getObject(NAVIGATIONFILTER);
        if (object instanceof HashStructure && (hashStructure = (HashStructure)object) != null) {
            HashStructure hashStructure2 = hashStructure.getHashStructure(string);
            return this.hashStructureToMap(hashStructure2);
        }
        return Collections.emptyMap();
    }

    private Map<String, Object> hashStructureToMap(HashStructure hashStructure) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        boolean bl = false;
        if (hashStructure != null) {
            for (String string : hashStructure.keySet()) {
                Object object = hashStructure.getObject(string);
                if (object == null) continue;
                if (object instanceof String) {
                    treeMap.put(string, new Boolean(object.toString()));
                    continue;
                }
                if (!(object instanceof HashStructure)) continue;
                HashStructure hashStructure2 = (HashStructure)object;
                Map<String, Object> map = this.hashStructureToMap(hashStructure2);
                treeMap.put(string, map);
            }
        }
        return treeMap;
    }

    void checkForMigration() {
        HashStructure hashStructure = this._hash.getHashStructure(NAVIGATIONFILTER);
        if (hashStructure != null) {
            int n = hashStructure.getInt(VERSION_KEY, 1);
            switch (n) {
                case 1: {
                    this.migrateFilterSettingsToV2(hashStructure);
                    break;
                }
            }
        }
    }

    private void migrateFilterSettingsToV2(HashStructure hashStructure) {
        HashStructure hashStructure2;
        Map<String, String> map;
        HashStructure hashStructure3 = hashStructure.getHashStructure(ORACLE);
        if (hashStructure3 != null) {
            map = this.getTypeMap("Oracle");
            hashStructure2 = this.updateSettings(hashStructure3, map);
            hashStructure.putHashStructure(ORACLE, hashStructure2);
        }
        if ((hashStructure3 = hashStructure.getHashStructure(TIMESTEN)) != null) {
            map = this.getTypeMap("TimesTen");
            hashStructure2 = this.updateSettings(hashStructure3, map);
            hashStructure.putHashStructure(TIMESTEN, hashStructure2);
        }
        this.hs.putInt(VERSION_KEY, 2);
    }

    private Map<String, String> getTypeMap(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        QueryFactory queryFactory = QueryFactory.getFactory("sqldev.nav", string);
        hashMap.putAll(this.findCategories(queryFactory, null));
        hashMap.putAll(this.findTypes(queryFactory, null));
        return hashMap;
    }

    private Map<String, String> findCategories(QueryFactory queryFactory, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ObjectCategory[] objectCategoryArray = queryFactory.listCategories(string);
        if (objectCategoryArray != null) {
            for (ObjectCategory objectCategory : objectCategoryArray) {
                String string2 = objectCategory.getLabel();
                String string3 = objectCategory.getType();
                hashMap.put(string2, string3);
                hashMap.putAll(this.findCategories(queryFactory, string3));
                hashMap.putAll(this.findTypes(queryFactory, string3));
            }
        }
        return hashMap;
    }

    private Map<String, String> findTypes(QueryFactory queryFactory, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ObjectType[] objectTypeArray = queryFactory.listTypes(string);
        if (objectTypeArray != null) {
            for (ObjectType objectType : objectTypeArray) {
                DatabaseFolder[] databaseFolderArray = objectType.getFolders();
                if (databaseFolderArray == null || databaseFolderArray.length <= 0) continue;
                String string2 = objectType.getType();
                String string3 = databaseFolderArray[0].getLabel();
                hashMap.put(string3, string2);
            }
        }
        return hashMap;
    }

    HashStructure updateSettings(HashStructure hashStructure, Map<String, String> map) {
        HashStructure hashStructure2 = HashStructure.newInstance();
        if (hashStructure != null) {
            for (String string : hashStructure.keySet()) {
                String string2 = map.getOrDefault(string, string);
                Object object = hashStructure.getObject(string);
                if (object instanceof HashStructure) {
                    hashStructure2.putHashStructure(string2, this.updateSettings((HashStructure)object, map));
                    continue;
                }
                if (!(object instanceof String)) continue;
                hashStructure2.putString(string2, (String)object);
            }
        }
        return hashStructure2;
    }

    private void printTreeMap(TreeMap<String, Object> treeMap, String string) {
        if (treeMap != null) {
            for (String string2 : treeMap.keySet()) {
                Object object = treeMap.get(string2);
                if (object == null) continue;
                if (object instanceof Boolean) {
                    System.out.println("          \t[" + string2 + "," + object + "]");
                }
                if (!(object instanceof TreeMap)) continue;
                this.printTreeMap((TreeMap)object, string2);
            }
        }
    }
}

