/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.Messages;
import oracle.i18n.text.OraSimpleDateFormat;
import oracle.i18n.text.OraTerritory;
import oracle.i18n.util.OraLocaleInfo;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.util.ModelUtil;

public class NLSInfo
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private JComboBox m_cmbLang = new JComboBox();
    private String[] m_lang;
    private JComboBox m_cmbTerr = new JComboBox();
    private String[] m_terr;
    private JComboBox m_cmbSort = new JComboBox();
    private String[] m_sort;
    private JComboBox m_cmbNlsComp = new JComboBox();
    private String[] m_nlsComp;
    private JComboBox m_cmbDateLang = new JComboBox();
    private String[] m_dateLang;
    private JTextField m_fldDateFormat = new JTextField();
    private JTextField m_fldTsFormat = new JTextField();
    private JTextField m_fldTsTzFormat = new JTextField();
    private JTextField m_fldDecSep = new JTextField();
    private JTextField m_fldGrpSep = new JTextField();
    private JTextField m_fldCurrency = new JTextField();
    private JComboBox m_cmbIsoCur = new JComboBox();
    private String[] m_isoCur;
    private JComboBox m_cmbLen = new JComboBox();
    private JButton m_cmbDef;
    private String[] m_len;
    private JCheckBox m_skipNLS = new JCheckBox(StringUtils.stripMnemonic((String)Messages.getString("NLSInfo.36")));

    private void enableNLSWidgets(boolean bl) {
        this.m_cmbLang.setEnabled(bl);
        this.m_cmbTerr.setEnabled(bl);
        this.m_cmbSort.setEnabled(bl);
        this.m_cmbNlsComp.setEnabled(bl);
        this.m_cmbDateLang.setEnabled(bl);
        this.m_fldDateFormat.setEnabled(bl);
        this.m_fldTsFormat.setEnabled(bl);
        this.m_fldTsTzFormat.setEnabled(bl);
        this.m_fldDecSep.setEnabled(bl);
        this.m_fldGrpSep.setEnabled(bl);
        this.m_fldCurrency.setEnabled(bl);
        this.m_cmbIsoCur.setEnabled(bl);
        this.m_cmbLen.setEnabled(bl);
        this.m_cmbDef.setEnabled(bl);
    }

    public NLSInfo() {
        this.setHelpID("f1_dbprefnlsinfo_html");
        this.m_lang = OraLocaleInfo.getAvailableLanguages();
        this.m_terr = OraLocaleInfo.getAvailableTerritories();
        String[] stringArray = OraLocaleInfo.getAvailableLinguisticSorts();
        this.m_sort = new String[stringArray.length + 2];
        this.m_sort[0] = "BINARY";
        this.m_sort[1] = "BINARY_CI";
        System.arraycopy(stringArray, 0, this.m_sort, 2, stringArray.length);
        this.m_nlsComp = new String[]{"BINARY", "ANSI", "LINGUISTIC"};
        this.m_dateLang = OraLocaleInfo.getAvailableLanguages();
        this.m_isoCur = OraLocaleInfo.getAvailableTerritories();
        this.m_len = new String[]{"BYTE", "CHAR"};
        this.init();
    }

    private boolean validMask(String string) {
        try {
            new OraSimpleDateFormat(string, OraLocaleInfo.getDefault());
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        this.m_skipNLS.setSelected(dBConfig.getBoolean("NLS_SKIP"));
        this.m_cmbLang.setModel(new DefaultComboBoxModel<String>(this.m_lang));
        this.m_cmbLang.setSelectedItem(dBConfig.getString("NLS_LANG"));
        this.m_cmbTerr.setModel(new DefaultComboBoxModel<String>(this.m_terr));
        this.m_cmbTerr.setSelectedItem(dBConfig.getString("NLS_TERR"));
        this.m_cmbSort.setModel(new DefaultComboBoxModel<String>(this.m_sort));
        this.m_cmbSort.setSelectedItem(dBConfig.getString("NLS_SORT"));
        this.m_cmbNlsComp.setModel(new DefaultComboBoxModel<String>(this.m_nlsComp));
        this.m_cmbNlsComp.setSelectedItem(dBConfig.getString("NLS_COMP"));
        this.m_cmbDateLang.setModel(new DefaultComboBoxModel<String>(this.m_dateLang));
        this.m_cmbDateLang.setSelectedItem(dBConfig.getString("NLS_DATE_LANG"));
        this.m_fldDateFormat.setText(dBConfig.getString("NLS_DATE_FORM"));
        this.m_fldTsFormat.setText(dBConfig.getString("NLS_TS_FORM"));
        this.m_fldTsTzFormat.setText(dBConfig.getString("NLS_TS_TZ_FORM"));
        this.m_fldDecSep.setText(dBConfig.getString("NLS_DEC_SEP"));
        this.m_fldGrpSep.setText(dBConfig.getString("NLS_GRP_SEP"));
        this.m_fldCurrency.setText(dBConfig.getString("NLS_CURR"));
        this.m_cmbIsoCur.setModel(new DefaultComboBoxModel<String>(this.m_isoCur));
        this.m_cmbIsoCur.setSelectedItem(dBConfig.getString("NLS_ISO_CURR"));
        this.m_cmbLen.setModel(new DefaultComboBoxModel<String>(this.m_len));
        this.m_cmbLen.setSelectedItem(dBConfig.getString("NLS_LENGTH"));
        this.enableNLSWidgets(dBConfig.getBoolean("NLS_SKIP") == false);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.checkFormatMasks();
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putBoolean("NLS_SKIP", this.m_skipNLS.isSelected());
        dBConfig.putString("NLS_LANG", (String)this.m_cmbLang.getSelectedItem());
        dBConfig.putString("NLS_TERR", (String)this.m_cmbTerr.getSelectedItem());
        dBConfig.putString("NLS_SORT", (String)this.m_cmbSort.getSelectedItem());
        dBConfig.putString("NLS_COMP", (String)this.m_cmbNlsComp.getSelectedItem());
        dBConfig.putString("NLS_DATE_LANG", (String)this.m_cmbDateLang.getSelectedItem());
        dBConfig.putString("NLS_DATE_FORM", this.getValue(this.m_fldDateFormat));
        dBConfig.putString("NLS_TS_FORM", this.getValue(this.m_fldTsFormat));
        dBConfig.putString("NLS_TS_TZ_FORM", this.getValue(this.m_fldTsTzFormat));
        dBConfig.putString("NLS_DEC_SEP", this.getValue(this.m_fldDecSep));
        dBConfig.putString("NLS_GRP_SEP", this.getValue(this.m_fldGrpSep));
        dBConfig.putString("NLS_CURR", this.getValue(this.m_fldCurrency));
        dBConfig.putString("NLS_ISO_CURR", (String)this.m_cmbIsoCur.getSelectedItem());
        dBConfig.putString("NLS_LENGTH", (String)this.m_cmbLen.getSelectedItem());
    }

    private String getValue(JTextComponent jTextComponent) {
        return jTextComponent.getText().trim();
    }

    private void checkFormatMasks() throws TraversalException {
        boolean bl = this.validMask(this.getValue(this.m_fldDateFormat));
        boolean bl2 = this.validMask(this.getValue(this.m_fldTsFormat));
        boolean bl3 = this.validMask(this.getValue(this.m_fldTsTzFormat));
        Object object = "";
        int n = 0;
        if (!bl) {
            object = (String)object + Messages.getString("NLSInfo.10");
            ++n;
        }
        if (!bl2) {
            if (n > 0) {
                object = (String)object + ",";
            }
            object = (String)object + Messages.getString("NLSInfo.12");
        }
        if (!bl3) {
            if (n > 0) {
                object = (String)object + ",";
            }
            object = (String)object + Messages.getString("NLSInfo.14");
        }
        if (ModelUtil.hasLength((String)object)) {
            throw new TraversalException((String)object + Messages.getString("NLSInfo.15"), Messages.getString("NLSInfo.16"));
        }
    }

    public void init() {
        this.m_skipNLS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (NLSInfo.this.m_skipNLS.isSelected()) {
                    NLSInfo.this.enableNLSWidgets(false);
                } else {
                    NLSInfo.this.enableNLSWidgets(true);
                }
            }
        });
        this.m_skipNLS.setMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("NLSInfo.36")));
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        jLabel.setText(StringUtils.stripMnemonic((String)Messages.getString("NLSInfo.18")));
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("NLSInfo.18")));
        jLabel.setLabelFor(this.m_cmbLang);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(8, 5, 0, 0);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.add(jLabel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(8, 5, 0, 0);
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 1;
        this.add(this.m_cmbLang, gridBagConstraints2);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(StringUtils.stripMnemonic((String)Messages.getString("NLSInfo.19")));
        jLabel2.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("NLSInfo.19")));
        jLabel2.setLabelFor(this.m_cmbTerr);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(8, 5, 0, 0);
        gridBagConstraints3.anchor = 13;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridx = 2;
        this.add(jLabel2, gridBagConstraints3);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.insets = new Insets(8, 5, 0, 0);
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.gridx = 3;
        this.add(this.m_cmbTerr, gridBagConstraints4);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(StringUtils.stripMnemonic((String)Messages.getString("NLSInfo.25")));
        jLabel3.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("NLSInfo.25")));
        jLabel3.setLabelFor(this.m_cmbSort);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.insets = new Insets(8, 5, 0, 0);
        gridBagConstraints5.anchor = 13;
        gridBagConstraints5.gridy = 5;
        gridBagConstraints5.gridx = 0;
        this.add(jLabel3, gridBagConstraints5);
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.insets = new Insets(8, 5, 0, 0);
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.gridy = 5;
        gridBagConstraints6.gridx = 1;
        this.add(this.m_cmbSort, gridBagConstraints6);
        JLabel jLabel4 = new JLabel();
        jLabel4.setText(StringUtils.stripMnemonic((String)Messages.getString("NLSInfo.26")));
        jLabel4.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("NLSInfo.26")));
        jLabel4.setLabelFor(this.m_cmbNlsComp);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.insets = new Insets(8, 5, 0, 0);
        gridBagConstraints7.anchor = 13;
        gridBagConstraints7.gridy = 5;
        gridBagConstraints7.gridx = 2;
        this.add(jLabel4, gridBagConstraints7);
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.fill = 2;
        gridBagConstraints8.anchor = 17;
        gridBagConstraints8.gridy = 5;
        gridBagConstraints8.gridx = 3;
        gridBagConstraints8.insets = new Insets(8, 5, 0, 0);
        this.add(this.m_cmbNlsComp, gridBagConstraints8);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText(StringUtils.stripMnemonic((String)Messages.getString("NLSInfo.27")));
        jLabel5.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("NLSInfo.27")));
        jLabel5.setLabelFor(this.m_cmbDateLang);
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.insets = new Insets(8, 5, 0, 0);
        gridBagConstraints9.anchor = 13;
        gridBagConstraints9.gridy = 15;
        gridBagConstraints9.gridx = 0;
        this.add(jLabel5, gridBagConstraints9);
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.fill = 2;
        gridBagConstraints10.insets = new Insets(8, 5, 0, 0);
        gridBagConstraints10.anchor = 17;
        gridBagConstraints10.gridy = 15;
        gridBagConstraints10.gridx = 1;
        this.add(this.m_cmbDateLang, gridBagConstraints10);
        JLabel jLabel6 = new JLabel();
        jLabel6.setText(StringUtils.stripMnemonic((String)Messages.getString("NLSInfo.28")));
        jLabel6.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("NLSInfo.28")));
        jLabel6.setLabelFor(this.m_fldDateFormat);
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.insets = new Insets(8, 5, 0, 0);
        gridBagConstraints11.anchor = 13;
        gridBagConstraints11.gridy = 20;
        gridBagConstraints11.gridx = 0;
        this.add(jLabel6, gridBagConstraints11);
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.fill = 2;
        gridBagConstraints12.anchor = 17;
        gridBagConstraints12.gridy = 20;
        gridBagConstraints12.gridx = 1;
        gridBagConstraints12.insets = new Insets(8, 5, 0, 0);
        this.add(this.m_fldDateFormat, gridBagConstraints12);
        JLabel jLabel7 = new JLabel();
        jLabel7.setText(StringUtils.stripMnemonic((String)Messages.getString("NLSInfo.29")));
        jLabel7.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("NLSInfo.29")));
        jLabel7.setLabelFor(this.m_fldTsFormat);
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.insets = new Insets(8, 5, 0, 0);
        gridBagConstraints13.anchor = 13;
        gridBagConstraints13.gridy = 25;
        gridBagConstraints13.gridx = 0;
        this.add(jLabel7, gridBagConstraints13);
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.fill = 2;
        gridBagConstraints14.anchor = 17;
        gridBagConstraints14.gridy = 25;
        gridBagConstraints14.gridx = 1;
        gridBagConstraints14.insets = new Insets(8, 5, 0, 0);
        this.add(this.m_fldTsFormat, gridBagConstraints14);
        JLabel jLabel8 = new JLabel();
        jLabel8.setText(StringUtils.stripMnemonic((String)Messages.getString("NLSInfo.30")));
        jLabel8.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("NLSInfo.30")));
        jLabel8.setLabelFor(this.m_fldTsTzFormat);
        GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
        gridBagConstraints15.insets = new Insets(8, 5, 0, 0);
        gridBagConstraints15.anchor = 13;
        gridBagConstraints15.gridy = 30;
        gridBagConstraints15.gridx = 0;
        this.add(jLabel8, gridBagConstraints15);
        GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
        gridBagConstraints16.insets = new Insets(8, 5, 0, 0);
        gridBagConstraints16.fill = 2;
        gridBagConstraints16.anchor = 17;
        gridBagConstraints16.gridy = 30;
        gridBagConstraints16.gridx = 1;
        this.add(this.m_fldTsTzFormat, gridBagConstraints16);
        JLabel jLabel9 = new JLabel();
        jLabel9.setText(StringUtils.stripMnemonic((String)Messages.getString("NLSInfo.31")));
        jLabel9.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("NLSInfo.31")));
        jLabel9.setLabelFor(this.m_fldDecSep);
        GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
        gridBagConstraints17.insets = new Insets(8, 5, 0, 0);
        gridBagConstraints17.anchor = 13;
        gridBagConstraints17.gridy = 35;
        gridBagConstraints17.gridx = 0;
        this.add(jLabel9, gridBagConstraints17);
        GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
        gridBagConstraints18.insets = new Insets(8, 5, 0, 0);
        gridBagConstraints18.fill = 2;
        gridBagConstraints18.anchor = 17;
        gridBagConstraints18.gridy = 35;
        gridBagConstraints18.gridx = 1;
        this.add(this.m_fldDecSep, gridBagConstraints18);
        JLabel jLabel10 = new JLabel();
        jLabel10.setText(StringUtils.stripMnemonic((String)Messages.getString("NLSInfo.32")));
        jLabel10.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("NLSInfo.32")));
        jLabel10.setLabelFor(this.m_fldGrpSep);
        GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
        gridBagConstraints19.insets = new Insets(8, 5, 0, 0);
        gridBagConstraints19.anchor = 13;
        gridBagConstraints19.gridy = 35;
        gridBagConstraints19.gridx = 2;
        this.add(jLabel10, gridBagConstraints19);
        GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
        gridBagConstraints20.insets = new Insets(8, 5, 0, 0);
        gridBagConstraints20.fill = 2;
        gridBagConstraints20.anchor = 17;
        gridBagConstraints20.gridy = 35;
        gridBagConstraints20.gridx = 3;
        this.add(this.m_fldGrpSep, gridBagConstraints20);
        JLabel jLabel11 = new JLabel();
        jLabel11.setText(StringUtils.stripMnemonic((String)Messages.getString("NLSInfo.33")));
        jLabel11.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("NLSInfo.33")));
        jLabel11.setLabelFor(this.m_fldCurrency);
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.insets = new Insets(8, 5, 0, 0);
        gridBagConstraints21.anchor = 13;
        gridBagConstraints21.gridy = 45;
        gridBagConstraints21.gridx = 0;
        this.add(jLabel11, gridBagConstraints21);
        GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
        gridBagConstraints22.insets = new Insets(8, 5, 0, 0);
        gridBagConstraints22.fill = 2;
        gridBagConstraints22.anchor = 17;
        gridBagConstraints22.gridy = 45;
        gridBagConstraints22.gridx = 1;
        this.add(this.m_fldCurrency, gridBagConstraints22);
        JLabel jLabel12 = new JLabel();
        jLabel12.setText(StringUtils.stripMnemonic((String)Messages.getString("NLSInfo.34")));
        jLabel12.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("NLSInfo.34")));
        jLabel12.setLabelFor(this.m_cmbIsoCur);
        GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
        gridBagConstraints23.insets = new Insets(8, 5, 0, 0);
        gridBagConstraints23.anchor = 13;
        gridBagConstraints23.gridy = 45;
        gridBagConstraints23.gridx = 2;
        this.add(jLabel12, gridBagConstraints23);
        GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
        gridBagConstraints24.fill = 2;
        gridBagConstraints24.anchor = 17;
        gridBagConstraints24.gridy = 45;
        gridBagConstraints24.gridx = 3;
        gridBagConstraints24.insets = new Insets(8, 5, 0, 0);
        this.add(this.m_cmbIsoCur, gridBagConstraints24);
        JLabel jLabel13 = new JLabel();
        jLabel13.setText(StringUtils.stripMnemonic((String)Messages.getString("NLSInfo.35")));
        jLabel13.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("NLSInfo.35")));
        jLabel13.setLabelFor(this.m_cmbLen);
        GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
        gridBagConstraints25.insets = new Insets(8, 5, 0, 0);
        gridBagConstraints25.anchor = 13;
        gridBagConstraints25.gridy = 55;
        gridBagConstraints25.gridx = 0;
        this.add(jLabel13, gridBagConstraints25);
        GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
        gridBagConstraints26.insets = new Insets(8, 5, 0, 0);
        gridBagConstraints26.fill = 2;
        gridBagConstraints26.anchor = 17;
        gridBagConstraints26.gridy = 55;
        gridBagConstraints26.gridx = 1;
        this.add(this.m_cmbLen, gridBagConstraints26);
        GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
        gridBagConstraints27.insets = new Insets(8, 5, 0, 0);
        gridBagConstraints27.anchor = 13;
        gridBagConstraints27.gridy = 60;
        gridBagConstraints27.gridx = 0;
        this.add(this.m_skipNLS, gridBagConstraints27);
        this.m_cmbDef = new JButton(StringUtils.stripMnemonic((String)Messages.getString("NLSInfo.20")));
        this.m_cmbDef.setMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("NLSInfo.20")));
        GridBagConstraints gridBagConstraints28 = new GridBagConstraints();
        gridBagConstraints28.insets = new Insets(8, 5, 0, 0);
        gridBagConstraints28.fill = 0;
        gridBagConstraints28.anchor = 17;
        gridBagConstraints28.gridy = 60;
        gridBagConstraints28.gridx = 1;
        this.add(this.m_cmbDef, gridBagConstraints28);
        this.m_cmbDef.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OraLocaleInfo oraLocaleInfo = OraLocaleInfo.getInstance((String)NLSInfo.this.m_cmbLang.getSelectedItem().toString(), (String)NLSInfo.this.m_cmbTerr.getSelectedItem().toString());
                OraTerritory oraTerritory = OraTerritory.getInstance((String)NLSInfo.this.m_cmbLang.getSelectedItem().toString(), (String)NLSInfo.this.m_cmbTerr.getSelectedItem().toString());
                if (oraLocaleInfo.getLinguisticSort().indexOf("BINARY") > -1) {
                    NLSInfo.this.m_cmbSort.setSelectedItem("BINARY");
                } else {
                    NLSInfo.this.m_cmbSort.setSelectedItem(oraLocaleInfo.getLinguisticSort());
                }
                NLSInfo.this.m_cmbNlsComp.setSelectedItem("BINARY");
                NLSInfo.this.m_cmbDateLang.setSelectedItem(NLSInfo.this.m_cmbLang.getSelectedItem());
                NLSInfo.this.m_fldDateFormat.setText(oraTerritory.getOracleDateFormatString());
                NLSInfo.this.m_fldTsFormat.setText(oraTerritory.getNLSTimestampFormatString());
                NLSInfo.this.m_fldTsTzFormat.setText(oraTerritory.getNLSTimestampAndTimezoneFormatString());
                NLSInfo.this.m_fldDecSep.setText(oraTerritory.getDecimalCharacter());
                NLSInfo.this.m_fldGrpSep.setText(oraTerritory.getGroupSeparator());
                NLSInfo.this.m_fldCurrency.setText(oraTerritory.getLocalCurrencySymbol());
                NLSInfo.this.m_cmbIsoCur.setSelectedItem(NLSInfo.this.m_cmbTerr.getSelectedItem().toString());
                NLSInfo.this.m_cmbLen.setSelectedItem("BYTE");
            }
        });
        JLabel jLabel14 = new JLabel();
        GridBagConstraints gridBagConstraints29 = new GridBagConstraints();
        gridBagConstraints29.insets = new Insets(8, 5, 0, 0);
        gridBagConstraints29.weighty = 1.0;
        gridBagConstraints29.weightx = 1.0;
        gridBagConstraints29.gridwidth = 2;
        gridBagConstraints29.gridy = 100;
        gridBagConstraints29.gridx = 0;
        this.add(jLabel14, gridBagConstraints29);
        JLabel jLabel15 = new JLabel();
        GridBagConstraints gridBagConstraints30 = new GridBagConstraints();
        gridBagConstraints30.insets = new Insets(8, 5, 0, 0);
        gridBagConstraints30.weightx = 1.0;
        gridBagConstraints30.weighty = 1.0;
        gridBagConstraints30.gridheight = 7;
        gridBagConstraints30.gridy = 100;
        gridBagConstraints30.gridx = 2;
        this.add(jLabel15, gridBagConstraints30);
    }
}

