/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.WorksheetDndOptionPanel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class DnDOptions
extends DefaultTraversablePanel {
    private static final long serialVersionUID = -1285086996063278901L;
    private WorksheetDndOptionPanel m_worksheetPanel = new WorksheetDndOptionPanel();
    private Logger LOGGER = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public DnDOptions() {
        this.setHelpID("f1_dndoptionspref_html");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        this.m_worksheetPanel.setDragType(dBConfig.getInt("DRAG_N_DROP_CHOICES"));
        this.m_worksheetPanel.setPrompt(dBConfig.getInt("DRAG_N_DROP_PROMPT"));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putInt("DRAG_N_DROP_CHOICES", this.m_worksheetPanel.getDragType());
        dBConfig.putInt("DRAG_N_DROP_PROMPT", this.m_worksheetPanel.getPrompt());
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.add(this.m_worksheetPanel, gridBagConstraints);
    }
}

