/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.navigator;

import java.net.URI;
import java.net.URL;
import java.util.LinkedHashMap;
import javax.swing.Icon;
import oracle.dbtools.raptor.cloud.navigator.CloudObjectType;
import oracle.dbtools.raptor.cloud.navigator.CloudResource;
import oracle.dbtools.raptor.cloud.navigator.CloudViewerDetail;
import oracle.dbtools.raptor.navigator.db.ObjectElement;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.ide.model.Node;
import oracle.javatools.icons.OracleIcons;

public class CloudObject
extends Node
implements CloudResource,
ObjectElement {
    private String m_name;
    private String m_cName;
    private CloudObjectType m_type;
    private LinkedHashMap<String, CloudViewerDetail> m_viewers;
    private URI m_uri;

    public LinkedHashMap<String, CloudViewerDetail> getViewers() {
        return this.m_viewers;
    }

    public void setViewers(LinkedHashMap<String, CloudViewerDetail> linkedHashMap) {
        this.m_viewers = linkedHashMap;
    }

    public CloudObject() {
    }

    public CloudObject(URL uRL) {
        this.setURL(uRL);
    }

    public String getDetailsPath() {
        return this.m_type.getPath() + this.m_name;
    }

    public void setURL(URL uRL) {
        super.setURL(uRL);
        this.m_cName = DBURLFormatHelper.getConnectionName(uRL);
        this.m_name = DBURLFormatHelper.getName(uRL);
    }

    public void setConnectionName(String string) {
        this.m_cName = string;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    void setCloudObjectType(CloudObjectType cloudObjectType) {
        this.m_type = cloudObjectType;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getConnectionName() {
        return this.m_cName;
    }

    public String getObjectType() {
        return this.m_type.getType();
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    public String getShortLabel() {
        return this.getLongLabel();
    }

    public String getLongLabel() {
        return this.m_name;
    }

    public Icon getIcon() {
        return this.m_type != null ? this.m_type.getNodeIcon() : OracleIcons.getIcon((String)"unknownstatus.png");
    }

    public boolean mayHaveChildren() {
        return false;
    }

    @Override
    public void setRemoteURI(URI uRI) {
        this.m_uri = uRI;
    }

    @Override
    public URI getRemoteURI() {
        return this.m_uri;
    }

    @Override
    public String getTypeName() {
        return this.getObjectType();
    }
}

