/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.navigator;

import java.util.LinkedHashMap;
import java.util.Map;
import oracle.dbtools.raptor.cloud.CloudBrowserResources;
import oracle.dbtools.raptor.cloud.connection.CConnectionEvent;
import oracle.dbtools.raptor.cloud.connection.CConnections;
import oracle.dbtools.raptor.cloud.connection.CConnectionsListener;
import oracle.dbtools.raptor.cloud.navigator.CloudConnection;
import oracle.dbtools.raptor.cloud.navigator.CloudConnections;
import oracle.dbtools.raptor.cloud.navigator.CloudController;
import oracle.dbtools.raptor.cloud.navigator.CloudObject;
import oracle.dbtools.raptor.cloud.navigator.CloudViewerDetail;
import oracle.dbtools.raptor.navigator.db.BaseConnectionNode;
import oracle.dbtools.raptor.navigator.db.DBNavigatorWindow;
import oracle.dbtools.raptor.navigator.db.DatabaseTypeRoot;
import oracle.dbtools.raptor.navigator.db.DatabaseTypeSupport;
import oracle.dbtools.raptor.navigator.impl.ViewableElement;
import oracle.dbtools.raptor.oviewer.cloud.CloudEditorUtils;
import oracle.dbtools.util.Logger;
import oracle.ide.controller.Controller;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public class CloudDatabaseSupport
extends DatabaseTypeSupport {
    @Override
    public Controller createController(DBNavigatorWindow dBNavigatorWindow) {
        return CloudController.getInstance();
    }

    @Override
    public DatabaseTypeRoot getRoot() {
        return Holder.INSTANCE;
    }

    @Override
    public void registerViewers(ViewableElement viewableElement) {
        if (viewableElement instanceof CloudObject) {
            CloudObject cloudObject = (CloudObject)viewableElement;
            LinkedHashMap<String, CloudViewerDetail> linkedHashMap = cloudObject.getViewers();
            CloudEditorUtils cloudEditorUtils = CloudEditorUtils.getInstance();
            String string = cloudObject.getObjectType();
            float f = 10000.0f;
            for (Map.Entry<String, CloudViewerDetail> entry : linkedHashMap.entrySet()) {
                try {
                    CloudViewerDetail cloudViewerDetail = entry.getValue();
                    cloudEditorUtils.addTab(entry.getKey(), string, null, Float.valueOf(f), cloudViewerDetail.getUriString(), cloudViewerDetail.getStyle());
                    f -= 1.0f;
                }
                catch (Exception exception) {
                    Logger.severe(CloudDatabaseSupport.class, (Throwable)exception);
                }
            }
        }
    }

    @Override
    protected String getID() {
        return "sqldev.cloud";
    }

    @Override
    protected int getNewCommandID() {
        return CloudController.NEW_CLOUD_CONN_CMD_ID;
    }

    @Override
    protected String getNewLabelForSubmenu() {
        return CloudBrowserResources.getString("NEW_CONN_SUBMENU_TITLE");
    }

    @Override
    protected <T> BaseConnectionNode<T> getConnectionNode(String string, boolean bl) {
        return null;
    }

    @Override
    protected int getWeight() {
        return 1000;
    }

    private static class Holder {
        static final CloudConnections INSTANCE = new CloudConnections();

        private Holder() {
        }

        static {
            CConnections cConnections = CConnections.getInstance();
            for (String string : cConnections.listConnections()) {
                CloudConnection cloudConnection = CloudConnections.getConnectionNode(string, true);
                if (cloudConnection == null) continue;
                INSTANCE.add(cloudConnection);
            }
            cConnections.addListener(new CConnectionsListener(){

                @Override
                public void connectionAdded(CConnectionEvent cConnectionEvent) {
                    String string = cConnectionEvent.getConnectionName();
                    CloudConnection cloudConnection = CloudConnections.getConnectionNode(string, true);
                    if (cloudConnection != null) {
                        INSTANCE.add(cloudConnection);
                        UpdateMessage.fireChildAdded((Subject)INSTANCE, (Element)cloudConnection);
                    }
                }

                @Override
                public void connectionRemoved(CConnectionEvent cConnectionEvent) {
                    String string = cConnectionEvent.getConnectionName();
                    CloudConnection cloudConnection = CloudConnections.getConnectionNode(string, false);
                    if (cloudConnection != null) {
                        INSTANCE.remove(cloudConnection);
                        UpdateMessage.fireChildRemoved((Subject)INSTANCE, (Element)cloudConnection);
                    }
                }

                @Override
                public void connectionModified(CConnectionEvent cConnectionEvent) {
                }

                @Override
                public void connectionOpened(CConnectionEvent cConnectionEvent) {
                    String string = cConnectionEvent.getConnectionName();
                    CloudConnection cloudConnection = CloudConnections.getConnectionNode(string, false);
                    if (cloudConnection != null && cloudConnection.openConnection()) {
                        UpdateMessage.fireObjectOpened((Subject)cloudConnection);
                    }
                }

                @Override
                public void connectionClosed(CConnectionEvent cConnectionEvent) {
                    String string = cConnectionEvent.getConnectionName();
                    CloudConnection cloudConnection = CloudConnections.getConnectionNode(string, false);
                    if (cloudConnection != null && cloudConnection.isConnectionOpen()) {
                        cloudConnection.closeConnection(false);
                        UpdateMessage.fireObjectClosed((Subject)cloudConnection);
                    }
                }
            });
        }
    }
}

