/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.connection.ui;

import java.awt.Component;
import java.net.URI;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.cloud.CloudBrowserResources;
import oracle.dbtools.raptor.cloud.connection.ui.HostPanel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.util.URIUtils;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ModelUtil;

public class PublicHostPanel
extends HostPanel {
    private static final String DEFAULT_SERVICE_KEY = "_sqldev/";
    private JTextField m_svcName = new JTextField();
    private JButton m_btnAdv = new JButton();
    private String m_svcKey = "_sqldev/";

    public void onEntry(TraversableContext traversableContext) {
        String string = null;
        URI uRI = (URI)traversableContext.get("Cloud.Root");
        if (uRI != null) {
            String string2;
            string = uRI.toString();
            URI uRI2 = (URI)traversableContext.get("Cloud.ServiceURI");
            if (uRI2 != null && (string2 = uRI2.getPath()).startsWith(string)) {
                String string3;
                this.m_svcKey = string3 = string2.substring(string.length());
            }
        }
        this.m_svcName.setText(string);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        URI uRI = this.getServiceURI(this.m_svcName.getText());
        if (uRI == null) {
            throw new TraversalException(CloudBrowserResources.getString("NEW_CONN_MISSING_SERVICE_HOME"));
        }
        URI uRI2 = URIUtils.newURI((URI)uRI, (String)this.m_svcKey);
        traversableContext.put("Cloud.Root", (Object)uRI);
        traversableContext.put("Cloud.ServiceURI", (Object)uRI2);
    }

    @Override
    String getLabel() {
        return CloudBrowserResources.getString("NEW_PUBLIC_CONN_LABEL");
    }

    @Override
    JComponent createComponent() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_svcName, (String)CloudBrowserResources.getString("NEW_PUBLIC_CONN_SERVICE"));
        this.m_svcName.setColumns(30);
        ResourceUtils.resButton((AbstractButton)this.m_btnAdv, (String)CloudBrowserResources.getString("NEW_PUBLIC_CONN_ADVANCED"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel.add((Component)this.m_svcName, LayoutControl.GBC.gbc(1, 0, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        jPanel.add((Component)this.m_btnAdv, LayoutControl.GBC.gbc(2, 0, 1, 1, LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP, LayoutControl.GBC.Fill.NONE, LayoutControl.GBC.Spring.NONE));
        LayoutControl.GBC.addVSpring(jPanel, 1);
        return jPanel;
    }

    private URI getServiceURI(String string) {
        return ModelUtil.hasLength((String)string) ? URIUtils.newURI((String)string, (boolean)true) : null;
    }
}

