/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.apex.importer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.apex.importer.ApexImportArb;
import oracle.dbtools.raptor.apex.importer.ApexImporter;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.controls.progress.DelayedProgressRunnable;
import oracle.dbtools.raptor.controls.progress.IDelayedProgressRunnable;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.utils.OutputRedirector;
import oracle.dbtools.raptor.scriptrunner.utils.ScriptUtils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;

public class ApexImportFinalPanel
extends DefaultTraversablePanel {
    private static final Logger LOGGER = Logger.getLogger(ApexImporter.class.getName());
    private TraversableContext _dataCtx;
    private String _filename;
    private GridBagConstraints _gbc;
    private File _fileTo;
    private Connection _toConn;
    private boolean _finished = false;
    private ScriptExecutor _sr;
    private int _availId;
    private String _username;

    public ApexImportFinalPanel() {
        this.setLayout(new GridBagLayout());
        this.setDefaultTitle(ApexImportArb.getString("FINISH_TITLE"));
    }

    public void addPair(String string, Object object) {
        ++this._gbc.gridy;
        this.add(new JLabel(string), this._gbc);
        ++this._gbc.gridx;
        if (object instanceof String) {
            this.add(new JLabel(object.toString()), this._gbc);
        } else {
            this.add((Component)object, this._gbc);
        }
        this._gbc.gridwidth = 1;
        this._gbc.gridx = 0;
    }

    public void onEntry(final TraversableContext traversableContext) {
        this._finished = false;
        this._gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 1, 2, 0), 0, 0);
        Context context = (Context)traversableContext.get("CONTEXT");
        DBObject dBObject = (DBObject)((Object)context.getProperty("DB_OBJECT"));
        this._dataCtx = traversableContext;
        this._filename = (String)traversableContext.get("FILENAME");
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
        final TraversableContext traversableContext2 = traversableContext;
        final HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Context context2 = (Context)traversableContext2.get("CONTEXT");
        DBObject dBObject2 = (DBObject)((Object)context2.getProperty("DB_OBJECT"));
        hashMap.put("APEX_DBO", (Object)dBObject2);
        hashMap.put("connection", traversableContext.get("connection"));
        hashMap.put("SEL", traversableContext.get("SEL"));
        hashMap.put("p_id", (String)traversableContext.get("p_id"));
        hashMap.put("p_alias", traversableContext.get("p_alias"));
        hashMap.put("sgid", (String)traversableContext.get("sgid"));
        hashMap.put("ISOVERWRITE", traversableContext.get("ISOVERWRITE"));
        hashMap.put("p_id", traversableContext.get("p_id"));
        hashMap.put("offset", traversableContext.get("offset"));
        hashMap.put("APEX_USERNAME", this._username);
        hashMap.put("APEX_LOCKCONNNAME", dBObject2.getConnectionName());
        DatabaseQueryTask<String> databaseQueryTask = new DatabaseQueryTask<String>(ApexImportArb.getString("ID_TITLE"), IRaptorTaskRunMode.MODAL, false, true){
            private String connName;
            {
                super(string, iRaptorTaskRunMode, bl, bl2);
                this.connName = (String)hashMap.get("APEX_LOCKCONNNAME");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected String doWork() throws TaskException {
                String string = null;
                try {
                    String string2;
                    Connection connection = null;
                    Connection connection2 = null;
                    DBObject dBObject = (DBObject)((Object)hashMap.get("APEX_DBO"));
                    Connection connection3 = Connections.getInstance().getConnection(dBObject.getConnectionName());
                    if (Connections.getInstance().lock(connection3)) {
                        try {
                            connection = dBObject.getConnection();
                        }
                        finally {
                            Connections.getInstance().unlock(connection3);
                        }
                    }
                    if (hashMap.get("connection") == null) {
                        connection2 = connection;
                    } else {
                        try {
                            connection2 = Connections.getInstance().getConnection((String)hashMap.get("connection"));
                        }
                        catch (DBException dBException) {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
                        }
                    }
                    String string3 = (String)traversableContext.get("SEL");
                    if (string3.equals(ApexImportArb.getString("AUTO_NEW_ID"))) {
                        hashMap.put("p_id", "AUTO");
                        hashMap.put("offset", Math.round(Math.random() * Math.pow(10.0, 10.0)));
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add((String)traversableContext.get("workspace_name"));
                    String string4 = DBUtil.getInstance((Connection)connection2).executeReturnOneCol("select workspace_id from  apex_workspace_schemas ws where workspace_name = :WORKSPACE_NAME", arrayList);
                    traversableContext.put("sgid", (Object)string4);
                    if (traversableContext2.get("connection") != null) {
                        try {
                            connection2 = Connections.getInstance().getConnection((String)traversableContext2.get("connection"));
                        }
                        catch (DBException dBException) {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
                        }
                    }
                    hashMap.put("APEX_USERNAME", null);
                    if (Connections.getInstance().lock(connection2)) {
                        try {
                            string2 = null;
                            string2 = hashMap.get("connection") == null ? dBObject.getSchemaName() : DBUtil.getInstance((Connection)connection2).executeReturnOneCol("select USER from dual");
                            if (string2 == null || string2 == "") {
                                Logger.getLogger(ApexImportFinalPanel.class.getClass().getName()).log(Level.SEVERE, "Schema name not found");
                            }
                            hashMap.put("APEX_USERNAME", string2);
                        }
                        finally {
                            Connections.getInstance().unlock(connection2);
                        }
                    }
                    if (!ApexImportFinalPanel.this.validateAlias(connection2, (String)hashMap.get("p_id"), (String)hashMap.get("p_alias"))) {
                        throw new TraversalException(ApexImportArb.getString("ALIAS_IN_USE"));
                    }
                    if (!string3.equals(ApexImportArb.getString("AUTO_NEW_ID"))) {
                        string2 = (String)hashMap.get("p_id");
                        try {
                            Long.parseLong(string2);
                        }
                        catch (Exception exception) {
                            throw new TraversalException(ApexImportArb.getString("INVALID_ID"));
                        }
                        int n = ApexImportFinalPanel.this.validateIdNoUI(connection2, Long.parseLong((String)hashMap.get("sgid")), Long.parseLong(string2));
                        if (n == -1) {
                            throw new TraversalException(ApexImportArb.getString("INVALID_ID"));
                        }
                        if (n == 1 && !((Boolean)hashMap.get("ISOVERWRITE")).booleanValue()) {
                            throw new TraversalException(ApexImportArb.getString("OVERWRITE_MUST_BE_CHECKED"));
                        }
                    }
                    hashMap.put("APEX_TOCONN", connection2);
                    hashMap.put("APEX_FROMCONN", connection);
                }
                catch (Exception exception) {
                    throw new TaskException((Throwable)exception);
                }
                return string;
            }

            public String getQuery() {
                return ApexImportArb.getString("ID_TITLE");
            }

            public String getConnectionName() {
                return this.connName;
            }
        };
        databaseQueryTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter((DatabaseQueryTask)databaseQueryTask, hashMap, traversableContext2){
            final /* synthetic */ DatabaseQueryTask val$task;
            final /* synthetic */ Map val$varsForTask;
            final /* synthetic */ TraversableContext val$localDataContext;
            {
                this.val$task = databaseQueryTask;
                this.val$varsForTask = map;
                this.val$localDataContext = traversableContext;
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                this.cleanup(true, false, null);
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                Throwable throwable;
                Throwable throwable2 = raptorTaskEvent.getThrowable();
                while (throwable2 instanceof DBException && (throwable = throwable2.getCause()) instanceof Exception) {
                    throwable2 = throwable;
                }
                throwable = throwable2;
                if (throwable instanceof TraversalException) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            ((TraversalException)throwable).showMessageDialog((Component)((Object)ApexImportFinalPanel.this));
                        }
                    };
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(runnable);
                    } else {
                        runnable.run();
                    }
                } else {
                    ExceptionHandler.handleException((Throwable)((Exception)throwable2));
                }
                this.cleanup(false, true, null);
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                try {
                    this.cleanup(false, false, (String)this.val$task.getResult());
                }
                catch (InterruptedException interruptedException) {
                    ExceptionHandler.handleException((Throwable)interruptedException);
                }
                catch (ExecutionException executionException) {
                    ExceptionHandler.handleException((Throwable)executionException);
                }
            }

            private void cleanup(final boolean bl, final boolean bl2, String string) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (!bl && !bl2) {
                                ApexImportFinalPanel.this._toConn = (Connection)val$varsForTask.get("APEX_TOCONN");
                                ApexImportFinalPanel.this._username = (String)val$varsForTask.get("APEX_USERNAME");
                                val$localDataContext.put("p_id", val$varsForTask.get("p_id"));
                                val$localDataContext.put("offset", val$varsForTask.get("offset"));
                                val$localDataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
                                ApexImportFinalPanel.this.onEntryAfterTask(val$localDataContext);
                            } else if (bl) {
                                ApexImportFinalPanel.this.removeAll();
                                ApexImportFinalPanel.this.setLayout(new GridBagLayout());
                                ApexImportFinalPanel.this.add(new JLabel(ApexImportArb.getString("CANCEL_LABEL")));
                            } else if (bl2) {
                                ApexImportFinalPanel.this.removeAll();
                                ApexImportFinalPanel.this.setLayout(new GridBagLayout());
                                val$localDataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
                                ApexImportFinalPanel.this.add(new JLabel(ApexImportArb.getString("BACK_OR_CANCEL_LABEL")));
                            }
                            ApexImportFinalPanel.this.revalidate();
                            ApexImportFinalPanel.this.repaint();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        });
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
        RaptorTaskManager.getInstance().addTask((RaptorTask)databaseQueryTask);
    }

    public void onEntryAfterTask(TraversableContext traversableContext) {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        this.init();
        this.revalidate();
        this.repaint();
    }

    public void init() {
        Comparable<Boolean> comparable;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("p_alias", (String)this._dataCtx.get("p_alias"));
        hashMap.put("p_build_status", (String)this._dataCtx.get("p_build_status"));
        hashMap.put("p_id", (String)this._dataCtx.get("p_id"));
        hashMap.put("p_name", (String)this._dataCtx.get("p_name"));
        hashMap.put("offset", this._dataCtx.get("offset").toString());
        hashMap.put("sgid", (String)this._dataCtx.get("sgid"));
        if (this._dataCtx.get("SCRIPT.RUN") != null) {
            comparable = (Boolean)this._dataCtx.get("SCRIPT.RUN");
            if (comparable.booleanValue()) {
                hashMap.put("SCRIPT.RUN", "TRUE");
            } else {
                hashMap.put("SCRIPT.RUN", "FALSE");
            }
        } else {
            hashMap.put("SCRIPT.RUN", "FALSE");
        }
        hashMap.put("p_owner", this._username);
        comparable = null;
        try {
            comparable = new File(this._filename);
            this._fileTo = File.createTempFile("apex", ".sql");
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException((Throwable)iOException);
        }
        ApexImporter.processFile((File)comparable, this._fileTo, hashMap, (String)this._dataCtx.get("SCRIPT.ENCODING"));
        if (this._dataCtx.get("connection") != null) {
            this.addPair(ApexImportArb.getString("CONN_PROMPT"), Connections.getConnectionName((String)this._dataCtx.get("connection")));
        }
        this.addPair(ApexImportArb.getString("PARSE_AS"), this._username);
        if (this._dataCtx.get("connection") != null) {
            this.addPair(ApexImportArb.getString("WORKSPACE_PROMPT"), this._dataCtx.get("workspace_name"));
        }
        this.addPair(ApexImportArb.getString("NEW_ID"), this._dataCtx.get("p_id"));
        this.addPair(ApexImportArb.getString("APP_NAME"), this._dataCtx.get("p_name"));
        this.addPair(ApexImportArb.getString("ALIAS_NAME"), this._dataCtx.get("p_alias"));
        this.addPair(ApexImportArb.getString("RUN_OPTIONS"), this._dataCtx.get("p_build_status"));
        this.addPair(ApexImportArb.getString("REVIEW_FILE"), this._fileTo.getAbsolutePath());
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (!this._finished && traversableContext.getDirection() == 1) {
            this.runFileInDialog(traversableContext, this._fileTo, this._toConn, ApexImportArb.getString("COMPLETE_TITLE"), ApexImportArb.getString("COMPLETE"));
            throw new TraversalException(null);
        }
    }

    public void runFileInDialog(TraversableContext traversableContext, File file, Connection connection, String string, String string2) {
        final File file2 = file;
        final Connection connection2 = connection;
        final BasicEditorPane basicEditorPane = EditorFactory.createIdeEditorPane();
        final String string3 = string2;
        final String string4 = string;
        final TraversableContext traversableContext2 = traversableContext;
        final DelayedProgressRunnable delayedProgressRunnable = new DelayedProgressRunnable(ApexImportArb.get("IMPORTING"), null, 500, null, (Component)basicEditorPane);
        basicEditorPane.setText(ApexImportArb.get("IMPORTING_MSG"));
        basicEditorPane.setEditable(false);
        final IDelayedProgressRunnable iDelayedProgressRunnable = new IDelayedProgressRunnable(){
            private boolean _isCanceled = false;

            @Override
            public void cancel() {
                ApexImportFinalPanel.this._sr.interrupt();
                this._isCanceled = true;
            }

            @Override
            public Object doWork() {
                boolean bl;
                Object var1_1 = null;
                ArrayList arrayList = new ArrayList();
                String string = "@" + file2.getAbsolutePath();
                ApexImportFinalPanel.this.run(basicEditorPane, string, connection2, delayedProgressRunnable);
                boolean bl2 = bl = ApexImportFinalPanel.this._sr.getScriptRunnerContext().getProperty("sqldev.error") == null ? false : (Boolean)ApexImportFinalPanel.this._sr.getScriptRunnerContext().getProperty("sqldev.error");
                if (ApexImportFinalPanel.this._sr.getScriptRunnerContext().getExited() || bl) {
                    ScriptUtils.showError(basicEditorPane);
                } else if (string4 != null && string3 != null) {
                    ApexImportFinalPanel.this._finished = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WizardDialog wizardDialog = (WizardDialog)traversableContext2.get("WIZ");
                            if (wizardDialog != null) {
                                wizardDialog.setVisible(false);
                                wizardDialog.dispose();
                            }
                        }
                    });
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)string3, (String)string4, null);
                }
                return var1_1;
            }

            @Override
            public void finish(Object object) {
                file2.deleteOnExit();
                if (this._isCanceled) {
                    try {
                        connection2.rollback();
                    }
                    catch (SQLException sQLException) {
                        LOGGER.severe(Messages.getString("ApexImportFinalPanel.13"));
                    }
                }
            }

            @Override
            public void preWork() {
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                delayedProgressRunnable.setRunnable(iDelayedProgressRunnable);
                delayedProgressRunnable.setCancellable(true);
                delayedProgressRunnable.start();
            }
        });
    }

    public int validateIdNoUI(Connection connection, Long l, Long l2) {
        int n = ApexImporter.checkAvail(connection, l, l2);
        return n;
    }

    private void run(BasicEditorPane basicEditorPane, String string, Connection connection, DelayedProgressRunnable delayedProgressRunnable) {
        this._sr = new ScriptExecutor(string, connection);
        basicEditorPane.setEditable(true);
        this._sr.setScriptRunnerContext(new ScriptRunnerContext());
        this._sr.getScriptRunnerContext().setSubstitutionChar('^');
        this._sr.getScriptRunnerContext().setSubstitutionOn(false);
        this._sr.getScriptRunnerContext().setScanOn(false);
        this._sr.getScriptRunnerContext().setEncoding("UTF-8");
        PipedInputStream pipedInputStream = new PipedInputStream();
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new PipedOutputStream(pipedInputStream));
        }
        catch (IOException iOException) {
            LOGGER.throwing(ScriptUtils.class.getName(), Messages.getString("ApexImportFinalPanel.14"), iOException);
        }
        this._sr.setOut(bufferedOutputStream);
        this._sr.start();
        OutputRedirector outputRedirector = new OutputRedirector(pipedInputStream, basicEditorPane.getDocument(), basicEditorPane);
        outputRedirector.setName("Script output reader");
        outputRedirector.setProgressPanel(delayedProgressRunnable.getProgressPanel());
        outputRedirector.start();
        basicEditorPane.setEditable(false);
        while (this._sr.isAlive()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean validateAlias(Connection connection, String string, String string2) {
        String string3 = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        arrayList.add((String)this._dataCtx.get("workspace_name"));
        if (string.equals("AUTO")) {
            string3 = DBUtil.getInstance((Connection)connection).executeReturnOneCol("select count(1) from  apex_Applications where alias = :ALIAS and workspace = :WORKSPACE_NAME", arrayList);
        } else {
            arrayList.add(string);
            string3 = DBUtil.getInstance((Connection)connection).executeReturnOneCol("select count(1) from  apex_Applications where alias = :ALIAS and workspace = :WORKSPACE_NAME and application_id <> :APPID", arrayList);
        }
        return !string3.equals("1");
    }
}

