/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.lang.invoke.CallSite;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.plsql.IdentifiersDb;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Service;

public class ProcArg {
    public String owner;
    public String pkg;
    public String procedure;
    public String argumentName;
    public int argumentPos;
    public String type;
    private static final String QUERY_ARGUMENTS = "SELECT a.position, a.owner, a.package_name, a.object_name, a.overload, a.argument_name, a.data_type FROM all_arguments a, all_objects o \nWHERE a.object_id=o.object_id and argument_name is not null \n";

    public ProcArg(String string, String string2, String string3, String string4, int n, String string5) {
        this.owner = string;
        this.pkg = string2;
        this.procedure = string3;
        this.argumentName = string4;
        this.argumentPos = n;
        this.type = string5;
    }

    private static final String PACKAGED_PROC_CRITERIA(int n) {
        return " and o.object_name = :PKG_NAME" + n + " and a.object_name = :PROC_NAME" + n + "\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ProcArg> collectViaDbQuery(ParseNode parseNode, List<LexerToken> list, String string) {
        DBUtil dBUtil = DBUtil.getInstance((String)string);
        StringBuffer stringBuffer = new StringBuffer();
        HashMap<CallSite, String> hashMap = new HashMap<CallSite, String>();
        HashSet hashSet = new HashSet();
        int n = 0;
        for (Object object : parseNode.descendants()) {
            String string2;
            Iterator iterator;
            if (!object.contains(IdentifiersDb.instance.procedure_call) || !(iterator = object.children().iterator()).hasNext()) continue;
            ParseNode parseNode2 = (ParseNode)iterator.next();
            if (parseNode2.from + 3 == parseNode2.to) {
                string2 = parseNode2.content(list).toUpperCase();
                int n2 = string2.indexOf(46);
                if (hashSet.contains(string2)) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("\n union all \n");
                }
                stringBuffer.append(QUERY_ARGUMENTS);
                stringBuffer.append(ProcArg.PACKAGED_PROC_CRITERIA(n));
                hashMap.put((CallSite)((Object)("PKG_NAME" + n)), string2.substring(0, n2));
                hashMap.put((CallSite)((Object)("PROC_NAME" + n)), string2.substring(n2 + 1));
            } else if (parseNode2.from == parseNode2.to) {
                string2 = parseNode2.content(list).toUpperCase();
                if (hashSet.contains(string2)) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("\n union all \n");
                }
                stringBuffer.append(QUERY_ARGUMENTS);
                stringBuffer.append(ProcArg.PACKAGED_PROC_CRITERIA(n));
                hashMap.put((CallSite)((Object)("PKG_NAME" + n)), "STANDARD");
                hashMap.put((CallSite)((Object)("PROC_NAME" + n)), string2);
            }
            ++n;
        }
        LinkedList linkedList = new LinkedList();
        if (stringBuffer.length() == 0) {
            return linkedList;
        }
        if (Connections.getInstance().lock(string)) {
            Object object;
            object = null;
            try {
                object = dBUtil.executeQuery(stringBuffer.toString(), hashMap);
                while (object.next()) {
                    linkedList.add(new ProcArg(object.getString("OWNER"), object.getString("PACKAGE_NAME"), object.getString("OBJECT_NAME"), object.getString("ARGUMENT_NAME"), object.getInt("POSITION"), object.getString("DATA_TYPE")));
                }
            }
            catch (SQLException sQLException) {
                System.out.println(sQLException.getMessage());
            }
            finally {
                DBUtil.closeResultSet((ResultSet)object);
                Connections.getInstance().unlock(string);
            }
        }
        return linkedList;
    }

    public static List<ProcArg> collectViaParsing(List<LexerToken> list) {
        LinkedList<ProcArg> linkedList = new LinkedList<ProcArg>();
        SqlEarley sqlEarley = SqlEarley.getInstance();
        Matrix matrix = new Matrix((Parser)sqlEarley);
        sqlEarley.parse(list, matrix);
        ParseNode parseNode = sqlEarley.forest(list, matrix);
        if (parseNode == null) {
            return linkedList;
        }
        for (ParseNode parseNode2 : parseNode.descendants()) {
            if (!parseNode2.contains(IdentifiersDb.instance.subprg_spec)) continue;
            String string = null;
            for (ParseNode parseNode3 : parseNode2.children()) {
                if (parseNode3.contains(IdentifiersDb.instance.func_return_prm_spec_unconstrained_type)) {
                    linkedList.add(new ProcArg(null, null, string, null, 0, parseNode3.content(list)));
                }
                if (parseNode3.contains(IdentifiersDb.instance.decl_id)) {
                    string = parseNode3.content(list);
                }
                if (!parseNode3.contains(IdentifiersDb.instance.fml_part)) continue;
                int n = 1;
                for (ParseNode parseNode4 : parseNode3.descendants()) {
                    if (!parseNode4.contains(IdentifiersDb.instance.prm_spec)) continue;
                    String string2 = null;
                    String string3 = null;
                    for (ParseNode parseNode5 : parseNode4.children()) {
                        if (parseNode5.contains(IdentifiersDb.instance.decl_id)) {
                            string2 = parseNode5.content(list);
                            continue;
                        }
                        if (!parseNode5.contains(IdentifiersDb.instance.unconstrained_type)) continue;
                        string3 = parseNode5.content(list);
                    }
                    linkedList.add(new ProcArg(null, null, string, string2, n++, string3));
                }
            }
        }
        return linkedList;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = Service.readFile(ProcArg.class, (String)"ProcArgTest.sql");
        List list = LexerToken.parse((String)string);
        for (ProcArg procArg : ProcArg.collectViaParsing(list)) {
            System.out.println(procArg.procedure + " @" + procArg.argumentPos + ": " + procArg.argumentName + " " + procArg.type);
        }
    }
}

