/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.wizard;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.autorest.ui.JEditorPaneScrollPaneWrapper;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestResourceHandler;
import oracle.dbtools.rest.model.RestTemplate;
import oracle.dbtools.rest.wizard.RestBaseSummaryTabPanel;

public class RestPublishSummaryTabPanel
extends RestBaseSummaryTabPanel {
    public RestPublishSummaryTabPanel(RestModule restModule, JEditorPaneScrollPaneWrapper jEditorPaneScrollPaneWrapper) {
        super(jEditorPaneScrollPaneWrapper);
        this.buildSummaryTree(restModule);
    }

    public void buildSummaryTree(RestModule restModule) {
        this.getSummaryTree().removeAll();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(RestArb.getString("WIZ_SUMMARY_ROOT"));
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.getPublishSummaryNode(restModule);
        if (defaultMutableTreeNode2 != null) {
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        this.getSummaryTree().setModel(new DefaultTreeModel(defaultMutableTreeNode));
        if (defaultMutableTreeNode2 != null) {
            this.getSummaryTree().expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
        }
    }

    private DefaultMutableTreeNode getPublishSummaryNode(RestModule restModule) {
        RestTemplate restTemplate;
        if (restModule == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(StringUtils.stripMnemonic((String)RestArb.getString("REST_MENU_PUBLISH")));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("MODULE_NAME")), restModule.getName())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("URI_PREFIX")), restModule.getURIPrefix())));
        RestTemplate restTemplate2 = restTemplate = restModule.getTemplates() != null ? (RestTemplate)restModule.getTemplates().get(0) : null;
        if (restTemplate != null) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("URI_PATTERN")), restTemplate.getURIPattern())));
        }
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getLabel(StringUtils.stripMnemonic((String)RestArb.getString("PUBLISH")), restModule.isPublished())));
        RestResourceHandler restResourceHandler = restTemplate.getResourceHandler(RestResourceHandler.HTTP_METHOD_TYPE.GET);
        if (restResourceHandler != null) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("PAGINATION_SIZE")), Long.toString(restResourceHandler.getPaginationSize()))));
        }
        return defaultMutableTreeNode;
    }
}

