/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.utils;

import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.patterns.RoutePattern;
import oracle.dbtools.rest.patterns.RoutePatternsProvider;

public class RestPrivilegeURIPattern {
    public static RoutePattern getRoutePattern(String string) {
        RoutePatternsProvider routePatternsProvider = new RoutePatternsProvider();
        if (string == null) {
            throw new NullPointerException();
        }
        String string2 = string.toString();
        if (string2.indexOf("*") != -1) {
            return routePatternsProvider.parseGlobPattern(string2);
        }
        return routePatternsProvider.parseLiteralPattern(string2);
    }

    public static boolean validateURIPattern(String string) {
        RoutePatternsProvider routePatternsProvider = new RoutePatternsProvider();
        if (string == null) {
            throw new NullPointerException();
        }
        String string2 = string.toString();
        StringBuilder stringBuilder = new StringBuilder();
        if (!string2.startsWith("/")) {
            stringBuilder.append(RestArb.format("SEC_URI_BEGIN_FORWARD_SLASH", string2)).append("\n");
        }
        if (string2.contains("//")) {
            stringBuilder.append(RestArb.format("SEC_ERR_MULTIPLE_FORWARD_SLASH", string2)).append("\n");
        }
        try {
            if (string2.indexOf("*") != -1) {
                routePatternsProvider.parseGlobPattern(string2);
            } else {
                routePatternsProvider.parseLiteralPattern(string2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            int n = string2.indexOf(42);
            if (n != -1 && n + 1 != string2.length()) {
                stringBuilder.append(RestArb.format("SEC_ERR_WILDCARD", string2)).append("\n");
            }
            char[] cArray = string2.toCharArray();
            StringBuilder stringBuilder2 = new StringBuilder();
            for (char c : cArray) {
                if (":/?#[]@!$&'()*+,;=".indexOf(c) == -1 || c == '*' || c == '/') continue;
                stringBuilder2.append(c).append(' ');
            }
            if (stringBuilder2.length() > 0) {
                stringBuilder.append(RestArb.format("SEC_ERR_RESRV_CHARS", string2, stringBuilder2.toString())).append("\n");
            }
            stringBuilder.append(illegalArgumentException.getMessage());
        }
        if (stringBuilder.length() > 0) {
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        return true;
    }
}

