/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.utils;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.dbtools.plugin.api.json.objects.JSONObject;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.JSONUtils;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestPrivilege;
import oracle.dbtools.rest.utils.RestJSONUtil;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.dbtools.rest.utils.RestXMLUtil;
import oracle.ide.Ide;
import oracle.ide.net.URLFilter;

public class RestOpenAdmin {
    private static File _lastUrl;
    private ZipFile _zipFile;

    public static boolean openAdminFromFile() {
        return new RestOpenAdmin().loadAdministration();
    }

    protected boolean showOpenDialog() {
        if (_lastUrl == null) {
            _lastUrl = new File(this.getImportDirectory());
        }
        URLFileChooser uRLFileChooser = new URLFileChooser(_lastUrl);
        uRLFileChooser.clearChooseableURLFilters();
        uRLFileChooser.setURLFilter((URLFilter)RestUtils.ZIP_FILTER);
        uRLFileChooser.setSelectionScope(2);
        uRLFileChooser.setSelectionMode(0);
        uRLFileChooser.setShowJarsAsDirs(false);
        int n = uRLFileChooser.showOpenDialog((Component)Ide.getMainWindow(), RestArb.getString("OPEN_ADMINISTRATION"));
        if (n == 0) {
            int n2;
            String string = uRLFileChooser.getSelectedFile().toString();
            String string2 = string.substring(n2 = string.lastIndexOf(File.separator));
            _lastUrl = string2.lastIndexOf(".") > -1 ? uRLFileChooser.getSelectedFile() : new File(uRLFileChooser.getSelectedFile().toString() + ".zip");
            return true;
        }
        return false;
    }

    private String getImportDirectory() {
        Object object = DBConfig.getInstance().getString("IMPORTDIR") + File.separator;
        if (object == null || ((String)object).equals("")) {
            object = System.getProperty("user.home");
        }
        return object;
    }

    protected boolean loadAdministration() {
        try {
            if (this.showOpenDialog()) {
                return this.loadDataFromZip(_lastUrl.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadDataFromZip(String string) {
        ArrayList<RestModule> arrayList = new ArrayList<RestModule>();
        ArrayList<RestPrivilege> arrayList2 = new ArrayList<RestPrivilege>();
        boolean bl = false;
        try {
            this._zipFile = new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = this._zipFile.entries();
            while (enumeration.hasMoreElements()) {
                RestModule restModule;
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry == null) continue;
                if (zipEntry.getName().endsWith(".xml")) {
                    restModule = RestXMLUtil.getModule(this._zipFile.getInputStream(zipEntry), "UTF-8");
                    if (restModule == null) continue;
                    arrayList.add(restModule);
                    continue;
                }
                if (!zipEntry.getName().endsWith(".json")) continue;
                restModule = JSONUtils.objects().read((Reader)new BufferedReader(new InputStreamReader(this._zipFile.getInputStream(zipEntry), Charset.forName("UTF-8"))));
                RestPrivilege restPrivilege = RestJSONUtil.getPrivilege((JSONObject)restModule);
                if (restPrivilege == null) continue;
                arrayList2.add(restPrivilege);
            }
            if (!arrayList.isEmpty() || !arrayList2.isEmpty()) {
                bl = RestUtils.loadAdmin(arrayList, arrayList2);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            if (this._zipFile != null) {
                try {
                    this._zipFile.close();
                }
                catch (Exception exception) {}
            }
        }
        return bl;
    }
}

