/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URI;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.controls.IDBConnectionComboBoxListener;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.ddl.DDLResources;
import oracle.dbtools.raptor.insight.CompletionInsight;
import oracle.dbtools.raptor.phighlight.HighlightEditorPlugin;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.model.RestTemplate;
import oracle.dbtools.rest.utils.RestTemplatePattern;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;

public class RestTemplatePanel
extends JPanel {
    private JTextField _uriPattern;
    private JTextField _comments;
    private JComboBox<String> _entityTag;
    private JLabel _uriExample1;
    private JLabel _templateURIExample;
    private RestTemplate _template;
    private List<String> _errMsg;
    private List<String> _existingURIs;
    private JSlider _prioritySlider;
    private JPanel _descripPanel;
    private JPanel _eTagPanel;
    private BasicEditorPane _queryEditor;
    private JTextPane _descrip;
    private JPanel _queryPanel;
    private DBConnectionComboBox _dbConnectionCB;
    private String _currQualConnName;
    private CompletionInsight _codeInsight = null;
    private ConnnectionOpenListener _connOpenListener;
    private boolean _includeSlash;
    private boolean _showComments;
    private String _schema;

    public RestTemplatePanel(RestTemplate restTemplate, boolean bl) {
        this(restTemplate, null, bl);
    }

    public RestTemplatePanel(RestTemplate restTemplate, String string, boolean bl) {
        this._template = restTemplate;
        this._schema = string;
        this._showComments = bl;
        this.createPanel();
    }

    private void initializeComponents() {
        this._uriPattern = new JTextField();
        this._uriExample1 = new JLabel();
        this._templateURIExample = new JLabel();
        this._comments = new JTextField();
        Font font = this._templateURIExample.getFont();
        this._templateURIExample.setFont(font.deriveFont(font.getStyle() | 1, font.getSize()));
        this._prioritySlider = new JSlider(0, 9, this._template != null ? this._template.getPriority() : 0);
        this._prioritySlider.setMinorTickSpacing(1);
        this._prioritySlider.setPaintTicks(true);
        this._prioritySlider.setPaintTrack(true);
        this._prioritySlider.setSnapToTicks(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(0, new JLabel(RestArb.getString("LOW")));
        hashtable.put(4, new JLabel(RestArb.getString("MEDIUM")));
        hashtable.put(9, new JLabel(RestArb.getString("HIGH")));
        this._prioritySlider.setLabelTable(hashtable);
        this._prioritySlider.setPaintLabels(true);
        String[] stringArray = new String[RestTemplate.ENTITY_TAG_TYPE.values().length];
        int n = 0;
        for (RestTemplate.ENTITY_TAG_TYPE eNTITY_TAG_TYPE : RestTemplate.ENTITY_TAG_TYPE.values()) {
            stringArray[n++] = eNTITY_TAG_TYPE.getNLS();
        }
        this._entityTag = new JComboBox<String>(stringArray);
        if (this._template != null) {
            this._uriPattern.setText(this._template.getURIPattern());
            this._comments.setText(this._template.getComments());
            int n2 = 0;
            if (this._template.getEntityTag() != null) {
                n2 = this._template.getEntityTag().ordinal();
            }
            this._entityTag.setSelectedIndex(n2);
            if (this._template.getConnectionName() != null) {
                this._currQualConnName = this._template.getConnectionName();
            }
        } else {
            this._entityTag.setSelectedIndex(0);
        }
        this.setModuleURIExample(RestArb.getString("URI_MODULE_DEFAULT"), this._schema);
        this.addListeners();
    }

    private void createPanel() {
        this.initializeComponents();
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel(RestArb.getString("URI_EXAMPLE_LABEL"));
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._uriPattern, (String)RestArb.getString("URI_TEMPLATE"));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this._prioritySlider, (String)RestArb.getString("PRIORITY"));
        ResourceUtils.resLabel((JLabel)jLabel4, this._entityTag, (String)RestArb.getString("ENTITY_TAG"));
        ResourceUtils.resLabel((JLabel)this._uriExample1, (Component)this._templateURIExample, (String)this._uriExample1.getText());
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 8, 6), 0, 0));
        jPanel.add((Component)this._uriPattern, new GridBagConstraints(1, n, 2, 1, 0.5, 1.0, 23, 2, new Insets(8, 0, 8, 8), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(4, 8, 8, 6), 0, 0));
        jPanel.add((Component)this._uriExample1, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(4, 0, 8, 0), 0, 0));
        jPanel.add((Component)this._templateURIExample, new GridBagConstraints(2, n, 1, 1, 0.5, 1.0, 23, 2, new Insets(4, 0, 8, 8), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel, (String)RestArb.getString("URI_TITLE"));
        n = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jLabel3, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(8, 0, 0, 6), 0, 0));
        jPanel2.add((Component)this._prioritySlider, new GridBagConstraints(1, n, 1, 1, 1.0, 1.0, 23, 2, new Insets(8, 0, 0, 8), 0, 0));
        this._queryPanel = new JPanel(new GridBagLayout());
        this._descripPanel = new JPanel(new GridBagLayout());
        n = 0;
        this._eTagPanel = new JPanel(new GridBagLayout());
        this._eTagPanel.add((Component)jLabel4, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 0, 6), 0, 0));
        this._eTagPanel.add(this._entityTag, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 23, 0, new Insets(8, 0, 0, 8), 0, 0));
        this._eTagPanel.add((Component)this._descripPanel, new GridBagConstraints(0, 2, 2, 2, 1.0, 1.0, 23, 1, new Insets(0, 8, 4, 0), 0, 0));
        this._eTagPanel.add((Component)this._queryPanel, new GridBagConstraints(0, 2, 2, 2, 1.0, 1.0, 23, 1, new Insets(0, 8, 4, 0), 0, 0));
        this._queryPanel.setVisible(false);
        this._eTagPanel.add(Box.createGlue(), new GridBagConstraints(0, 3, 2, 1, 0.1, 0.1, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        UIUtils.makeTitledBorder((JComponent)this._eTagPanel, (String)RestArb.getString("ENTITY_TAG_TITLE"));
        n = 0;
        this.add((Component)jPanel, new GridBagConstraints(0, n, 1, 1, 1.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel2, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.0, 23, 2, new Insets(8, 0, 8, 0), 0, 0));
        if (this._showComments) {
            JLabel jLabel5 = new JLabel();
            ResourceUtils.resLabel((JLabel)jLabel5, (Component)this._comments, (String)DDLResources.getString((String)"GEN_COMMENTS"));
            JPanel jPanel3 = new JPanel(new GridBagLayout());
            jPanel3.add((Component)jLabel5, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(8, 0, 8, 6), 0, 0));
            jPanel3.add((Component)this._comments, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.5, 23, 2, new Insets(8, 0, 8, 8), 0, 0));
            this.add((Component)jPanel3, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.0, 23, 2, new Insets(8, 0, 8, 0), 0, 0));
        }
        this.add((Component)this._eTagPanel, new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 23, 1, new Insets(10, 0, 0, 0), 0, 0));
        this._uriPattern.requestFocusInWindow();
        this.checkEntityTagSelection();
        this._entityTag.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                RestTemplatePanel.this.checkEntityTagSelection();
            }
        });
    }

    public void checkEntityTagSelection() {
        RestTemplate.ENTITY_TAG_TYPE eNTITY_TAG_TYPE = RestTemplate.ENTITY_TAG_TYPE.values()[this._entityTag.getSelectedIndex()];
        if (eNTITY_TAG_TYPE == RestTemplate.ENTITY_TAG_TYPE.QUERY) {
            this.showQueryPanel();
        } else {
            this.hideQueryPanel(eNTITY_TAG_TYPE);
        }
    }

    public void showQueryPanel() {
        if (this._queryPanel.getComponentCount() == 0) {
            JLabel jLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)jLabel, (Component)this._queryPanel, (String)RestArb.getString("ETAG_QUERY_DESCRIP"));
            this._dbConnectionCB = new DBConnectionComboBox();
            if (this._currQualConnName != null) {
                this._dbConnectionCB.setCurrentConnection(this._currQualConnName);
            }
            this._connOpenListener = new ConnnectionOpenListener();
            this._dbConnectionCB.addConnectionOpenListener((IDBConnectionComboBoxListener)this._connOpenListener, null);
            this._queryPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 0, 0, 6), 0, 0));
            this._queryPanel.add((Component)this._dbConnectionCB.getJComboBox(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 0, 0, 6), 0, 0));
            this._queryPanel.add((Component)this.createQueryEditor(), new GridBagConstraints(0, 2, 1, 4, 1.0, 1.0, 23, 1, new Insets(4, 0, 0, 8), 0, 0));
        }
        if (this._descripPanel.isVisible()) {
            this._descripPanel.setVisible(false);
        }
        if (!this._queryPanel.isVisible()) {
            this._queryPanel.setVisible(true);
        }
        this._eTagPanel.revalidate();
        this._eTagPanel.repaint();
    }

    public void hideQueryPanel(RestTemplate.ENTITY_TAG_TYPE eNTITY_TAG_TYPE) {
        if (this._descripPanel.getComponentCount() == 0) {
            this._descrip = new JTextPane();
            this._descrip.setPreferredSize(new Dimension(200, 200));
            this._descrip.setEditable(false);
            this._descrip.setOpaque(false);
            this._descrip.setFocusable(false);
            int n = 0;
            this._descripPanel.add((Component)this._descrip, new GridBagConstraints(0, n, 1, 1, 0.2, 0.2, 23, 1, new Insets(8, 0, 0, 8), 0, 0));
            this._descripPanel.add(Box.createGlue(), new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (eNTITY_TAG_TYPE == RestTemplate.ENTITY_TAG_TYPE.SECURE_HASH) {
            this._descrip.setText(RestArb.getString("ETAG_SECURE_DESCRIP"));
        } else {
            this._descrip.setText(RestArb.getString("ETAG_NONE_DESCRIP"));
        }
        if (this._queryPanel.isVisible()) {
            this._queryPanel.setVisible(false);
        }
        if (!this._descripPanel.isVisible()) {
            this._descripPanel.setVisible(true);
        }
        this._eTagPanel.revalidate();
        this._eTagPanel.repaint();
    }

    private JScrollPane createQueryEditor() {
        this._queryEditor = EditorFactory.createIdeEditorPane();
        this._queryEditor.setDocument((Document)new BasicDocument("foo.plsql"));
        this._queryEditor.installPlugin((EditorPlugin)new LineGutterPlugin());
        this._queryEditor.installPlugin((EditorPlugin)new LineHighlightPlugin());
        this._queryEditor.installPlugin((EditorPlugin)new HighlightEditorPlugin());
        this._queryEditor.setPreferredSize(null);
        if (this._template != null && this._template.getEntityTagQuery() != null) {
            this._queryEditor.setText(this._template.getEntityTagQuery());
        }
        if (this._currQualConnName != null) {
            this.installCodeInsight(this._currQualConnName);
        }
        JScrollPane jScrollPane = new JScrollPane((Component)this._queryEditor, 22, 32);
        jScrollPane.setPreferredSize(this._queryEditor.getPreferredSize());
        jScrollPane.setSize(jScrollPane.getPreferredSize());
        return jScrollPane;
    }

    private void installCodeInsight(String string) {
        if (string != null && Connections.getInstance().isOracle(string)) {
            if (this._codeInsight != null) {
                this._queryEditor.deinstallPlugin((EditorPlugin)this._codeInsight);
            }
            BackgroundParser backgroundParser = null;
            this._codeInsight = new CompletionInsight(string, backgroundParser, null);
            this._queryEditor.installPlugin((EditorPlugin)this._codeInsight);
        }
    }

    public void setModuleURIExample(String string) {
        this.setModuleURIExample(string, null);
    }

    public void setModuleURIExample(String string, String string2) {
        Object object;
        String string3 = string == null ? "" : string.trim();
        Object object2 = "";
        if (string2 != null) {
            object2 = RestArb.format("HTTP_EXAMPLE_HOST_PORT2", string2.toLowerCase());
        } else {
            object = RestUtils.getBaseURI();
            if (object != null) {
                object2 = ((URI)object).toString();
                object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
            } else {
                object2 = RestArb.getString("HTTP_EXAMPLE_HOST_PORT");
            }
        }
        if (!RestUtils.emptyValue(string3)) {
            object2 = string3.startsWith("/") ? (String)object2 + string3 : (String)object2 + "/" + string3;
        }
        this._includeSlash = !((String)object2).endsWith("/");
        this._uriExample1.setText((String)object2);
        if (this._uriPattern != null && !RestUtils.emptyValue(this._uriPattern.getText())) {
            object = this._uriPattern.getText();
            if (this._includeSlash) {
                object = "/" + (String)object;
            }
            this._templateURIExample.setText((String)object);
        }
    }

    public void addListeners() {
        if (this._uriPattern != null && this._uriPattern.getKeyListeners().length == 0) {
            this._uriPattern.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    Object object = RestTemplatePanel.this._uriPattern.getText();
                    if (RestTemplatePanel.this._includeSlash && object != null && !((String)object).isEmpty() && !((String)object).startsWith("/")) {
                        object = "/" + (String)object;
                    }
                    RestTemplatePanel.this._templateURIExample.setText((String)object);
                }
            });
        }
        if (this._queryEditor != null && this._queryPanel.getComponentCount() > 0) {
            this._dbConnectionCB = new DBConnectionComboBox();
            this._connOpenListener = new ConnnectionOpenListener();
            this._dbConnectionCB.addConnectionOpenListener((IDBConnectionComboBoxListener)this._connOpenListener, null);
            if (this._currQualConnName != null) {
                this._dbConnectionCB.setCurrentConnection(this._currQualConnName);
                this.installCodeInsight(this._currQualConnName);
            }
        }
    }

    public void removeListeners() {
        if (this._uriPattern != null) {
            KeyListener[] keyListenerArray;
            for (KeyListener keyListener : keyListenerArray = this._uriPattern.getKeyListeners()) {
                this._uriPattern.removeKeyListener(keyListener);
            }
        }
        if (this._codeInsight != null) {
            this._queryEditor.deinstallPlugin((EditorPlugin)this._codeInsight);
            this._codeInsight = null;
        }
        if (this._dbConnectionCB != null) {
            this._dbConnectionCB.setCurrentConnection(null);
            this._dbConnectionCB.removeConnectionOpenListener();
            this._dbConnectionCB.dispose();
        }
    }

    public boolean validInfo() {
        RestTemplate.ENTITY_TAG_TYPE eNTITY_TAG_TYPE;
        if (this._errMsg == null) {
            this._errMsg = new ArrayList<String>();
        } else {
            this._errMsg.clear();
        }
        boolean bl = false;
        String string = this._uriPattern.getText();
        if (RestUtils.emptyValue(string)) {
            this.setErrorMessage(RestArb.format("VALUE_REQUIRED", RestArb.getString("LABEL_URI_TEMPLATE")));
            this._uriPattern.requestFocusInWindow();
        } else if (this.isExistURI(string)) {
            this.setErrorMessage(RestArb.format("VALUE_ALREADY_EXIST", RestArb.getString("LABEL_URI_TEMPLATE")));
            this._uriPattern.requestFocusInWindow();
        } else if (RestTemplatePattern.isURITemplatePattern(string)) {
            if (!RestTemplatePattern.isValidURITemplate(string)) {
                this.setErrorMessage(RestArb.format("URI_SYNTAX_ERROR", RestArb.getString("LABEL_URI_TEMPLATE")));
            }
        } else {
            try {
                RestTemplatePattern.getRoutePattern(string);
            }
            catch (Exception exception) {
                this.setErrorMessage(RestArb.format("TEMPLATE_URI_SYNTAX_ERROR", string, exception.getMessage()));
            }
        }
        if (this._errMsg.size() > 0) {
            bl = true;
        }
        if ((eNTITY_TAG_TYPE = RestTemplate.ENTITY_TAG_TYPE.values()[this._entityTag.getSelectedIndex()]) == RestTemplate.ENTITY_TAG_TYPE.QUERY && RestUtils.emptyValue(this._queryEditor.getText())) {
            this.setErrorMessage(RestArb.format("VALUE_REQUIRED", RestArb.getString("ENTITY_TAG_QUERY")));
        }
        if (this._errMsg.size() > 0) {
            if (bl) {
                this._uriPattern.requestFocusInWindow();
            } else {
                this._queryEditor.requestFocusInWindow();
            }
        }
        return this._errMsg.size() == 0;
    }

    public RestTemplate getValues() {
        if (this._template == null) {
            this._template = new RestTemplate();
        }
        this._template.setURIPattern(this._uriPattern.getText());
        this._template.setPriority(this._prioritySlider.getValue());
        this._template.setComments(this._comments.getText());
        RestTemplate.ENTITY_TAG_TYPE eNTITY_TAG_TYPE = RestTemplate.ENTITY_TAG_TYPE.values()[this._entityTag.getSelectedIndex()];
        this._template.setEntityTag(eNTITY_TAG_TYPE);
        if (eNTITY_TAG_TYPE == RestTemplate.ENTITY_TAG_TYPE.QUERY) {
            this._template.setEntityTagQuery(this._queryEditor.getText());
            if (this._currQualConnName != null) {
                this._template.setConnectionName(this._currQualConnName);
            }
        } else {
            this._template.setEntityTagQuery(null);
            this._template.setConnectionName(null);
        }
        return this._template;
    }

    public String getErrorMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this._errMsg) {
            stringBuffer.append(string).append("\n");
        }
        return stringBuffer.toString();
    }

    private void setErrorMessage(String string) {
        if (this._errMsg == null) {
            this._errMsg = new ArrayList<String>();
        }
        this._errMsg.add(string);
    }

    public boolean isExistURI(String string) {
        if (this._existingURIs == null || this._existingURIs.isEmpty()) {
            return false;
        }
        return this._existingURIs.contains(string);
    }

    public void setExistingURIs(List<String> list) {
        this._existingURIs = list;
    }

    public boolean valuesChanged(RestTemplate restTemplate) {
        if (restTemplate != null) {
            String string;
            String string2;
            if (RestUtils.valuesDifferent(restTemplate.getURIPattern(), this._uriPattern.getText())) {
                return true;
            }
            if (this._showComments && RestUtils.valuesDifferent(restTemplate.getComments(), this._comments.getText())) {
                return true;
            }
            if (restTemplate.getPriority() != this._prioritySlider.getValue()) {
                return true;
            }
            RestTemplate.ENTITY_TAG_TYPE eNTITY_TAG_TYPE = RestTemplate.ENTITY_TAG_TYPE.values()[this._entityTag.getSelectedIndex()];
            if (restTemplate.getEntityTag() != eNTITY_TAG_TYPE) {
                return true;
            }
            if (eNTITY_TAG_TYPE == RestTemplate.ENTITY_TAG_TYPE.QUERY && RestUtils.valuesDifferent(string2 = restTemplate.getEntityTagQuery(), string = this._queryEditor.getText())) {
                return true;
            }
        }
        return false;
    }

    private class ConnnectionOpenListener
    implements IDBConnectionComboBoxListener {
        private ConnnectionOpenListener() {
        }

        public void connectionOpening() {
        }

        public void connectionOpened(Connection connection) {
            RestTemplatePanel.this._currQualConnName = Connections.getInstance().getConnectionName(connection);
            RestTemplatePanel.this.installCodeInsight(RestTemplatePanel.this._currQualConnName);
        }

        public void connectionFailed(RaptorTaskEvent raptorTaskEvent) {
            Throwable throwable = raptorTaskEvent.getThrowable();
            if (!(throwable instanceof ConnectionCanceledException) && throwable instanceof Exception) {
                ExceptionHandler.handleException((Throwable)((Exception)throwable));
                RestTemplatePanel.this._dbConnectionCB.setCurrentConnection(null);
            }
        }

        public void connectionCanceled(RaptorTaskEvent raptorTaskEvent) {
            Throwable throwable = raptorTaskEvent.getThrowable();
            if (!(throwable instanceof ConnectionCanceledException) && throwable instanceof Exception) {
                ExceptionHandler.handleException((Throwable)((Exception)throwable));
            }
        }
    }
}

