/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.patterns;

import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.StringBuilders;
import oracle.dbtools.rest.patterns.NamedPattern;
import oracle.dbtools.rest.patterns.ParserBase;
import oracle.dbtools.rest.patterns.PathToken;

class NamedPatternParser
extends ParserBase {
    NamedPatternParser(Reader reader) {
        super(reader);
    }

    @Override
    protected PathToken next() {
        PathToken.Type type = this.previousType();
        PathToken pathToken = null;
        try {
            if (type == null || PathToken.Type.SEPARATOR == type) {
                pathToken = this.literalOrParameter();
            } else {
                NamedPattern.Operator operator;
                boolean bl = false;
                if ((PathToken.Type.PARAMETER == type || PathToken.Type.COMPOUND_PARAMETER == type) && (operator = this.previousOperator()) != null) {
                    bl = true;
                }
                pathToken = bl ? this.eos() : this.separator();
            }
            if (pathToken != null) {
                this.previous(pathToken);
            }
            return pathToken;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private PathToken literalOrParameter() throws IOException {
        int n = this.r.read();
        if (n == -1) {
            return null;
        }
        char c = (char)n;
        if (':' == c) {
            boolean bl = false;
            boolean bl2 = false;
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            StringBuilder stringBuilder = new StringBuilder();
            NamedPattern.Operator operator = null;
            while (!bl) {
                n = this.r.read();
                if (n == -1) {
                    bl = true;
                    this.pushName(linkedHashSet, stringBuilder);
                    continue;
                }
                c = (char)n;
                if ('/' == c) {
                    bl = true;
                    this.r.unread(n);
                    this.pushName(linkedHashSet, stringBuilder);
                    continue;
                }
                if ('?' == c) {
                    bl = true;
                    this.pushName(linkedHashSet, stringBuilder);
                    operator = NamedPattern.Operator.OPTIONAL;
                    continue;
                }
                if ('*' == c) {
                    bl = true;
                    this.pushName(linkedHashSet, stringBuilder);
                    operator = NamedPattern.Operator.EAGER;
                    continue;
                }
                if (',' == c) {
                    bl2 = true;
                    this.pushName(linkedHashSet, stringBuilder);
                    continue;
                }
                this.addName(stringBuilder, c);
            }
            if (bl2) {
                return PathToken.compoundParameter(linkedHashSet, operator);
            }
            String string = (String)Iterables.first(linkedHashSet);
            if (string == null) {
                throw new NullPointerException();
            }
            return PathToken.parameter(string, operator);
        }
        this.r.unread(n);
        return this.literal();
    }

    private void pushName(Set<String> set, StringBuilder stringBuilder) {
        set.add(stringBuilder.toString());
        StringBuilders.reset((StringBuilder)stringBuilder);
    }

    private void addName(StringBuilder stringBuilder, char c) {
        if (!this.isLegalNameCharacter(c)) {
            throw this.error("" + c, "parameter name");
        }
        stringBuilder.append(c);
    }

    private boolean isLegalNameCharacter(char c) {
        return c == '-' || c == '_' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private NamedPattern.Operator previousOperator() {
        PathToken pathToken = super.previous();
        return pathToken == null ? null : pathToken.operator();
    }
}

