/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.icons.OracleIcons;

public class WizSummaryPanel
extends DefaultTraversablePanel {
    private JTree _summary = new JTree();

    public WizSummaryPanel() {
        this.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane();
        this._summary.setCellRenderer(new NodeRenderer());
        jScrollPane.setViewportView(this._summary);
        this.add(jScrollPane, new GridBagConstraints(0, 0, 5, 5, 1.0, 1.0, 18, 1, new Insets(10, 8, 0, 0), 0, 0));
    }

    private void buildSummaryTree(TraversableContext traversableContext) {
        this._summary.removeAll();
        Map map = (Map)traversableContext.get("ORDS_PARAMS");
        Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
        String string = this.getRootDescription(map2);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.getWarFileNode(map);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        defaultMutableTreeNode3 = this.getDBInfoNode(map2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        this._summary.setModel(new DefaultTreeModel(defaultMutableTreeNode));
        this._summary.expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
        if (defaultMutableTreeNode3 != null) {
            this._summary.expandPath(new TreePath(defaultMutableTreeNode3.getPath()));
        }
    }

    private DefaultMutableTreeNode getWarFileNode(Map<String, Object> map) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(RestArb.getString("WIZ_SUMMARY_WAR_FILE"));
        File file = (File)map.get("ords.warfile");
        String string = file != null ? file.getPath() : "";
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("WIZ_SUMMARY_WAR_FILE_NAME"), string)));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("WIZ_SUMMARY_WAR_VERSION"), (String)map.get("product.version"))));
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode getDBInfoNode(Map<String, String> map) {
        String string = map.get("db.connectionType");
        if (RestUtils.nullOrEmpty(string)) {
            string = "basic";
        }
        String string2 = null;
        string2 = "basic".equals(string) ? RestArb.getString("CONN_TYPE_BASIC") : ("tns".equals(string) ? RestArb.getString("CONN_TYPE_TNS") : ("customurl".equals(string) ? RestArb.getString("CONN_TYPE_CUSTOM") : RestArb.getString("CONN_TYPE_BASIC")));
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(RestArb.getString("WIZ_SUMMARY_DB_CONN"));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("USERNAME"), map.get("sys.user"))));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("CONN_TYPE"), string2)));
        if ("basic".equals(string)) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("HOST"), map.get("db.hostname"))));
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("PORT"), map.get("db.port"))));
            if (map.containsKey("db.sid")) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("SID"), map.get("db.sid"))));
            } else if (map.containsKey("db.servicename")) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("SERVICE_NAME"), map.get("db.servicename"))));
            }
        } else if ("tns".equals(string)) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("TNS_DIRECTORY"), map.get("db.tnsDirectory"))));
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("TNS_ALIAS_NAME"), map.get("db.tnsAliasName"))));
        } else if ("customurl".equals(string)) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("CUSTOM_URL"), map.get("db.customURL"))));
        }
        return defaultMutableTreeNode;
    }

    public JLabel getLabel(String string, boolean bl) {
        JLabel jLabel = new JLabel();
        jLabel.setText(string);
        if (bl) {
            jLabel.setIcon(OracleIcons.getIcon((String)"check.png"));
        } else {
            jLabel.setIcon(OracleIcons.getIcon((String)"delete.png"));
        }
        return jLabel;
    }

    public JLabel getLabel(String string) {
        JLabel jLabel = new JLabel();
        String string2 = string != null ? string : "";
        jLabel.setText(string2);
        return jLabel;
    }

    private String format(String string, String string2) {
        if (string2 != null && !string2.trim().isEmpty()) {
            return StringUtils.stripMnemonic((String)string) + " " + string2;
        }
        return string;
    }

    private String getRootDescription(Map<String, String> map) {
        String string = "";
        String string2 = map.get("installer");
        if (string2 != null) {
            if (string2.equals("uninstall") || string2.equals("cdb.uninstall")) {
                string = RestArb.getString("WIZ_UNINSTALL_SUMMARY_ROOT");
            } else if (string2.equals("validate") || string2.equals("cdb.validate")) {
                string = RestArb.getString("WIZ_REPAIR_SUMMARY_ROOT");
            }
        }
        return string;
    }

    public void onEntry(TraversableContext traversableContext) {
        if (traversableContext.getDirection() == 1) {
            this.buildSummaryTree(traversableContext);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
    }

    public class NodeRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof String) {
                jLabel.setText((String)object2);
                if (bl3) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"attribute.png"));
                }
                return jLabel;
            }
            return (Component)object2;
        }
    }
}

