/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install.wizard;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextPane;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.install.InstallDBUtils;
import oracle.dbtools.rest.install.InstallUtils;
import oracle.dbtools.rest.install.InstallValidator;
import oracle.dbtools.rest.install.RestInstallConstants;
import oracle.dbtools.rest.install.wizard.ConnectionPanel;
import oracle.dbtools.rest.install.wizard.InstallVerifySchemaDialog;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class InstallWizSchemaPanel
extends DefaultTraversablePanel {
    private static Logger logger = Logger.getLogger(InstallWizSchemaPanel.class.getName());
    private ConnectionPanel m_connPanel;
    private JLabel m_publicUsername = new JLabel();
    private JPasswordField m_publicPassword = new JPasswordField();
    private JPasswordField m_publicConfirmPassword = new JPasswordField();
    private JCheckBox m_skipInstall = new JCheckBox();
    private String m_prevConnUrl = "";
    private String m_prevProdVer = "";
    private String m_prevUserInfo = "";
    private boolean m_prevValidConn;
    private RestInstallConstants.InstallType m_installType;
    private String m_installer;
    private boolean m_isCDB;

    private void buildPanel(Map<String, String> map) {
        this.setLayout(new GridBagLayout());
        this.m_publicUsername.setText("ORDS_PUBLIC_USER");
        this.m_skipInstall.setSelected(false);
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_publicUsername, (String)StringUtils.stripMnemonic((String)RestArb.getString("USERNAME")));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.m_publicPassword, (String)RestArb.getString("PASSWORD"));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this.m_publicConfirmPassword, (String)RestArb.getString("CONFIRM_PASSWORD"));
        ResourceUtils.resButton((AbstractButton)this.m_skipInstall, (String)RestArb.getString("SKIP_INSTALL_SCHEMA"));
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText(RestArb.getString("WIZ_PUBLIC_USER_DESCRIP"));
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        int n = 0;
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.add((Component)jTextPane, LayoutControl.GBC.gbc((int)0, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_publicUsername, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jLabel2, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_publicPassword, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jLabel3, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_publicConfirmPassword, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)this.m_skipInstall, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        JPanel jPanel2 = LayoutControl.GBC.createTitledSubPanel((String)RestArb.getString("WIZ_TITLE_PUBLIC_USER"), (Component)jPanel);
        this.m_connPanel = new ConnectionPanel(map);
        JPanel jPanel3 = LayoutControl.GBC.createTitledSubPanel((String)RestArb.getString("WIZ_TITLE_DB_CONN"), (Component)this.m_connPanel);
        n = 0;
        this.add(jPanel2, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.add(jPanel3, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
        this.m_skipInstall.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    InstallWizSchemaPanel.this.enableDisablePublicUser();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void checkConnPanel(Map<String, String> map) {
        boolean bl;
        boolean bl2;
        String string = map.get("product.version");
        if (!this.m_prevProdVer.equalsIgnoreCase(string) && (bl2 = this.supportDiffConn(this.m_prevProdVer)) != (bl = this.supportDiffConn(string))) {
            this.m_connPanel.updateConnectionPanel(map);
        }
    }

    private boolean supportDiffConn(String string) {
        return !InstallUtils.nullOrEmpty(string) && !string.startsWith("3.0.") && !string.startsWith("17.") && !string.startsWith("18.") && !string.startsWith("19.1.") && !string.startsWith("19.2.");
    }

    private void enableDisablePublicUser() {
        this.m_publicUsername.setEnabled(!this.m_skipInstall.isSelected());
        this.m_publicPassword.setEnabled(!this.m_skipInstall.isSelected());
        this.m_publicConfirmPassword.setEnabled(!this.m_skipInstall.isSelected());
    }

    private void cdbVerifyExistingSchema(Map<String, String> map, String string, String string2, String string3) throws Exception {
        if (InstallDBUtils.isEarlierVersion(string3, "3.0.5.0.0")) {
            throw new TraversalException(RestArb.format("ERROR_INVALID_VERSION_CDB", string3, RestArb.getString("LABEL_LC_UPGRADE")));
        }
        if (InstallDBUtils.isEarlierVersion(string3, "18.1.1.0.0") && InstallUtils.nullOrEmpty(string2)) {
            throw new TraversalException(RestArb.getString("ERROR_USER_EXISTS_VERSION_MISSING"));
        }
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        if (InstallUtils.nullOrEmpty(string2) || string2.equals(string3)) {
            string4 = RestArb.getString("WIZ_VERIFY_CDB_PDBS_UPGRADE");
            string5 = RestArb.format("WIZ_VERIFY_CDB_UPGRADE_DESCRIP", string3);
            string6 = "verify_sysdba_priv_html";
            string7 = "cdb.upgrade";
        } else if (InstallDBUtils.isEarlierVersion(string2, string3)) {
            string4 = RestArb.getString("WIZ_VERIFY_UPGRADE");
            string5 = RestArb.format("WIZ_VERIFY_UPGRADE_DESCRIP", string3);
            string6 = "upgrade_sysdba_priv_html";
            string7 = "cdb.upgrade";
        }
        InstallVerifySchemaDialog installVerifySchemaDialog = new InstallVerifySchemaDialog(string4, string5, string6);
        Properties properties = this.m_connPanel.getProperties();
        if (installVerifySchemaDialog.checkSchema((Component)((Object)this), properties)) {
            map.put("sys.user", installVerifySchemaDialog.getUsername());
            String string8 = "@" + Passwords.goingOut((String)new String(installVerifySchemaDialog.getPassword()));
            map.put("sys.password", string8);
            map.put("db.url", string);
            map.put("installer", string7);
            Version version = installVerifySchemaDialog.getDBVersion();
            if (version != null) {
                map.put("full.db.version", version.toString());
            }
            if (installVerifySchemaDialog.existCommonPublicUser()) {
                map.put("cdb.common.user.public", "true");
            }
            if (installVerifySchemaDialog.existCommonMetadataUser()) {
                map.put("cdb.common.user.metadata", "true");
            }
        } else {
            throw new TraversalException(RestArb.format("WIZ_CANCEL_PRIV_USER", string3));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void nonCdbVerifyExistingSchema(Map<String, String> map, String string, String string2, String string3) throws Exception {
        if (InstallUtils.nullOrEmpty(string2)) {
            throw new TraversalException(RestArb.getString("ERROR_USER_EXISTS_VERSION_MISSING"));
        }
        if (InstallDBUtils.isEarlierVersion(string2, string3)) {
            Properties properties;
            InstallVerifySchemaDialog installVerifySchemaDialog = new InstallVerifySchemaDialog(RestArb.getString("WIZ_VERIFY_UPGRADE"), RestArb.format("WIZ_VERIFY_UPGRADE_DESCRIP", string3), "upgrade_sysdba_priv_html");
            if (!installVerifySchemaDialog.checkSchema((Component)((Object)this), properties = this.m_connPanel.getProperties())) throw new TraversalException(RestArb.format("WIZ_CANCEL_UPGRADE_USER", string3));
            String string4 = installVerifySchemaDialog.getSchemaVersion();
            if (string4.equals(string2)) {
                map.put("sys.user", installVerifySchemaDialog.getUsername());
                String string5 = "@" + Passwords.goingOut((String)new String(installVerifySchemaDialog.getPassword()));
                map.put("sys.password", string5);
                map.put("db.url", string);
                map.put("installer", "upgrade");
                map.put("schema.version", string2);
                return;
            } else {
                RestArb.format("ERR_MISMATCH_SCHEMA_VER", string2, installVerifySchemaDialog.getUsername(), string4);
            }
            return;
        } else {
            if (!string2.equals(string3)) return;
            map.put("installer", "none");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String verifySchemaVersion(TraversableContext traversableContext) throws TraversalException {
        Map map = (Map)traversableContext.get("ORDS_PARAMS");
        Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
        String string = null;
        String string2 = null;
        boolean bl = false;
        Connection connection = null;
        String string3 = (String)map.get("product.version");
        Properties properties = this.m_connPanel.getProperties();
        String string4 = InstallDBUtils.getUrl(properties);
        String string5 = null;
        String string6 = null;
        String string7 = properties.getProperty("db.connectionType");
        if ("tns".equals(string7)) {
            string5 = System.getProperty("oracle.net.tns_admin");
            string6 = properties.getProperty("db.tnsDirectory");
            if (InstallUtils.nullOrEmpty(string5) || !string6.equalsIgnoreCase(string5)) {
                System.setProperty("oracle.net.tns_admin", string6);
            }
        }
        try {
            connection = DriverManager.getConnection(string4, this.m_publicUsername.getText(), new String(this.m_publicPassword.getPassword()));
            string = InstallDBUtils.getORDSVersion(connection);
            if (!InstallUtils.nullOrEmpty(string) && InstallDBUtils.isEarlierVersion(string3, string)) {
                throw new TraversalException(RestArb.format("ERR_MISMATCH_VERSIONS", string3, string));
            }
            if (InstallDBUtils.isCDBRoot(connection)) {
                this.cdbVerifyExistingSchema(map2, string4, string, string3);
                this.m_isCDB = true;
            } else {
                this.nonCdbVerifyExistingSchema(map2, string4, string, string3);
                this.m_isCDB = false;
            }
            map2.put("schema.version", string);
        }
        catch (SQLException sQLException) {
            string2 = sQLException.getMessage();
            if (sQLException.getErrorCode() != 1017) {
                String string8 = RestArb.format("ERR_CONN_FAILED", this.m_publicUsername.getText(), string4, sQLException.getLocalizedMessage());
                logger.log(Level.WARNING, string8);
                throw new TraversalException(string8);
            }
            bl = true;
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            throw new TraversalException(exception.getLocalizedMessage());
        }
        finally {
            block31: {
                try {
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                    if (!"tns".equals(string7)) break block31;
                    if (InstallUtils.nullOrEmpty(string5)) {
                        System.clearProperty("oracle.net.tns_admin");
                        break block31;
                    }
                    if (!string6.equalsIgnoreCase(string5)) {
                        System.setProperty("oracle.net.tns_admin", string5);
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        if (!bl) return string;
        InstallVerifySchemaDialog installVerifySchemaDialog = new InstallVerifySchemaDialog();
        if (!installVerifySchemaDialog.checkSchema((Component)((Object)this), properties)) {
            String string9 = RestArb.format("WIZ_CANCEL_PRIV_USER", new Object[0]);
            throw new TraversalException(string9);
        }
        string = installVerifySchemaDialog.getSchemaVersion();
        if (InstallUtils.nullOrEmpty(string)) {
            if (installVerifySchemaDialog.isCDBRoot()) {
                try {
                    if (InstallDBUtils.isEarlierVersion(string3, "3.0.5.0.0")) {
                        throw new TraversalException(RestArb.format("ERROR_INVALID_VERSION_CDB", string3, RestArb.getString("LABEL_LC_INSTALL")));
                    }
                    this.m_isCDB = true;
                    if (installVerifySchemaDialog.existCommonPublicUser()) {
                        map2.put("cdb.common.user.public", "true");
                        map2.put("installer", "cdb.upgrade");
                    }
                    map2.put("installer", "install");
                }
                catch (Exception exception) {
                    throw new TraversalException(exception.getLocalizedMessage());
                }
            } else {
                this.m_isCDB = false;
                map2.put("installer", "install");
            }
            map2.put("sys.user", installVerifySchemaDialog.getUsername());
            String string10 = "@" + Passwords.goingOut((String)new String(installVerifySchemaDialog.getPassword()));
            map2.put("sys.password", string10);
            map2.put("schema.version", string);
            return string;
        }
        String string11 = RestArb.format("ERR_INVALID_PASSWORD", string, string2 != null ? string2 : "");
        throw new TraversalException(string11);
    }

    private void validateValues(TraversableContext traversableContext) throws TraversalException {
        Map map = (Map)traversableContext.get("ORDS_PARAMS");
        Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
        if (!this.m_skipInstall.isSelected()) {
            InstallValidator.validatePasswords(this.m_publicUsername.getText(), this.m_publicPassword, this.m_publicConfirmPassword);
            String string = this.m_publicUsername.getText() + "." + new String(this.m_publicPassword.getPassword());
            this.m_connPanel.validateValues();
            String string2 = InstallUtils.nullOrEmpty(this.m_prevUserInfo) ? "" : Passwords.comingIn((String)this.m_prevUserInfo);
            Properties properties = this.m_connPanel.getProperties();
            String string3 = InstallDBUtils.getUrl(properties);
            if (!(map2.containsKey("installer") && string.equals(string2) && string3.equals(this.m_prevConnUrl) && this.m_prevValidConn && !this.m_installer.equals("skip"))) {
                this.verifySchemaVersion(traversableContext);
            }
            string = null;
            string2 = null;
        } else {
            map2.put("installer", "skip");
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        Map map;
        Map map2;
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        if (traversableContext.getDirection() == 1 && (map2 = (Map)traversableContext.get("ORDS_PARAMS")) != null && map2.containsKey("INSTALL_KEY_PARAMS") && (map = (Map)map2.get("INSTALL_KEY_PARAMS")) != null) {
            if (this.m_connPanel == null) {
                this.buildPanel(map);
            } else {
                this.checkConnPanel(map);
            }
            if (this.m_skipInstall.isSelected()) {
                map.put("installer", "skip");
            }
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        Map map = (Map)traversableContext.get("ORDS_PARAMS");
        Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
        if (traversableContext.getDirection() == 1) {
            this.validateValues(traversableContext);
            this.m_installType = (RestInstallConstants.InstallType)((Object)map.get("config.status"));
            this.m_installer = (String)map2.get("installer");
            if (this.m_installer == null) {
                map2.put("installer", "skip");
            }
            if (this.m_installer.equals("skip")) {
                map2.put("rest.services.ords.add", "false");
            } else {
                map2.put("rest.services.ords.add", "true");
            }
            Properties properties = this.m_connPanel.getProperties();
            this.m_connPanel.setConnValues(map2, properties);
            String string = InstallDBUtils.getUrl(properties);
            map2.put("db.url", string);
            String string2 = this.m_publicUsername.getText();
            map2.put("user.name.public", string2);
            String string3 = "@" + Passwords.goingOut((String)new String(this.m_publicPassword.getPassword()));
            map2.put("user.public.password", string3);
            this.m_prevConnUrl = string;
            this.m_prevUserInfo = string2 + "." + new String(this.m_publicPassword.getPassword());
            this.m_prevUserInfo = Passwords.goingOut((String)this.m_prevUserInfo);
            this.m_prevProdVer = (String)map2.get("product.version");
        } else if (traversableContext.getDirection() == 2) {
            this.m_prevProdVer = (String)map2.get("product.version");
        }
    }

    public Object getExitTransition() {
        if (this.m_isCDB) {
            if (this.m_installer.equals("install") || this.m_installer.equals("upgrade") || this.m_installer.equals("cdb.upgrade")) {
                return "Transition.CdbOptions";
            }
        } else if (this.m_installer.equals("install")) {
            return "Transition.Tablespace";
        }
        switch (this.m_installType) {
            case REQUIRES_CONFIG: {
                return "Transition.PLSQLGateway";
            }
            case MIGRATE_V2: {
                return "Transition.Standalone";
            }
            case VERIFY_SCHEMA: {
                return "Transition.Standalone";
            }
        }
        return "Transition.Standalone";
    }
}

