/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install.wizard;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.install.InstallDBUtils;
import oracle.dbtools.rest.install.InstallUtils;
import oracle.dbtools.rest.install.InstallValidator;
import oracle.dbtools.rest.install.wizard.InstallVerifyUserDialog;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class InstallWizPLSQLGatewayPanel
extends DefaultTraversablePanel {
    private static final String APEX_PUBLIC_USER = "APEX_PUBLIC_USER";
    private JButton m_verifyBtn = new JButton();
    private JTextField m_gatewayUsername = new JTextField();
    private JPasswordField m_gatewayPassword = new JPasswordField();
    private JPasswordField m_gatewayConfirmPassword = new JPasswordField();
    private JCheckBox m_usePlsqlGateway = new JCheckBox();
    private String m_installer;
    private boolean m_canMigrateAPEXRest;

    public InstallWizPLSQLGatewayPanel() {
        this.buildPanel();
    }

    private void buildPanel() {
        this.setLayout(new GridBagLayout());
        this.m_usePlsqlGateway.setSelected(true);
        this.m_gatewayUsername.setText(APEX_PUBLIC_USER);
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        ResourceUtils.resButton((AbstractButton)this.m_verifyBtn, (String)RestArb.getString("VERIFY_BTN"));
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_gatewayUsername, (String)RestArb.getString("USERNAME"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.m_gatewayPassword, (String)RestArb.getString("PASSWORD"));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this.m_gatewayConfirmPassword, (String)RestArb.getString("CONFIRM_PASSWORD"));
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this.m_verifyBtn, (String)RestArb.getString("VERIFY_DB_USER"));
        ResourceUtils.resButton((AbstractButton)this.m_verifyBtn, (String)RestArb.getString("VERIFY_BTN"));
        ResourceUtils.resButton((AbstractButton)this.m_usePlsqlGateway, (String)RestArb.getString("USE_PLSQL_GATEWAY"));
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText(RestArb.getString("WIZ_PLSQL_GATEWAY_DESCRIP"));
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        int n = 0;
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.add((Component)jLabel4, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_verifyBtn, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
        n = 0;
        JPanel jPanel2 = LayoutControl.GBC.createPanel();
        jPanel2.add((Component)jTextPane, LayoutControl.GBC.gbc((int)0, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel2.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel2.add((Component)this.m_gatewayUsername, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel2.add((Component)jLabel2, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel2.add((Component)this.m_gatewayPassword, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel2.add((Component)jLabel3, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel2.add((Component)this.m_gatewayConfirmPassword, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel2.add((Component)jPanel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
        LayoutControl.GBC.addVSpring((JPanel)jPanel2, (int)(++n));
        JPanel jPanel3 = LayoutControl.GBC.createTitledSubPanel((String)RestArb.getString("WIZ_TITLE_PLSQL_GATEWAY"), (Component)jPanel2);
        n = 0;
        this.add(this.m_usePlsqlGateway, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
        this.add(jPanel3, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)((Object)this), (int)(++n));
        this.m_usePlsqlGateway.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    InstallWizPLSQLGatewayPanel.this.enableDisablePLSQLGateway();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void enableDisablePLSQLGateway() {
        this.m_gatewayUsername.setEnabled(this.m_usePlsqlGateway.isSelected());
        this.m_gatewayPassword.setEnabled(this.m_usePlsqlGateway.isSelected());
        this.m_gatewayConfirmPassword.setEnabled(this.m_usePlsqlGateway.isSelected());
        this.m_verifyBtn.setEnabled(this.m_usePlsqlGateway.isSelected());
    }

    protected void validateUsers(Map<String, String> map) {
        String string;
        String string2 = null;
        if ("tns".equals(map.get("db.connectionType")) && !InstallUtils.nullOrEmpty(map.get("db.tnsDirectory"))) {
            string2 = map.get("db.tnsDirectory");
        }
        if ((string = map.get("db.url")) == null || string.isEmpty()) {
            return;
        }
        try {
            this.validateValues();
        }
        catch (TraversalException traversalException) {
            MessageDialog.error((Component)((Object)this), (Object)traversalException.getMessage(), (String)RestArb.getString("VERIFY_DB_USER"), null);
            return;
        }
        boolean bl = false;
        String string3 = this.m_gatewayUsername.getText();
        String string4 = new String(this.m_gatewayPassword.getPassword());
        StringBuilder stringBuilder = new StringBuilder();
        String string5 = InstallDBUtils.validateConnection(string, string3, string4, string2);
        if (string5 != null) {
            stringBuilder.append(RestArb.format("ERR_CONN_FAILED", string3, string, string5)).append("\n");
            bl = true;
        } else {
            stringBuilder.append(RestArb.format("VALID_DB_CONN", string3, string)).append("\n\n");
        }
        if (bl) {
            String[] stringArray = new String[]{string3};
            boolean bl2 = false;
            Map<String, String> map2 = null;
            if (!map.containsKey("sys.user") && !map.containsKey("sys.password")) {
                InstallVerifyUserDialog installVerifyUserDialog = new InstallVerifyUserDialog();
                if (installVerifyUserDialog.checkUser((Component)((Object)this), string, stringArray, string2)) {
                    map2 = installVerifyUserDialog.getUserAccounts();
                    if (map2 == null) {
                        stringBuilder.append(RestArb.format("CANNOT_VERIFY_DB_ACCOUNT_STATUS", installVerifyUserDialog.getErrorMessage()));
                        bl2 = true;
                    }
                } else {
                    bl2 = true;
                }
            } else {
                try {
                    map2 = InstallDBUtils.getUserStatus(string, string2, InstallDBUtils.getDBAUsername(map.get("sys.user")), map.get("sys.password"), stringArray);
                }
                catch (Exception exception) {
                    stringBuilder.append(exception.getLocalizedMessage()).append("\n");
                }
            }
            if (!bl2) {
                if (map2 == null) {
                    stringBuilder.append(RestArb.format("ERROR_VERIFY_GATEWAY_ACCT", string3));
                } else {
                    if (map2.containsKey(string3.toUpperCase())) {
                        stringBuilder.append(RestArb.format("ACCOUNT_STATUS", string3, map2.get(string3)));
                    } else {
                        stringBuilder.append(RestArb.format("USER_NOT_FOUND", string3));
                    }
                    stringBuilder.append("\n");
                }
            }
        }
        MessageDialog.information((Component)((Object)this), (Object)stringBuilder.toString(), (String)RestArb.getString("VERIFY_DB_USER"), null);
    }

    private void validateValues() throws TraversalException {
        if (this.m_usePlsqlGateway.isSelected()) {
            if (this.m_gatewayUsername.getText() == null || this.m_gatewayUsername.getText().trim().length() == 0) {
                this.m_gatewayUsername.requestFocus();
                throw new TraversalException(RestArb.getString("ERROR_USERNAME_MISSING"));
            }
            InstallValidator.validatePasswords(this.m_gatewayUsername.getText(), this.m_gatewayPassword, this.m_gatewayConfirmPassword);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        if (traversableContext.getDirection() == 1) {
            ActionListener[] actionListenerArray;
            Map map = (Map)traversableContext.get("ORDS_PARAMS");
            final Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
            if (map2.get("db.username") != null) {
                this.m_gatewayUsername.setText((String)map2.get("db.username"));
            }
            if ((actionListenerArray = this.m_verifyBtn.getActionListeners()) != null) {
                for (ActionListener actionListener : actionListenerArray) {
                    this.m_verifyBtn.removeActionListener(actionListener);
                }
            }
            this.m_verifyBtn.addActionListener(new ActionListener(){
                final Map<String, String> params;
                {
                    this.params = map2;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    InstallWizPLSQLGatewayPanel.this.validateUsers(this.params);
                }
            });
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            Object object;
            this.validateValues();
            Map map = (Map)traversableContext.get("ORDS_PARAMS");
            Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
            this.m_installer = (String)map2.get("installer");
            if (this.m_usePlsqlGateway.isSelected()) {
                map2.put("plsql.gateway.add", "true");
            } else {
                map2.put("plsql.gateway.add", "false");
                map2.put("rest.services.apex.add", "false");
                this.m_canMigrateAPEXRest = false;
                if (this.m_installer.equals("install")) {
                    String string;
                    object = null;
                    if ("tns".equals(map2.get("db.connectionType")) && !InstallUtils.nullOrEmpty((String)map2.get("db.tnsDirectory"))) {
                        object = (String)map2.get("db.tnsDirectory");
                    }
                    String string2 = (String)map.get("product.version");
                    this.m_canMigrateAPEXRest = InstallDBUtils.canMigrateAPEXRest((String)map2.get("db.url"), (String)object, InstallDBUtils.getDBAUsername((String)map2.get("sys.user")), (String)map2.get("sys.password"), string2);
                    if (this.m_canMigrateAPEXRest && (string = InstallDBUtils.getAPEXVersion((String)map2.get("db.url"), InstallDBUtils.getDBAUsername((String)map2.get("sys.user")), string2)) != null) {
                        map.put("apex.version", string);
                    }
                }
            }
            map2.put("db.username", this.m_gatewayUsername.getText());
            object = "@" + Passwords.goingOut((String)new String(this.m_gatewayPassword.getPassword()));
            map2.put("db.password", object);
        }
    }

    public Object getExitTransition() {
        if (this.m_usePlsqlGateway.isSelected() && APEX_PUBLIC_USER.equals(this.m_gatewayUsername.getText())) {
            return "Transition.APEXUsers";
        }
        if (this.m_installer.equals("install") && this.m_canMigrateAPEXRest) {
            return "Transition.Migrate";
        }
        return "Transition.Features";
    }
}

