/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.install.RestVersionObject;

public class RestVersionTableModel
extends AbstractTableModel {
    public static final int NAME_COL = 0;
    public static final int MODE_COL = 1;
    public static final int VERSION_COL = 2;
    public static final int SELECT_COL = 3;
    private final String[] COLUMN_NAMES = new String[]{RestArb.getString("LABEL_NAME"), RestArb.getString("LABEL_MODE"), RestArb.getString("LABEL_VERSION"), RestArb.getString("LABEL_INSTALL_HDR")};
    protected List<RestVersionObject> data = new ArrayList<RestVersionObject>();

    public void addRow(String string, int n, String string2, String string3, String string4, String string5, Boolean bl, Boolean bl2) {
        this.data.add(new RestVersionObject(string, n, string2, string3, string4, string5, bl, bl2));
        this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
    }

    public void addRow(RestVersionObject restVersionObject) {
        this.data.add(restVersionObject);
        this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
    }

    public RestVersionObject getRowObject(int n) {
        RestVersionObject restVersionObject = this.data.get(n);
        return restVersionObject;
    }

    public List<RestVersionObject> getData() {
        return this.data;
    }

    public void removeAll() {
        this.data = new ArrayList<RestVersionObject>();
        this.fireTableDataChanged();
    }

    public void updateProcessSelection(boolean bl, String string) {
        if (this.getData() != null) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                RestVersionObject restVersionObject = this.getRowObject(i);
                if (restVersionObject == null) continue;
                String string2 = restVersionObject.getMode();
                String string3 = restVersionObject.getInstallType();
                boolean bl2 = string2.equals("MOUNTED") || string2.equals("READ ONLY") && !restVersionObject.getName().equals("PDB$SEED");
                boolean bl3 = false;
                if (string3 != null) {
                    switch (string) {
                        case "INSTALL": {
                            bl3 = string3.equals("INSTALL") || string3.equals("UPGRADE");
                            break;
                        }
                        case "UNINSTALL": {
                            bl3 = string3.equals("UNINSTALL");
                            break;
                        }
                        case "REPAIR": {
                            bl3 = string3.equals("REPAIR");
                        }
                    }
                }
                if (!bl3 || !bl2) continue;
                if (bl) {
                    restVersionObject.setEditable(false);
                    restVersionObject.setSelected(true);
                } else if (string2.equals("READ ONLY")) {
                    restVersionObject.setEditable(true);
                    restVersionObject.setSelected(false);
                } else {
                    restVersionObject.setEditable(false);
                    restVersionObject.setSelected(false);
                }
                this.fireTableCellUpdated(i, 3);
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return this.COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.COLUMN_NAMES[n];
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 3: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        RestVersionObject restVersionObject = this.data.get(n);
        switch (n2) {
            case 0: {
                return restVersionObject.getName();
            }
            case 1: {
                return restVersionObject.getMode();
            }
            case 2: {
                return restVersionObject.getDisplayVersion();
            }
            case 3: {
                return restVersionObject.isSelected();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        RestVersionObject restVersionObject;
        if (n2 == 3 && (restVersionObject = this.data.get(n)) != null) {
            return restVersionObject.isEditable();
        }
        return false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        RestVersionObject restVersionObject = this.data.get(n);
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (restVersionObject.isEditable()) {
                    restVersionObject.setSelected((Boolean)object);
                }
                this.fireTableCellUpdated(n, 3);
                break;
            }
        }
    }
}

