/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.editor;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.navigator.db.DBNavigatorManager;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.editor.IRestHandler;
import oracle.dbtools.rest.generators.RestCodeGenResults;
import oracle.dbtools.rest.model.RestResourceHandler;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.dbtools.rest.utils.RestValidator;
import oracle.dbtools.worksheet.ActionProvider;
import oracle.dbtools.worksheet.WorksheetAction;
import oracle.dbtools.worksheet.WorksheetCallback;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.WorksheetTaskWrapper;
import oracle.dbtools.worksheet.commands.CommandsResources;

public class RestSaveHandlerActionProvider
implements ActionProvider<Void> {
    public static final String SAVE_HANDLER_ID = "rest.SAVEHANDLER";
    private static final WorksheetAction SAVE_HANDLER_ACTION = WorksheetAction.createWorksheetAction((String)"rest.SAVEHANDLER", (WorksheetAction.ActionType)WorksheetAction.ActionType.BOTH, (int)4, (double)-1.1);
    private static final List<WorksheetAction> m_actions = new ArrayList<WorksheetAction>();
    private IRestHandler m_restHandler;

    public RestSaveHandlerActionProvider(IRestHandler iRestHandler) {
        SAVE_HANDLER_ACTION.getIdeAction(SAVE_HANDLER_ID).putValue("SmallIcon", (Object)CommandsResources.getIcon((String)"SAVE_ICON"));
        m_actions.add(SAVE_HANDLER_ACTION);
        this.m_restHandler = iRestHandler;
    }

    public boolean checkActionEnabled(String string, WorksheetContext worksheetContext) {
        String string2 = worksheetContext.getEditor().getText();
        return string2 != null && !string2.isEmpty() && string2.trim().length() != 0;
    }

    public int getActionsCount() {
        return m_actions.size();
    }

    public WorksheetAction getActionAt(int n) {
        return m_actions.get(n);
    }

    public int getPanelCount() {
        return 0;
    }

    public WorksheetResultPanel getPanelAt(int n) {
        return null;
    }

    public WorksheetTaskWrapper<Void> doAction(String string, final WorksheetContext worksheetContext) {
        if (SAVE_HANDLER_ID.equals(string)) {
            String string2 = RestArb.format("SAVING_REST_HANDLER", this.m_restHandler.getResourceHandler().getMethodType().getNLS());
            RestTask restTask = new RestTask(string2, worksheetContext.getConnectionName()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void doAction(Connection connection) throws SQLException {
                    RestResourceHandler restResourceHandler = RestSaveHandlerActionProvider.this.m_restHandler.getResourceHandler();
                    if (RestSaveHandlerActionProvider.this.validHandler(restResourceHandler)) {
                        String string = null;
                        try {
                            string = RaptorVersionTracker.getDbVersion((Connection)connection).toCanonicalString();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        RestCodeGenResults restCodeGenResults = new RestCodeGenResults(string);
                        String string2 = restCodeGenResults.generateHandler(RestSaveHandlerActionProvider.this.m_restHandler.getModuleName(), RestSaveHandlerActionProvider.this.m_restHandler.getURITemplate(), restResourceHandler, true);
                        if (!RestUtils.nullOrEmpty(string2)) {
                            ISQLCommand[] iSQLCommandArray;
                            ScriptParser scriptParser = new ScriptParser(string2, connection);
                            scriptParser.parse();
                            for (ISQLCommand iSQLCommand : iSQLCommandArray = scriptParser.getSqlStatements()) {
                                String string3 = iSQLCommand.getSql().replace("\r", " ");
                                try (PreparedStatement preparedStatement = connection.prepareStatement(string3);){
                                    preparedStatement.execute();
                                    RestSaveHandlerActionProvider.this.m_restHandler.setPersistedObject(restResourceHandler);
                                }
                            }
                        } else {
                            throw new SQLException(RestArb.format("ERROR_CODE_GEN_FAILED", RestSaveHandlerActionProvider.this.m_restHandler.getResourceHandler().getMethodType().getNLS(), RestSaveHandlerActionProvider.this.m_restHandler.getURITemplate(), RestSaveHandlerActionProvider.this.m_restHandler.getModuleName()));
                        }
                    }
                }

                public String getQuery() {
                    return worksheetContext.getEditor().getText();
                }
            };
            return new WorksheetTaskWrapper((RaptorTask)restTask, Collections.singletonList(new RestTaskListener(worksheetContext.getCallback(), this.m_restHandler)), null, worksheetContext);
        }
        return null;
    }

    private boolean validHandler(RestResourceHandler restResourceHandler) throws SQLException {
        RestValidator restValidator = new RestValidator();
        boolean bl = restValidator.isValidHandler(this.m_restHandler.getModuleName(), this.m_restHandler.getURITemplate(), restResourceHandler);
        if (!bl) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(RestArb.getString("VALIDATE_HEADER")).append("\n\n").append(restValidator.getErrorMessages());
            throw new SQLException(stringBuilder.toString());
        }
        return bl;
    }

    private static abstract class RestTask
    extends DatabaseQueryTask<Void> {
        private String m_conn;

        private RestTask(String string, String string2) {
            super(string, IRaptorTaskRunMode.TASKVIEWER, false, false);
            this.m_conn = string2;
        }

        public String getConnectionName() {
            return this.m_conn;
        }

        protected Void doWork() throws TaskException {
            Connections connections = Connections.getInstance();
            connections.lock(this.m_conn);
            try {
                Connection connection = connections.getConnection(this.m_conn);
                this.doAction(connection);
            }
            catch (Exception exception) {
                throw new TaskException((Throwable)exception);
            }
            finally {
                connections.unlock(this.m_conn);
            }
            return null;
        }

        protected abstract void doAction(Connection var1) throws SQLException;
    }

    private static class RestTaskListener
    extends RaptorTaskAdapter {
        private String passedMsg;
        private String failedMsg;
        private WorksheetCallback m_worksheetCallback;
        private IRestHandler m_restHandler;

        private RestTaskListener(WorksheetCallback worksheetCallback, IRestHandler iRestHandler) {
            assert (worksheetCallback != null);
            this.passedMsg = RestArb.format("SAVE_HANDLER_SUCCESS", iRestHandler.getResourceHandler().getMethodType().getNLS(), iRestHandler.getURITemplate(), iRestHandler.getModuleName());
            this.failedMsg = RestArb.format("SAVE_HANDLER_FAIL", iRestHandler.getResourceHandler().getMethodType().getNLS(), iRestHandler.getURITemplate(), iRestHandler.getModuleName());
            this.m_worksheetCallback = worksheetCallback;
            this.m_restHandler = iRestHandler;
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            this.taskFailed(raptorTaskEvent);
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    m_worksheetCallback.setStatusMessage(failedMsg, null);
                }
            });
            Throwable throwable = raptorTaskEvent.getThrowable();
            if (throwable instanceof Exception) {
                ExceptionHandler.handleException((Throwable)((Exception)throwable));
            }
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NavigatorTreeNode navigatorTreeNode;
                    NavigatorTree navigatorTree;
                    NavigatorWindow navigatorWindow = DBNavigatorManager.getInstance().getNavigatorWindow();
                    if (navigatorWindow != null && (navigatorTree = navigatorWindow.getTree()) != null && (navigatorTreeNode = navigatorTree.findTreeNode(m_restHandler.getParentURL(), navigatorTree.getRoot())) != null) {
                        navigatorTree.refresh(navigatorTreeNode);
                    }
                    m_worksheetCallback.setStatusMessage(passedMsg, null);
                }
            });
        }
    }
}

