/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.connection;

import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.http.SessionException;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.connection.RestConnErrorDialog;
import oracle.dbtools.rest.connection.RestConnection;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestPrivilege;
import oracle.dbtools.rest.utils.RestCache;
import oracle.dbtools.rest.utils.RestJSONUtil;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.dbtools.rest.utils.RestXMLUtil;
import oracle.javatools.dialogs.MessageDialog;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class RestUpload {
    private static final ContentType XML_CONTENT_TYPE = ContentType.parse((CharSequence)"application/vnd.oracle.apex+xml; charset=UTF-8");
    private static String _errMsg;
    private String _entityTag;
    private String _location;

    public static boolean uploadModule(List<RestModule> list) {
        if (list != null) {
            RestModule restModule;
            boolean bl = false;
            Iterator<RestModule> iterator = list.iterator();
            while (iterator.hasNext() && (bl = RestUpload.uploadModule(restModule = iterator.next()))) {
            }
            return bl;
        }
        return false;
    }

    public static boolean uploadModule(RestModule restModule, boolean bl) {
        if (restModule == null) {
            return false;
        }
        if (bl && RestUtils.emptyValue(restModule.getEntityTag()) && RestCache.getInstance().containsModule(restModule.getName())) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(RestArb.format("OBJECT_EXIST_UPDATE", RestArb.getString("LABEL_MODULE_LC"), restModule.getName())).append(System.getProperty("line.separator")).append(RestArb.getString("QUESTION_CONTINUE"));
            boolean bl2 = MessageDialog.confirm(null, (Object)stringBuilder.toString(), (String)RestArb.getString("REST_ADMIN_TITLE"), null);
            if (bl2) {
                RestModule restModule2 = RestCache.getInstance().getModule(restModule.getName());
                restModule.setURL(restModule2.getURL());
                restModule.setEntityTag(restModule2.getEntityTag());
            } else {
                return false;
            }
        }
        return RestUpload.uploadModule(restModule);
    }

    public static boolean uploadModule(final RestModule restModule) {
        if (restModule == null) {
            return false;
        }
        _errMsg = null;
        boolean bl = false;
        RestUpload restUpload = new RestUpload();
        bl = restModule.getURL() == null || restModule.getURL().isEmpty() ? restUpload.uploadNewModule(restModule) : restUpload.uploadExistingModule(restModule);
        if (bl) {
            if (restUpload.getEntityTag() != null) {
                restModule.setEntityTag(restUpload.getEntityTag());
            } else {
                Logger.getLogger(RestUpload.class.getName()).log(Level.WARNING, "Entity Tag is Missing.");
            }
            RestUpload.runOnEDT(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.information(null, (Object)RestArb.format("REST_STATUS", RestArb.getString("LABEL_MODULE"), restModule.getName(), RestArb.getString("UPLOADED")), (String)RestArb.getString("REST_ADMIN_TITLE"), null);
                }
            });
        } else {
            final String string = RestUtils.emptyValue(restUpload.getErrorMessage()) ? RestArb.format("ERROR_UPLOAD", RestArb.getString("LABEL_MODULE"), restModule.getName()) : restUpload.getErrorMessage();
            RestUpload.runOnEDT(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.error(null, (Object)string, (String)RestArb.getString("REST_ADMIN_TITLE"), null);
                }
            });
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean uploadNewModule(RestModule restModule) {
        boolean bl = false;
        if (restModule != null && RestConnection.getInstance().isConnectionOpen()) {
            StringEntity stringEntity = null;
            stringEntity = new StringEntity(RestXMLUtil.resourceModuletoXML(restModule), XML_CONTENT_TYPE, false);
            HttpPost httpPost = RestConnection.getInstance().getConnection().createPost("/rt/modules/");
            httpPost.setEntity((HttpEntity)stringEntity);
            bl = this.upload((HttpUriRequest)httpPost);
            if (bl) {
                restModule.setURL(this._location);
            } else {
                String string = RestArb.format("ERROR_UPLOAD", RestArb.getString("LABEL_MODULE"), restModule.getName());
                String string2 = _errMsg = _errMsg == null ? string : string + "\n" + _errMsg;
            }
            if (stringEntity == null) return bl;
            try {
                EntityUtils.consume((HttpEntity)stringEntity);
                return bl;
            }
            catch (Exception exception) {
                stringEntity = null;
            }
            return bl;
            catch (Exception exception) {
                try {
                    RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), RestArb.format("ERROR_UPLOAD", RestArb.getString("LABEL_MODULE"), restModule.getName()), exception);
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, RestArb.format("ERROR_UPLOAD", RestArb.getString("LABEL_MODULE"), restModule.getName()) + "\n" + exception.getMessage());
                    if (stringEntity == null) return bl;
                }
                catch (Throwable throwable) {
                    if (stringEntity == null) throw throwable;
                    try {
                        EntityUtils.consume(stringEntity);
                        throw throwable;
                    }
                    catch (Exception exception2) {
                        stringEntity = null;
                    }
                    throw throwable;
                }
                try {
                    EntityUtils.consume((HttpEntity)stringEntity);
                    return bl;
                }
                catch (Exception exception3) {
                    stringEntity = null;
                }
                return bl;
            }
        }
        String string = RestArb.format("ERROR_UPLOAD", "LABEL_MODULE", restModule.getName()).concat(System.getProperty("line.separator")).concat(RestConnection.getInstance().getConnectionError());
        RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), string);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean uploadExistingModule(RestModule restModule) {
        boolean bl = false;
        if (RestConnection.getInstance().isConnectionOpen()) {
            StringEntity stringEntity = null;
            stringEntity = new StringEntity(RestXMLUtil.resourceModuletoXML(restModule), XML_CONTENT_TYPE, false);
            HttpPut httpPut = RestConnection.getInstance().getConnection().createPut(new URI(restModule.getURL()));
            httpPut.setEntity((HttpEntity)stringEntity);
            bl = this.upload((HttpUriRequest)httpPut);
            if (!bl) {
                String string = RestArb.format("ERROR_UPLOAD", RestArb.getString("LABEL_MODULE"), restModule.getName());
                String string2 = _errMsg = _errMsg == null ? string : string + "\n" + _errMsg;
            }
            if (stringEntity == null) return bl;
            try {
                EntityUtils.consume((HttpEntity)stringEntity);
                return bl;
            }
            catch (Exception exception) {
                stringEntity = null;
            }
            return bl;
            catch (Exception exception) {
                try {
                    RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), RestArb.format("ERROR_UPLOAD", RestArb.getString("LABEL_MODULE"), restModule.getName()), exception);
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, RestArb.format("ERROR_UPLOAD", RestArb.getString("LABEL_MODULE"), restModule.getName()) + "\n" + exception.getMessage());
                    if (stringEntity == null) return bl;
                }
                catch (Throwable throwable) {
                    if (stringEntity == null) throw throwable;
                    try {
                        EntityUtils.consume(stringEntity);
                        throw throwable;
                    }
                    catch (Exception exception2) {
                        stringEntity = null;
                    }
                    throw throwable;
                }
                try {
                    EntityUtils.consume((HttpEntity)stringEntity);
                    return bl;
                }
                catch (Exception exception3) {
                    stringEntity = null;
                }
                return bl;
            }
        }
        String string = RestArb.format("ERROR_UPLOAD", "LABEL_MODULE", restModule.getName()).concat(System.getProperty("line.separator")).concat(RestConnection.getInstance().getConnectionError());
        RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), string);
        return bl;
    }

    public static boolean uploadPrivilege(List<RestPrivilege> list) {
        if (list != null) {
            RestPrivilege restPrivilege;
            boolean bl = false;
            Iterator<RestPrivilege> iterator = list.iterator();
            while (iterator.hasNext() && (bl = RestUpload.uploadPrivilege(restPrivilege = iterator.next()))) {
            }
            return bl;
        }
        return false;
    }

    public static boolean uploadPrivilege(RestPrivilege restPrivilege, boolean bl) {
        if (restPrivilege == null) {
            return false;
        }
        if (bl && RestUtils.emptyValue(restPrivilege.getEntityTag()) && RestCache.getInstance().containsPrivilege(restPrivilege.getName())) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(RestArb.format("OBJECT_EXIST_UPDATE", RestArb.getString("LABEL_PRIVILEGE_LC"), restPrivilege.getName())).append(System.getProperty("line.separator")).append(RestArb.getString("QUESTION_CONTINUE"));
            boolean bl2 = MessageDialog.confirm(null, (Object)stringBuilder.toString(), (String)RestArb.getString("REST_ADMIN_TITLE"), null);
            if (bl2) {
                RestPrivilege restPrivilege2 = RestCache.getInstance().getPrivilege(restPrivilege.getName());
                restPrivilege.setURL(restPrivilege2.getURL());
                restPrivilege.setEntityTag(restPrivilege2.getEntityTag());
            } else {
                return false;
            }
        }
        return RestUpload.uploadPrivilege(restPrivilege);
    }

    public static boolean uploadPrivilege(final RestPrivilege restPrivilege) {
        if (restPrivilege == null) {
            return false;
        }
        _errMsg = null;
        boolean bl = false;
        RestUpload restUpload = new RestUpload();
        bl = restPrivilege.getURL() == null || restPrivilege.getURL().isEmpty() ? restUpload.uploadNewPrivilege(restPrivilege) : restUpload.uploadExistingPrivilege(restPrivilege);
        if (bl) {
            if (restUpload.getEntityTag() != null) {
                restPrivilege.setEntityTag(restUpload.getEntityTag());
            }
            RestUpload.runOnEDT(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.information(null, (Object)RestArb.format("REST_STATUS", RestArb.getString("LABEL_PRIVILEGE"), restPrivilege.getName(), RestArb.getString("UPLOADED")), (String)RestArb.getString("REST_ADMIN_TITLE"), null);
                }
            });
        } else {
            final String string = RestUtils.emptyValue(restUpload.getErrorMessage()) ? RestArb.format("ERROR_UPLOAD", RestArb.getString("LABEL_PRIVILEGE"), restPrivilege.getName()) : restUpload.getErrorMessage();
            RestUpload.runOnEDT(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.error(null, (Object)string, (String)RestArb.getString("REST_ADMIN_TITLE"), null);
                }
            });
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean uploadNewPrivilege(RestPrivilege restPrivilege) {
        boolean bl = false;
        if (restPrivilege != null && RestConnection.getInstance().isConnectionOpen()) {
            StringEntity stringEntity = null;
            stringEntity = new StringEntity(RestJSONUtil.restPrivilegetoJSON(restPrivilege), ContentType.APPLICATION_JSON, false);
            HttpPost httpPost = RestConnection.getInstance().getConnection().createPost("/oauth2/scopes/");
            httpPost.setEntity((HttpEntity)stringEntity);
            bl = this.upload((HttpUriRequest)httpPost);
            if (bl) {
                restPrivilege.setURL(this._location);
            } else {
                String string = RestArb.format("ERROR_UPLOAD", RestArb.getString("LABEL_PRIVILEGE"), restPrivilege.getName());
                String string2 = _errMsg = _errMsg == null ? string : string + "\n" + _errMsg;
            }
            if (stringEntity == null) return bl;
            try {
                EntityUtils.consume((HttpEntity)stringEntity);
                return bl;
            }
            catch (Exception exception) {
                stringEntity = null;
            }
            return bl;
            catch (Exception exception) {
                try {
                    String string = RestArb.format("ERROR_UPLOAD", RestArb.getString("LABEL_PRIVILEGE"), restPrivilege.getName());
                    RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), string, exception);
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, RestArb.format("ERROR_UPLOAD", RestArb.getString("LABEL_PRIVILEGE"), restPrivilege.getName()) + "\n" + exception.getMessage());
                    if (stringEntity == null) return bl;
                }
                catch (Throwable throwable) {
                    if (stringEntity == null) throw throwable;
                    try {
                        EntityUtils.consume(stringEntity);
                        throw throwable;
                    }
                    catch (Exception exception2) {
                        stringEntity = null;
                    }
                    throw throwable;
                }
                try {
                    EntityUtils.consume((HttpEntity)stringEntity);
                    return bl;
                }
                catch (Exception exception3) {
                    stringEntity = null;
                }
                return bl;
            }
        }
        String string = RestArb.format("ERROR_UPLOAD", "LABEL_PRIVILEGE", restPrivilege.getName()).concat(System.getProperty("line.separator")).concat(RestConnection.getInstance().getConnectionError());
        RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), string);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean uploadExistingPrivilege(RestPrivilege restPrivilege) {
        boolean bl = false;
        if (restPrivilege != null && RestConnection.getInstance().isConnectionOpen()) {
            StringEntity stringEntity = null;
            stringEntity = new StringEntity(RestJSONUtil.restPrivilegetoJSON(restPrivilege), ContentType.APPLICATION_JSON, false);
            HttpPut httpPut = RestConnection.getInstance().getConnection().createPut(new URI(restPrivilege.getURL()));
            httpPut.setEntity((HttpEntity)stringEntity);
            bl = this.upload((HttpUriRequest)httpPut);
            if (!bl) {
                String string = RestArb.format("ERROR_UPLOAD", RestArb.getString("LABEL_PRIVILEGE"), restPrivilege.getName());
                String string2 = _errMsg = _errMsg == null ? string : string + "\n" + _errMsg;
            }
            if (stringEntity == null) return bl;
            try {
                EntityUtils.consume((HttpEntity)stringEntity);
                return bl;
            }
            catch (Exception exception) {
                stringEntity = null;
            }
            return bl;
            catch (Exception exception) {
                try {
                    String string = RestArb.format("ERROR_UPLOAD", RestArb.getString("LABEL_PRIVILEGE"), restPrivilege.getName());
                    RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), string, exception);
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, RestArb.format("ERROR_UPLOAD", RestArb.getString("LABEL_PRIVILEGE"), restPrivilege.getName()) + "\n" + exception.getMessage());
                    if (stringEntity == null) return bl;
                }
                catch (Throwable throwable) {
                    if (stringEntity == null) throw throwable;
                    try {
                        EntityUtils.consume(stringEntity);
                        throw throwable;
                    }
                    catch (Exception exception2) {
                        stringEntity = null;
                    }
                    throw throwable;
                }
                try {
                    EntityUtils.consume((HttpEntity)stringEntity);
                    return bl;
                }
                catch (Exception exception3) {
                    stringEntity = null;
                }
                return bl;
            }
        }
        String string = RestArb.format("ERROR_UPLOAD", "LABEL_PRIVILEGE", restPrivilege.getName()).concat(System.getProperty("line.separator")).concat(RestConnection.getInstance().getConnectionError());
        RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), string);
        return bl;
    }

    private boolean upload(HttpUriRequest httpUriRequest) throws SessionException {
        this._entityTag = null;
        httpUriRequest.addHeader("Accept-Language", (Object)Locale.getDefault().toString());
        boolean bl = (Boolean)RestConnection.getInstance().getConnection().executeRequest(httpUriRequest, (HttpClientResponseHandler)new HttpClientResponseHandler<Boolean>(){

            public Boolean handleResponse(ClassicHttpResponse classicHttpResponse) {
                String string;
                Object object;
                int n = classicHttpResponse.getCode();
                if (n == 200 || n == 201) {
                    Header header = classicHttpResponse.getFirstHeader("ETag");
                    if (header != null) {
                        RestUpload.this._entityTag = header.getValue();
                    }
                    RestUpload.this._location = (header = classicHttpResponse.getFirstHeader("Location")) != null ? header.getValue() : null;
                    return new Boolean(true);
                }
                Object object2 = "";
                Header header = classicHttpResponse.getFirstHeader("Error-Reason");
                if (header != null && !RestUtils.emptyValue((String)(object = header.getValue())) && !RestUtils.emptyValue(string = RestConnection.getInstance().getErrorReasonDetails((String)object))) {
                    object2 = "\n" + string;
                }
                object = RestArb.format("RESPONSE_STATUS", Integer.toString(n), classicHttpResponse.getReasonPhrase()) + (String)object2;
                RestUpload.this.setErrorMessage((String)object);
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, (String)object);
                return new Boolean(false);
            }
        });
        return bl;
    }

    private void setErrorMessage(String string) {
        _errMsg = string;
    }

    public String getErrorMessage() {
        if (_errMsg != null) {
            return _errMsg;
        }
        return "";
    }

    private String getEntityTag() {
        return this._entityTag;
    }

    private static void runOnEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

