/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.autorest.ui;

import java.awt.Component;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class CheckBoxTableCellRendererEditor
extends JCheckBox
implements TableCellEditor,
TableCellRenderer {
    transient Border noFocusBorder;
    transient Border focusBorder;

    public CheckBoxTableCellRendererEditor() {
        this.setOpaque(true);
        this.setBorderPainted(true);
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (bl) {
            this.setForeground(jTable.getSelectionForeground());
            this.setBackground(jTable.getSelectionBackground());
        } else {
            this.setForeground(jTable.getForeground());
            this.setBackground(jTable.getBackground());
        }
        if (this.focusBorder == null) {
            this.focusBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
        }
        this.setBorder(this.focusBorder);
        this.setSelected(object == null ? Boolean.FALSE : Boolean.valueOf(object.toString()));
        return this;
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.add(CellEditorListener.class, cellEditorListener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.remove(CellEditorListener.class, cellEditorListener);
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public Object getCellEditorValue() {
        Boolean bl = this.isSelected();
        return bl;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return false;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    protected void fireEditingStopped() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CellEditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)objectArray[i + 1]).editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CellEditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)objectArray[i + 1]).editingCanceled(this.changeEvent);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (bl) {
            this.setForeground(jTable.getSelectionForeground());
            this.setBackground(jTable.getSelectionBackground());
        } else {
            this.setForeground(jTable.getForeground());
            this.setBackground(jTable.getBackground());
        }
        if (this.focusBorder == null) {
            this.focusBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
        }
        if (bl2) {
            this.setBorder(this.focusBorder);
        } else {
            if (this.noFocusBorder == null) {
                this.noFocusBorder = new EmptyBorder(this.focusBorder.getBorderInsets(this));
            }
            this.setBorder(this.noFocusBorder);
        }
        this.setSelected(Boolean.TRUE.equals(object));
        this.setEnabled(jTable.isEnabled());
        return this;
    }
}

